/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt.transport;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.base.PeerID;
import org.glassfish.shoal.gms.logging.GMSLogDomain;
import org.glassfish.shoal.gms.mgmt.transport.AbstractMulticastMessageSender;
import org.glassfish.shoal.gms.mgmt.transport.Message;
import org.glassfish.shoal.gms.mgmt.transport.MessageSender;
import org.glassfish.shoal.gms.mgmt.transport.NetworkManager;

public class VirtualMulticastSender
extends AbstractMulticastMessageSender {
    private static final Logger LOG = GMSLogDomain.getNoMCastLogger();
    final Set<PeerID> virtualPeerIdList = new CopyOnWriteArraySet<PeerID>();
    final NetworkManager networkManager;
    final Map<PeerID, Long> lastReportedSendFailure = new ConcurrentHashMap<PeerID, Long>();
    static final long LAST_REPORTED_FAILURE_DURATION_MS = 10000L;
    final long DISCOVERY_PERIOD_COMPLETED_TIME;
    boolean discoveryCleanupPending = true;

    public VirtualMulticastSender(NetworkManager networkManager, List<PeerID> initialPeerIds) throws IOException {
        this.networkManager = networkManager;
        if (initialPeerIds != null && !initialPeerIds.isEmpty()) {
            this.virtualPeerIdList.addAll(initialPeerIds);
        }
        this.DISCOVERY_PERIOD_COMPLETED_TIME = System.currentTimeMillis() + 10000L;
    }

    public Set<PeerID> getVirtualPeerIDSet() {
        return this.virtualPeerIdList;
    }

    @Override
    public synchronized void start() throws IOException {
    }

    @Override
    public synchronized void stop() throws IOException {
        this.virtualPeerIdList.clear();
    }

    @Override
    protected boolean doBroadcast(Message message) throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering(this.getClass().getSimpleName(), "doBroadcast", new Object[]{message});
            LOG.finer("VirtualMulticastSender.doBroadcast() virtualPeerIdList = " + String.valueOf(this.virtualPeerIdList));
        }
        boolean result = true;
        MessageSender tcpSender = this.networkManager.getMessageSender(0);
        if (this.discoveryCleanupPending && this.DISCOVERY_PERIOD_COMPLETED_TIME - System.currentTimeMillis() < 0L) {
            this.discoveryCleanupPending = false;
            this.removeUnknownInstances();
        }
        for (PeerID peerID : this.virtualPeerIdList) {
            try {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "VirtualMulticastSender.doBroadcast prepare to send msg to peerID " + String.valueOf(peerID));
                }
                if (!tcpSender.send(peerID, message)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "VirtualMulticastSender.doBroadcast failed to send msg to peerID " + String.valueOf(peerID));
                    }
                    result = false;
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.log(Level.FINEST, "VirtualMulticastSender.doBroadcast succeded to send msg to peerID " + String.valueOf(peerID));
            }
            catch (IOException ie) {
                Long lastFail = this.lastReportedSendFailure.get(peerID);
                long currentTime = System.currentTimeMillis();
                if (lastFail == null || lastFail - currentTime > 10000L) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "failed to send message to a virtual multicast endpoint[" + String.valueOf(peerID) + "] message=[" + String.valueOf(message) + "]", ie);
                    }
                    this.lastReportedSendFailure.put(peerID, currentTime);
                }
                this.purge();
            }
        }
        return result;
    }

    public void removeUnknownInstances() {
        boolean removed = false;
        LinkedList<PeerID> unknownList = new LinkedList<PeerID>();
        for (PeerID id : this.virtualPeerIdList) {
            if (!id.getInstanceName().startsWith("Unknown_")) continue;
            removed = true;
            unknownList.add(id);
        }
        if (removed) {
            this.virtualPeerIdList.removeAll(unknownList);
        }
        if (removed && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removed the following DISCOVERY seeded unknown instance names from virtualPeerIDList" + String.valueOf(unknownList) + " virtualPeerIDset=" + String.valueOf(this.virtualPeerIdList));
        }
    }

    private void purge() {
        Iterator<Map.Entry<PeerID, Long>> iter = this.lastReportedSendFailure.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<PeerID, Long> e = iter.next();
            if (e.getValue() - System.currentTimeMillis() <= 10000L) continue;
            iter.remove();
        }
    }
}

