/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpBrokenContent;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.io.InputBuffer;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.Request;

public class ServerInputBuffer
extends InputBuffer {
    private volatile long totalReadContentInBytes;
    private volatile Request serverRequest;

    public void initialize(Request serverRequest, FilterChainContext ctx) {
        this.serverRequest = serverRequest;
        super.initialize(serverRequest.getRequest(), ctx);
    }

    @Override
    public void initiateAsyncronousDataReceiving() {
        if (!this.checkChunkedMaxPostSize()) {
            Request localServerRequest = this.serverRequest;
            if (localServerRequest == null) {
                throw new IllegalStateException("ServerInputBuffer is not initialized in a Request");
            }
            HttpBrokenContent brokenContent = HttpBrokenContent.builder(localServerRequest.getRequest()).error(new IOException("The HTTP request content exceeds max post size")).build();
            try {
                this.append(brokenContent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        super.initiateAsyncronousDataReceiving();
    }

    @Override
    protected HttpContent blockingRead() throws IOException {
        if (!this.checkChunkedMaxPostSize()) {
            throw new IOException("The HTTP request content exceeds max post size");
        }
        return super.blockingRead();
    }

    @Override
    protected void updateInputContentBuffer(Buffer buffer) throws IOException {
        if (!this.initialized()) {
            buffer.dispose();
            throw new IOException("ServerInputBuffer is not initialized");
        }
        this.totalReadContentInBytes += (long)buffer.remaining();
        super.updateInputContentBuffer(buffer);
    }

    @Override
    public void recycle() {
        this.serverRequest = null;
        this.totalReadContentInBytes = 0L;
        super.recycle();
    }

    @Override
    protected Executor getThreadPool() {
        Request localServerRequest = this.serverRequest;
        return localServerRequest != null ? localServerRequest.getRequestExecutor() : null;
    }

    private boolean checkChunkedMaxPostSize() {
        Request localServerRequest = this.serverRequest;
        if (localServerRequest == null) {
            throw new IllegalStateException("ServerInputBuffer is not initialized in a Request");
        }
        HttpRequestPacket httpRequest = localServerRequest.getRequest();
        if (httpRequest == null) {
            throw new IllegalStateException("HttpRequestPacket is not initialized in a Request");
        }
        if (httpRequest.isChunked()) {
            HttpServerFilter httpServerFilter = localServerRequest.getHttpFilter();
            if (httpServerFilter == null) {
                throw new IllegalStateException("HttpServerFilter is not initialized in a Request");
            }
            long maxPostSize = httpServerFilter.getConfiguration().getMaxPostSize();
            return maxPostSize < 0L || maxPostSize > this.totalReadContentInBytes;
        }
        return true;
    }

    private boolean initialized() {
        return this.serverRequest != null;
    }
}

