/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.TSXAConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.Util;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.Reference;
import javax.security.auth.Subject;

public class XAManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
Referenceable {
    private Reference reference;
    private ResourceAdapter resourceAdapter;
    private String TSRValue;
    private int count;
    private String password;
    private String user;
    private String userName;

    public String getUser() {
        System.out.println("XAManagedConnectionFactory.getUser() returning:  " + this.user);
        return this.user;
    }

    public void setUser(String val) {
        System.out.println("XAManagedConnectionFactory.setUser() with val = " + val);
        this.user = val;
    }

    public String getUserName() {
        System.out.println("XAManagedConnectionFactory.getUserName() returning:  " + this.userName);
        return this.userName;
    }

    public void setUserName(String val) {
        System.out.println("XAManagedConnectionFactory.setUserName() with val = " + val);
        this.userName = val;
    }

    public String getPassword() {
        System.out.println("XAManagedConnectionFactory.getPassword() returning:  " + this.password);
        return this.password;
    }

    public void setPassword(String val) {
        System.out.println("XAManagedConnectionFactory.setPassword() with val = " + val);
        this.password = val;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new TSEISDataSource(this, cxManager);
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        ++this.count;
        String newStr1 = "XAManagedConnectionFactory setResourceAdapter " + this.count;
        System.out.println(newStr1);
        ConnectorStatus.getConnectorStatus().logState(newStr1);
        this.resourceAdapter = ra;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public Object createConnectionFactory() throws ResourceException {
        return new TSEISDataSource(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            TSXAConnectionImpl xacon = null;
            TSConnection con = null;
            Object userName = null;
            PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
            if (pc == null) {
                xacon = new TSXAConnectionImpl();
                con = xacon.getConnection();
                System.out.println("xacon.getConnection");
            } else {
                xacon = new TSXAConnectionImpl();
                System.out.println("xacon.getConnection(u,p)");
                con = xacon.getConnection(pc.getUserName(), pc.getPassword());
            }
            if (con == null) {
                System.out.println("Connection is null");
            }
            return new TSManagedConnection(this, pc, xacon, con, true, true);
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("Exception: " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
        for (Object obj : connectionSet) {
            if (!(obj instanceof TSManagedConnection)) continue;
            TSManagedConnection mc = (TSManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return null;
        }
        catch (Exception ex) {
            ResourceException rex = new ResourceException("Exception");
            rex.initCause((Throwable)ex);
            throw rex;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XAManagedConnectionFactory)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XAManagedConnectionFactory that = (XAManagedConnectionFactory)obj;
        if (this.reference != null && !this.reference.equals(that.getReference())) {
            return false;
        }
        if (this.reference == null && that.getReference() != null) {
            return false;
        }
        if (this.resourceAdapter != null && !this.resourceAdapter.equals((Object)that.getResourceAdapter())) {
            return false;
        }
        if (this.resourceAdapter == null && that.getResourceAdapter() != null) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (!Util.isEqual(this.password, that.getPassword())) {
            return false;
        }
        if (!Util.isEqual(this.user, that.getUser())) {
            return false;
        }
        if (!Util.isEqual(this.userName, that.getUserName())) {
            return false;
        }
        return Util.isEqual(this.TSRValue, that.getTSRValue());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Reference getReference() {
        Reference ref = this.reference;
        return ref;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public void setTSRValue(String name) {
        ConnectorStatus.getConnectorStatus().logState("XAManagedConnectionFactory.setTSRValue");
        Debug.trace("XAManagedConnectionFactory.setTSRValue called with value = " + name);
        this.TSRValue = name;
    }

    public String getTSRValue() {
        ConnectorStatus.getConnectorStatus().logState("XAManagedConnectionFactory.getTSRValue");
        Debug.trace("XAManagedConnectionFactory.getTSRValue");
        return this.TSRValue;
    }

    public void lookupTSR(String lookup) {
        ConnectorStatus.getConnectorStatus().logState("XAManagedConnectionFactory.lookupTSR");
        try {
            Debug.trace("lookupTSR() called with lookup name = " + lookup);
            TSNamingContext ncxt = new TSNamingContext();
            String newStr = "java:".concat(lookup);
            Object obj = ncxt.lookup(newStr);
            if (obj != null) {
                ConnectorStatus.getConnectorStatus().logState("TSR Lookup Successful");
                Debug.trace("TSR Lookup Successful");
            } else {
                Debug.trace("TSR Null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int val) {
        this.count = val;
    }
}

