/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.annotations.access.field.Client;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes2;
import ee.jakarta.tck.persistence.core.types.common.Grade;
import jakarta.persistence.Query;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;

public class Client1
extends Client {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void fieldTypeTest1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && !this.d1.isProperty()) {
                this.d1.setBooleanData(true);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.isProperty()) {
                    this.logTrace("Received expected result:" + this.d1.isProperty());
                    pass = true;
                } else {
                    this.logErr("Expected: true, actual:" + this.d1.isProperty());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            e.printStackTrace();
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
                re.printStackTrace();
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest2() throws Exception {
        boolean pass = false;
        byte newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getByteData() == 100) {
                this.d1.setByteData(newByte);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getByteData() == newByte) {
                    pass = true;
                } else {
                    this.logErr("Expected: 100, actual:" + this.d1.getByteData());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            e.printStackTrace();
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest3() throws Exception {
        boolean pass = false;
        int newChar = 98;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getCharacterData() == 'a') {
                this.d1.setCharacterData('b');
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData() == 'b') {
                    pass = true;
                } else {
                    this.logErr("Expected: a, actual:" + this.d1.getCharacterData());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest4() throws Exception {
        boolean pass = false;
        int newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getShortData() == 100) {
                this.d1.setShortData((short)101);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData() == 101) {
                    pass = true;
                } else {
                    this.logErr("Expected: 100, actual:" + this.d1.getShortData());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest5() throws Exception {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getIntData() == 300) {
                this.d1.setIntData(500);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntData() == 500) {
                    pass = true;
                } else {
                    this.logErr("Expected: 300, actual:" + this.d1.getIntData());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest6() throws Exception {
        boolean pass = false;
        long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getLongData() == 600L) {
                this.d1.setLongData(600L);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData() == 600L) {
                    pass = true;
                } else {
                    this.logErr("Expected: 600, actual:" + this.d1.getLongData());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest7() throws Exception {
        boolean pass = false;
        double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getDoubleData() == 50.0) {
                this.d1.setDoubleData(80.0);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData() == 80.0) {
                    pass = true;
                } else {
                    this.logErr("Expected: 50, actual:" + this.d1.getDoubleData());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest8() throws Exception {
        boolean pass = false;
        float expFloat = 1.0f;
        float floatRange = 2.0f;
        float newFloat = 6.0f;
        float newfloatRange = 7.0f;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("float value is: " + this.d1.getFloatData());
                if (this.d1.getFloatData() >= 1.0f && this.d1.getFloatData() < 2.0f) {
                    this.d1.setFloatData(6.0f);
                    this.getEntityManager().merge((Object)this.d1);
                    this.getEntityManager().flush();
                    if (this.d1.getFloatData() >= 6.0f && this.d1.getFloatData() < 7.0f) {
                        pass = true;
                    } else {
                        this.logErr("Expected: >= 6.0 and < 7.0, actual:" + this.d1.getFloatData());
                    }
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest8 failed");
        }
    }

    public void fieldTypeTest9() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find DataTypes entity in fieldTypeTest9");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataTypes is not null, setting enumData");
                this.d1.setEnumData(Grade.B);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.logTrace("Update performed, check results");
                if (null != this.d1 && this.d1.getEnumData().equals((Object)Grade.B)) {
                    this.logTrace("Expected results received");
                    pass = true;
                } else {
                    this.logErr("Expected: " + Grade.B.toString() + ", actual:" + String.valueOf((Object)this.d1.getEnumData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest9 failed");
        }
    }

    public void fieldTypeTest10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2 IN fieldTypeTest10");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("fieldTypeTest10:  Check results");
                if (this.d2.getId().equals(this.dateId)) {
                    this.logTrace("Got expected PK of:" + String.valueOf(this.d2.getId()) + "received");
                    pass = true;
                } else {
                    this.logErr("Expected: " + String.valueOf(this.dateId) + ", actual: " + String.valueOf(this.d2.getId()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest11() throws Exception {
        boolean pass = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        int bv = 5;
        byte[] a = null;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1 IN fieldTypeTest11");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + 5);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                this.logTrace("fieldTypeTest11:  Check results");
                if (null != this.d2 && Arrays.equals(this.d1.getByteArrayData(), a)) {
                    this.logTrace("fieldTypeTest11: Expected results received");
                    pass = true;
                } else {
                    int n;
                    this.logErr("Unexpected result in array comparison.");
                    byte[] byArray = a;
                    int n2 = byArray.length;
                    for (n = 0; n < n2; ++n) {
                        Byte aByte = byArray[n];
                        this.logErr("Array a in propertyTest9 equals: " + aByte);
                    }
                    byArray = b;
                    n2 = byArray.length;
                    for (n = 0; n < n2; ++n) {
                        Byte bByte = byArray[n];
                        this.logErr("Array b in propertyTest9 equals: " + bByte);
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest12() throws Exception {
        boolean pass = false;
        char[] charData = new char[]{'c', 't', 's'};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1 IN fieldTypeTest12");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting charData ");
                this.d1.setCharArrayData(charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.logTrace("fieldTypeTest12:  Check results");
                if (null != this.d1 && Arrays.equals(this.d1.getCharArrayData(), charData)) {
                    this.logTrace("fieldTypeTest12: Expected Results Received");
                    pass = true;
                } else {
                    this.logErr("Expected " + Arrays.toString(charData) + ", actual: " + Arrays.toString(this.d1.getCharArrayData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest13() throws Exception {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2 IN fieldTypeTest13");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                this.logTrace("fieldTypeTest13:  Check results");
                if (null != this.d2 && this.d2.getTimeData().equals(timeValue)) {
                    this.logTrace("fieldTypeTest13: Expected Time Received");
                    pass = true;
                } else {
                    this.logErr("Expected " + String.valueOf(timeValue) + " , actual: " + String.valueOf(this.d2.getTimeData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest14() throws Exception {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2 IN fieldTypeTest14");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                this.logTrace("fieldTypeTest14:  Check results");
                if (null != this.d2 && this.d2.getTsData().equals(tsValue)) {
                    this.logTrace("fieldTypeTest14: Expected Timestamp Received");
                    pass = true;
                } else {
                    this.logErr("Expected " + String.valueOf(tsValue) + " , actual: " + String.valueOf(this.d2.getTsData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest15() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = ee.jakarta.tck.persistence.core.types.common.Grade.A");
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1.equals(result)) {
                    pass = true;
                    this.logTrace("Received expected result:" + this.d1.toString());
                } else {
                    this.logErr("Expected:" + this.d1.toString() + ", actual:" + ((Object)result).toString());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest15 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest16() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = :grade").setParameter("grade", (Object)Grade.A);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1.equals(result)) {
                    pass = true;
                    this.logTrace("Received expected result:" + this.d1.toString());
                } else {
                    this.logErr("Expected:" + this.d1.toString() + ", actual:" + ((Object)result).toString());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest17() throws Exception {
        boolean pass = false;
        Grade failingGrade = Grade.F;
        Grade incompleteGrade = Grade.INCOMPLETE;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE (dt.enumData <> ?1) OR (dt.enumData <> ?2) ").setParameter(1, (Object)failingGrade).setParameter(2, (Object)incompleteGrade);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1.equals(result)) {
                    pass = true;
                    this.logTrace("Received expected result:" + this.d1.toString());
                } else {
                    this.logErr("Expected:" + this.d1.toString() + ", actual:" + ((Object)result).toString());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest17 failed");
        }
    }

    public void createTestData() {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            char[] cArray = new char[]{'a'};
            byte[] bArray = new byte[]{100};
            this.d1 = new DataTypes(1, false, 100, 'a', 100, 300, 600L, 50.0, 1.0f, cArray, bArray);
            this.logTrace("dateId is: " + String.valueOf(this.dateId));
            this.d2 = new DataTypes2(this.dateId);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }
}

