/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.language;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.LineItem;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Client1
extends Util {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Orders for Customer: Robert E. Bissett");
            List o = this.getEntityManager().createQuery("Select Distinct o from Order AS o WHERE o.customer.name = :name").setParameter("name", (Object)"Robert E. Bissett").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest5() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all Customers with AXP Credit Cards");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) fRoM Customer c, IN(c.creditCards) a where a.type = :ccard").setParameter("ccard", (Object)"AXP").getResultList();
            String[] expectedPKs = new String[]{"1", "4", "5", "8", "9", "12", "15"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest5 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest8() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where the total price is NOT less than $4500");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o WHERE NOT o.totalPrice < 4500").getResultList();
            String[] expectedPKs = new String[]{"5", "11", "16"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest8 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest9() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where the customer name is Karen R. Tegan OR the total price is less than $100");
            List o = this.getEntityManager().createQuery("SeLeCt DiStInCt oBjEcT(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' OR o.totalPrice < 100").getResultList();
            String[] expectedPKs = new String[]{"6", "9", "10", "12", "13"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest9 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where line item quantity is 1 AND the order total less than 100 or customer name is Robert E. Bissett");
            List o = this.getEntityManager().createQuery("select distinct Object(o) FROM Order AS o, in(o.lineItemsCollection) l WHERE (l.quantity < 2) AND ((o.totalPrice < (3 + 54 * 2 + -8)) OR (o.customer.name = 'Robert E. Bissett'))").getResultList();
            String[] expectedPKs = new String[]{"4", "9", "12", "13"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 4 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest10 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest11() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders with line item quantity < 2 for customer Robert E. Bissett");
            List o = this.getEntityManager().createQuery("SELECT DISTINCT Object(o) FROM Order o, in(o.lineItemsCollection) l WHERE l.quantity < 2 AND o.customer.name = 'Robert E. Bissett'").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest11 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest12() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders with a total price BETWEEN $1000 and $1200");
            List o = this.getEntityManager().createQuery("SELECT DISTINCT Object(o) From Order o where o.totalPrice BETWEEN 1000 AND 1200").getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "14"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest12 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest13() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders with a total price NOT BETWEEN $1000 and $1200");
            List o = this.getEntityManager().createQuery("SELECT DISTINCT Object(o) From Order o where o.totalPrice NOT bETwEeN 1000 AND 1200").getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest13 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest14() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders that do not have approved Credit Cards");
            List o = this.getEntityManager().createQuery("select distinct Object(o) From Order o WHERE o.creditCard.approved = FALSE").getResultList();
            String[] expectedPKs = new String[]{"1", "7", "11", "13", "18", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 6 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest14 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest27() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing ABS with numeric Java object types");
            this.logTrace("find all Orders with a total price greater than 1180");
            List o = this.getEntityManager().createQuery("Select DISTINCT Object(o) From Order o WHERE :dbl < ABS(o.totalPrice)").setParameter("dbl", (Object)1180.0).getResultList();
            String[] expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 9 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.logMsg("Testing ABS with primitive numeric type");
            this.logTrace("find all Orders with a total price greater than 1180");
            o = this.getEntityManager().createQuery("Select DISTINCT Object(o) From Order o WHERE o.totalPrice > ABS(:dbl)").setParameter("dbl", (Object)1180.55).getResultList();
            expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 9 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest27 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest32() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where line items are members of the orders");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o, LineItem l WHERE l MEMBER o.lineItemsCollection").getResultList();
            String[] expectedPKs = new String[this.orderRef.length];
            for (int i = 0; i < this.orderRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + this.orderRef.length + "references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest32 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest33() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find orders whose orders are do NOT contain the specified line items");
            LineItem liDvc = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"30");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o WHERE :param NOT MEMBER o.lineItemsCollection").setParameter("param", (Object)liDvc).getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 19 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest33 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest34() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find orders who have Samples in their orders");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) FROM Order o WHERE o.sampleLineItem MEMBER OF o.lineItemsCollection").getResultList();
            String[] expectedPKs = new String[]{"1", "6"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest34 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest35() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders which contain lineitems not of quantities 1 or 5");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) from Order o, in(o.lineItemsCollection) l where l.quantity NOT IN (1, 5)").getResultList();
            String[] expectedPKs = new String[]{"10", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 9 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest35 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest39() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing SQRT with numeric Java object types");
            this.logTrace("find customers with specific credit card balance");
            List c = this.getEntityManager().createQuery("Select Distinct OBJECT(c) from Customer c, IN(c.creditCards) b where SQRT(b.balance) = :dbl").setParameter("dbl", (Object)50.0).getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.logMsg("Testing SQRT with primitive numeric type");
            this.logTrace("find customers with specific credit card balance");
            c = this.getEntityManager().createQuery("Select Distinct OBJECT(c) from Customer c, IN(c.creditCards) b where SQRT(b.balance) = SQRT(:dbl)").setParameter("dbl", (Object)2500.0).getResultList();
            expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest39 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest42() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all orders where related customer name is not null");
            List o = this.getEntityManager().createQuery("Select Distinct Object(o) from Order o where o.customer.name IS NOT NULL").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 19 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest42 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest48() throws Exception {
        boolean pass = false;
        Object[] expectedBalances = new Double[]{400.0, 500.0, 750.0, 1000.0, 1400.0, 1500.0, 2000.0, 2500.0, 4400.0, 5000.0, 5500.0, 7000.0, 7400.0, 8000.0, 9500.0, 13000.0, 15000.0, 23000.0};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all credit card balances");
            List o = this.getEntityManager().createQuery("Select Distinct o.creditCard.balance from Order o ORDER BY o.creditCard.balance ASC").getResultList();
            Object[] result = o.toArray(new Double[o.size()]);
            Iterator i = o.iterator();
            while (i.hasNext()) {
                this.logTrace("query results returned:  " + (Double)i.next());
            }
            this.logTrace("Compare expected results to query results");
            pass = Arrays.equals(expectedBalances, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest48 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest60() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find Customers with an Order");
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) o").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 18 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest60 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest62() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE SIZE(c.orders) >= 2").getResultList();
            String[] expectedPKs = new String[]{"4", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest62 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest63() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List c = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE SIZE(c.orders) > 100").getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest63 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest65() throws Exception {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 1;
        try {
            Object result;
            this.logTrace("select MINIMUM number of lineItem quantities available an order may have");
            Query q = this.getEntityManager().createQuery("SELECT DISTINCT MIN(l.quantity) FROM LineItem l");
            List i2 = q.getResultList();
            Query q1 = this.getEntityManager().createQuery("SELECT MIN(l.quantity) FROM LineItem l");
            List i3 = q1.getResultList();
            this.logMsg("Verify select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        this.logTrace("Received expected results:" + (Integer)result);
                        pass1 = true;
                    } else {
                        this.logTrace("Expected: " + i1 + ", actual:" + (Integer)result);
                    }
                } else {
                    this.logErr("Receive null result from query");
                }
            } else {
                this.logErr("Receive more than one result:");
                for (Integer i : i2) {
                    this.logErr("Received:" + i);
                }
            }
            this.logMsg("Verify Select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        this.logTrace("Received expected results:" + result);
                        pass2 = true;
                    } else {
                        this.logTrace("Expected: " + i1 + ", actual:" + result);
                    }
                } else {
                    this.logErr("Receive null result from query");
                }
            } else {
                this.logErr("Receive more than one result:");
                for (Integer i : i3) {
                    this.logErr("Received:" + i);
                }
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest65 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest66() throws Exception {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 8;
        try {
            Object result;
            this.logTrace("find MAXIMUM number of lineItem quantities available an order may have");
            Query q = this.getEntityManager().createQuery("SELECT DISTINCT MAX(l.quantity) FROM LineItem l");
            List i2 = q.getResultList();
            Query q1 = this.getEntityManager().createQuery("SELECT MAX(l.quantity) FROM LineItem l");
            List i3 = q1.getResultList();
            this.logMsg("Testing select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        this.logTrace("Received expected results:" + (Integer)result);
                        pass1 = true;
                    } else {
                        this.logTrace("Expected: " + i1 + ", actual:" + (Integer)result);
                    }
                } else {
                    this.logErr("Receive null result from query");
                }
            } else {
                this.logErr("Receive more than one result:");
                for (Integer i : i2) {
                    this.logErr("Received:" + i);
                }
            }
            this.logMsg("Testing Select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        this.logTrace("Received expected results:" + result);
                        pass2 = true;
                    } else {
                        this.logTrace("Expected: " + i1 + ", actual:" + result);
                    }
                } else {
                    this.logErr("Receive null result from query");
                }
            } else {
                this.logErr("Receive more than one result:");
                for (Integer i : i3) {
                    this.logErr("Received:" + i);
                }
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest66 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void queryTest67() throws Exception {
        boolean pass = false;
        Double d1 = 1487.29;
        Double d2 = 1487.3;
        try {
            this.logTrace("find AVERAGE price of all orders");
            Query q = this.getEntityManager().createQuery("SELECT AVG(o.totalPrice) FROM Order o");
            Double d3 = (Double)q.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                this.logTrace("Returned expected results: " + d1);
                pass = true;
            } else {
                this.logTrace("Returned " + d3 + "expected: " + d1);
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest67 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_leftouterjoin_Mx1() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"15", "14"}, {"16", "14"}};
        try {
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("SELECT o.id, cust.id from Order o LEFT OUTER JOIN o.customer cust where cust.name=?1 ORDER BY o.id").setParameter(1, (Object)"Kellie A. Sanborn").getResultList();
            if (q.size() != 2) {
                this.logTrace("test_leftouterjoin_Mx1:  Did not get expected results. Expected 2,  got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    pass1 = true;
                    Object obj = q.get(i);
                    Object[] orderAndCustomerExpected = expectedResultSet[i];
                    if (obj instanceof Object[]) {
                        this.logTrace("The element in the result list is of type Object[], continue . . .");
                        Object[] orderAndCustomer = (Object[])obj;
                        if (Arrays.equals(orderAndCustomerExpected, orderAndCustomer)) continue;
                        this.logErr("Expecting element value: " + String.valueOf(Arrays.asList(orderAndCustomerExpected)) + ", actual element value: " + String.valueOf(Arrays.asList(orderAndCustomer)));
                        pass2 = false;
                        break;
                    }
                    pass2 = false;
                    this.logErr("The element in the result list is not of type Object[]:" + String.valueOf(obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("test_leftouterjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupBy_1() throws Exception {
        boolean pass = false;
        Object[] expected = new String[]{"AXP", "MCARD", "VISA"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select cc.type FROM CreditCard cc JOIN cc.customer cust GROUP BY cc.type").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                this.logErr("Did not get expected results");
                for (Object s : expected) {
                    this.logErr("Expected:" + (String)s);
                }
                for (Object s : output) {
                    this.logErr("Actual:" + (String)s);
                }
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_groupBy_1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_1xM() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT object(c) from Customer c INNER JOIN c.creditCards cc where cc.type='VISA' ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "6", "7", "10", "14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 8 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_innerjoin_Mx1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Object(o) from Order o INNER JOIN o.customer cust where cust.name = ?1").setParameter(1, (Object)"Kellie A. Sanborn").getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_1xM() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c from Customer c LEFT JOIN FETCH c.orders where c.home.state IN('NY','RI')").getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select o from Order o LEFT JOIN FETCH o.customer where o.customer.home.city='Lawrence'").getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 8 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_fetchjoin_Mx1_1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) from Order o LEFT JOIN FETCH o.customer where o.customer.name LIKE '%Caruso' ").getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_Mx1_1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_notBetweenArithmetic() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT o From Order o where o.totalPrice NOT BETWEEN 1000 AND 1200").getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_notBetweenArithmetic failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' AND o.totalPrice > 500").getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionTF() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' AND o.totalPrice > 10000").getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.id = '1001' AND o.totalPrice < 1000 ").getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ANDconditionFF() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.id = '1001' AND o.totalPrice > 10000").getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select DISTINCT o FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' OR o.totalPrice > 5000").getResultList();
            String[] expectedPKs = new String[]{"6", "11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionTF() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.name = 'Karen R. Tegan' OR o.totalPrice > 10000").getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Distinct Object(o) FROM Order AS o WHERE o.customer.id = '1001' OR o.totalPrice < 1000 ").getResultList();
            String[] expectedPKs = new String[]{"9", "10", "12", "13", "15", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ORconditionFF() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(o) FROM Order AS o WHERE o.customer.id = '1001' OR o.totalPrice > 10000").getResultList();
            if (result.size() == 0) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_groupByWhereClause() throws Exception {
        boolean pass = false;
        Object[] expected = new String[]{"Jonathan K. Smith", "Kellie A. Sanborn", "Robert E. Bissett"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select c.name FROM Customer c JOIN c.orders o WHERE o.totalPrice BETWEEN 90 AND 160 GROUP BY c.name").getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expected, output);
            if (!pass) {
                this.logErr("Did not get expected results");
                for (Object s : expected) {
                    this.logErr("Expected:" + (String)s);
                }
                for (Object s : output) {
                    this.logErr("Actual:" + (String)s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_groupByWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_ABSHavingClause() throws Exception {
        boolean pass = false;
        Double expectedPrice = 10191.9;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select sum(o.totalPrice) FROM Order o GROUP BY o.totalPrice HAVING ABS(o.totalPrice) = :doubleValue ").setParameter("doubleValue", (Object)5095.95);
            Double result = (Double)q.getSingleResult();
            if (expectedPrice.equals(result)) {
                pass = true;
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("test_ABSHavingClause:  Did not get expected results.Expected 10190, got: " + result);
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_ABSHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_SQRTWhereClause() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("SQRT: Executing Query");
            List result = this.getEntityManager().createQuery("select object(o) FROM Order o Where SQRT(o.totalPrice) > :doubleValue ").setParameter("doubleValue", (Object)70.0).getResultList();
            String[] expectedPKs = new String[]{"11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_SQRTWhereClause:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_SQRTWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_01() throws Exception {
        boolean pass = false;
        String[] expectedPKs = new String[]{"19", "20"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c WHERE NOT EXISTS (SELECT o1 FROM c.orders o1) ").getResultList();
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_exists_01:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_exists_01 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_exists_02() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.totalPrice > 1500 ) ").getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_exists_02:  Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_exists_02 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_like() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("Select Object(o) from Order o WHERE EXISTS (Select c From o.customer c WHERE c.name LIKE '%Caruso') ").getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_like failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_between() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute query for test_subquery_between");
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.totalPrice BETWEEN 1000 AND 1200)").getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_between:  Did not get expected  results.  Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_between failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_join() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c JOIN c.orders o WHERE EXISTS (SELECT o FROM o.lineItemsCollection l where l.quantity > 3 ) ").getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_join failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice > ALL (Select o.totalPrice FROM Order o, in(o.lineItemsCollection) l WHERE l.quantity > 3) ").getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_GT:  Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_ALL_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT distinct object(C) FROM Customer C, IN(C.orders) co WHERE co.totalPrice < ALL (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity > 3) ").getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_LT:  Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_EQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice = ALL (Select MIN(o.totalPrice) FROM Order o) ").getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_EQ:  Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_LTEQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice <= ALL (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity > 3) ").getResultList();
            String[] expectedPKs = new String[]{"9", "12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_LTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_GTEQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT object(c) FROM Customer C, IN(c.orders) co WHERE co.totalPrice >= ALL (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity >= 3) ").getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_GTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_GTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ALL_NOTEQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice <> ALL (Select MIN(o.totalPrice) FROM Order o) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ALL_NOTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_NOTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_GT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT c FROM Customer c, IN(c.orders) co WHERE co.totalPrice > ANY (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ANY_GT:  Did not get expected results.   Expected 16 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_LT() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct Object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice < ANY (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3)").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ANY_LT:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_ANY_EQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice = ANY (Select MAX(o.totalPrice) FROM Order o) ").getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_ANY_EQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_LTEQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice <= SOME (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_SOME_LTEQ:  Did not get expected results.  Expected 18 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_SOME_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void test_subquery_SOME_GTEQ() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Distinct object(c) FROM Customer c, IN(c.orders) co WHERE co.totalPrice >= SOME (Select o.totalPrice FROM Order o, IN(o.lineItemsCollection) l WHERE l.quantity = 3) ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_SOME_GTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_SOME_GTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void treatJoinClassTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[1].getName());
        expected.add(this.softwareRef[2].getName());
        expected.add(this.softwareRef[3].getName());
        expected.add(this.softwareRef[4].getName());
        expected.add(this.softwareRef[5].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT s.name FROM LineItem l JOIN TREAT(l.product AS SoftwareProduct) s").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                this.logTrace("result:" + s);
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected result:");
                for (String s : expected) {
                    this.logTrace("expected:" + s);
                }
                for (String s : actual) {
                    this.logTrace("actual:" + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("treatJoinClassTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void treatInWhereClauseTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[7].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT p.name FROM Product p where TREAT(p AS SoftwareProduct).revisionNumber = 1.0").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                this.logTrace("result:" + s);
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected result:");
                for (String s : expected) {
                    this.logTrace("expected:" + s);
                }
                for (String s : actual) {
                    this.logTrace("actual:" + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("treatInWhereClauseTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void appropriateSuffixesTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[7].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT p.name FROM Product p where TREAT(p AS SoftwareProduct).revisionNumber = 1.0D").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                this.logTrace("result:" + s);
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected result:");
                for (String s : expected) {
                    this.logTrace("expected:" + s);
                }
                for (String s : actual) {
                    this.logTrace("actual:" + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("appropriateSuffixesTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void sqlApproximateNumericLiteralTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.softwareRef[0].getName());
        expected.add(this.softwareRef[7].getName());
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("SELECT p.name FROM Product p where TREAT(p AS SoftwareProduct).revisionNumber = 1E0").getResultList();
            Collections.sort(actual);
            for (String s : actual) {
                this.logTrace("result:" + s);
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Did not get expected result:");
                for (String s : expected) {
                    this.logTrace("expected:" + s);
                }
                for (String s : actual) {
                    this.logTrace("actual:" + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("sqlApproximateNumericLiteralTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinOnExpressionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("select o FROM Order o INNER JOIN o.lineItemsCollection l ON (l.quantity > 5)").getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            for (Order o : actual) {
                this.logTrace("order:" + o.getId() + ":");
                Collection li = o.getLineItemsCollection();
                for (LineItem i : li) {
                    this.logTrace("   item:" + i.getId() + ", " + i.getQuantity());
                }
            }
            if (!this.checkEntityPK(actual, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("joinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void subqueryVariableOverridesQueryVariableTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c WHERE c.id in (SELECT c.id FROM Order c where c.id='10' ) ").getResultList();
            String[] expectedPKs = new String[]{"10"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Expected 1 result, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("subqueryVariableOverridesQueryVariableTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void longIdentifierNameTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Orders for Customer: Robert E. Bissett");
            List o = this.getEntityManager().createQuery("Select Distinct variable01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789 from Order variable01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789 WHERE variable01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789.customer.name = :name").setParameter("name", (Object)"Robert E. Bissett").getResultList();
            if (o.size() > 0) {
                for (Object oo : o) {
                    if (oo instanceof Order) continue;
                    this.logErr("Object returned was not of type Order:" + oo.getClass().getName());
                    pass2 = false;
                }
            } else {
                this.logErr("Not results were returned");
                pass2 = false;
            }
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("longIdentifierNameTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void underscoreIdentifierNameTest() throws Exception {
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Orders for Customer: Robert E. Bissett");
            String variable = "_01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            if (this.checkIdentifierValues(variable)) {
                this.logTrace("Identifier is valid");
                pass1 = true;
            } else {
                this.logTrace("Identifier[" + variable + "] is invalid");
            }
            String sQuery = "Select Distinct " + variable + " from Order " + variable + " WHERE " + variable + ".customer.name = :name";
            this.logTrace("Query=" + sQuery);
            List o = this.getEntityManager().createQuery(sQuery).setParameter("name", (Object)"Robert E. Bissett").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("underscoreIdentifierNameTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void dollarsignIdentifierNameTest() throws Exception {
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Orders for Customer: Robert E. Bissett");
            String variable = "$01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            if (this.checkIdentifierValues(variable)) {
                this.logTrace("Identifier is valid");
                pass1 = true;
            } else {
                this.logTrace("Identifier[" + variable + "] is invalid");
            }
            String sQuery = "Select Distinct " + variable + " from Order " + variable + " WHERE " + variable + ".customer.name = :name";
            this.logTrace("Query=" + sQuery);
            List o = this.getEntityManager().createQuery(sQuery).setParameter("name", (Object)"Robert E. Bissett").getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("dollarsignIdentifierNameTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void distinctNotSpecifiedTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All customer ids from Orders");
            List o = this.getEntityManager().createQuery("Select o.customer.id from Order AS o ").getResultList();
            Integer[] expectedPKs = new Integer[]{Integer.parseInt("1"), Integer.parseInt("2"), Integer.parseInt("3"), Integer.parseInt("4"), Integer.parseInt("4"), Integer.parseInt("5"), Integer.parseInt("6"), Integer.parseInt("7"), Integer.parseInt("8"), Integer.parseInt("9"), Integer.parseInt("10"), Integer.parseInt("11"), Integer.parseInt("12"), Integer.parseInt("13"), Integer.parseInt("14"), Integer.parseInt("14"), Integer.parseInt("15"), Integer.parseInt("16"), Integer.parseInt("17"), Integer.parseInt("18")};
            if (!this.checkEntityPK(o, expectedPKs, true, true)) {
                this.logErr("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("distinctNotSpecifiedTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void resultVariableTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List o = this.getEntityManager().createQuery("Select o.id AS OID from Order o WHERE (o.totalPrice < 100.0) ORDER BY OID").getResultList();
            Integer[] expectedPKs = new Integer[]{Integer.parseInt("9"), Integer.parseInt("10"), Integer.parseInt("12"), Integer.parseInt("13")};
            if (!this.checkEntityPK(o, expectedPKs, true, true)) {
                this.logErr("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + o.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("resultVariableTest failed");
        }
    }

    private boolean checkIdentifierValues(String var) {
        boolean pass = true;
        this.logMsg("Testing that identifier is valid");
        char[] c = var.toCharArray();
        boolean first = true;
        for (char cc : c) {
            if (first) {
                if (!Character.isJavaIdentifierStart(cc)) {
                    this.logErr("Value[" + cc + "is not a valid start character");
                    pass = false;
                }
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(cc)) continue;
            this.logErr("Value[" + cc + "is not a valid part character");
            pass = false;
        }
        return pass;
    }
}

