/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.property;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.common.Grade;
import ee.jakarta.tck.persistence.core.types.property.Customer;
import java.util.ArrayList;
import java.util.Properties;

public class Client2
extends PMClientBase {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeCustTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void elementCollectionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<Grade> expectedphones = new ArrayList<Grade>();
            expectedphones.add(Grade.A);
            expectedphones.add(Grade.B);
            expectedphones.add(Grade.C);
            expected.setPhones(expectedphones);
            this.logTrace("Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found Customer: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    this.logTrace("Received expected Phones:");
                    for (Grade g : cust.getPhones()) {
                        this.logTrace("phone:" + String.valueOf((Object)g));
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (Grade g : expectedphones) {
                        this.logErr("expected:" + String.valueOf((Object)g));
                    }
                    this.logErr("actual:");
                    for (Grade g : cust.getPhones()) {
                        this.logErr("actual:" + String.valueOf((Object)g));
                    }
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionTest failed");
        }
    }

    public void cleanupCust() throws Exception {
        this.logTrace("cleanup");
        this.removeCustTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeCustTestData() {
        this.logTrace("removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

