/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.commands.shared.AbstractSharedCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.MinimumSizeWizardDialog;
import org.eclipse.egit.ui.internal.dialogs.NonBlockingWizardDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractFetchFromHostCommand
extends AbstractSharedCommandHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell;
        String clipText;
        Repository repository = AbstractFetchFromHostCommand.getRepository(event);
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        try {
            clipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        }
        finally {
            clipboard.dispose();
        }
        if (repository == null && (repository = this.askForRepository(shell = this.getShell(event), this.createSelectionPage())) == null) {
            return null;
        }
        Wizard wiz = this.createFetchWizard(repository, clipText);
        NonBlockingWizardDialog dlg = new NonBlockingWizardDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (IWizard)wiz);
        dlg.setHelpAvailable(false);
        dlg.open();
        return null;
    }

    protected abstract GitSelectRepositoryPage createSelectionPage();

    protected abstract Wizard createFetchWizard(@NonNull Repository var1, String var2);

    private Repository askForRepository(Shell shell, final GitSelectRepositoryPage page) {
        final Repository[] result = new Repository[1];
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                result[0] = page.getRepository();
                return true;
            }
        };
        wizard.addPage((IWizardPage)page);
        wizard.setWindowTitle(page.getTitle());
        MinimumSizeWizardDialog wizardDialog = new MinimumSizeWizardDialog(shell, (IWizard)wizard){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                String text = label;
                if (id == 16) {
                    text = UIText.GerritSelectRepositoryPage_FinishButtonLabel;
                }
                return super.createButton(parent, id, text, defaultButton);
            }
        };
        wizardDialog.setHelpAvailable(false);
        if (wizardDialog.open() != 0) {
            return null;
        }
        return result[0];
    }
}

