/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.actions.handlers;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.glsp.ide.editor.utils.GLSPDiagramEditorMarkerUtil;
import org.eclipse.glsp.ide.editor.utils.IdeClientOptions;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.validation.SetMarkersAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;

public class IdeSetMarkersActionHandler
extends AbstractActionHandler<SetMarkersAction> {
    @Inject
    protected GModelState modelState;

    protected List<Action> executeAction(SetMarkersAction action) {
        IFile workspaceFile = (IFile)GLSPServerException.getOrThrow(IdeClientOptions.getSourceUriAsIFile(this.modelState.getClientOptions()), (String)("Could not retrieve model source URL for: " + this.modelState.getClientId()));
        GLSPDiagramEditorMarkerUtil.clearMarkers((IResource)workspaceFile, false);
        action.getMarkers().forEach(glspMarker -> {
            IMarker iMarker = GLSPDiagramEditorMarkerUtil.createMarker((IResource)workspaceFile, glspMarker);
        });
        return this.none();
    }
}

