/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.basic.xa;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeUtil;
import com.sun.ts.tests.ejb30.timer.basic.xa.XATimerBeanBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.UserTransaction;
import java.util.Date;
import java.util.logging.Level;

@Singleton
@TransactionManagement(value=TransactionManagementType.BEAN)
public class SingletonXATimerBean
extends XATimerBeanBase {
    @Resource
    private UserTransaction ut;

    @Override
    public void persistCoffee(int id, String brandName) {
        try {
            this.ut.begin();
            CoffeeUtil.findDeletePersist(id, brandName, this.em);
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.WARNING, "Failed in findDeletePersist: ", e);
            try {
                this.ut.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean persistCoffeeCreateTimerRollback(int id, String brandName, Date expireation, TimerInfo info) {
        boolean result = false;
        try {
            this.ut.begin();
            result = super.persistCoffeeCreateTimerRollback(id, brandName, expireation, info);
            this.ut.commit();
        }
        catch (Exception e) {
            Helper.getLogger().log(Level.WARNING, "Failed in persistCoffeeCreateTimerRollback", e);
            try {
                this.ut.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

