/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.LocalTxActivationSpec;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ApplicationServerInternalException;
import jakarta.resource.spi.CommException;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.LocalTransactionException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionMetaData;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.RetryableUnavailableException;
import jakarta.resource.spi.SecurityException;
import jakarta.resource.spi.SharingViolationException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.work.HintsContext;
import jakarta.resource.spi.work.RetryableWorkRejectedException;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkRejectedException;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

public class APIAssertionTest {
    public static void checkManagedConnectionAPI(ManagedConnection mcon) {
        if (mcon == null) {
            Debug.trace("Error - null MetaData passed into APIAssertionTest.checkMetaData()");
        }
        if (mcon == null) {
            Debug.trace("Error - null MetaData passed into APIAssertionTest.checkMetaData()");
        }
        try {
            PrintWriter p = mcon.getLogWriter();
            APIAssertionTest.logAPIPass("ManagedConnection.getLogWriter() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnection.getLogWriter()");
        }
        try {
            ManagedConnectionMetaData dd = mcon.getMetaData();
            APIAssertionTest.logAPIPass("ManagedConnection.getMetaData() passed");
        }
        catch (ResourceException ex) {
            APIAssertionTest.logAPIPass("ManagedConnection.getMetaData() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnection.getXAResource()");
        }
        try {
            LocalTransaction lt = mcon.getLocalTransaction();
            APIAssertionTest.logAPIPass("ManagedConnection.getLocalTransaction() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnection.getLocalTransaction()");
        }
    }

    public static void checkMetaDataAPI(ManagedConnectionMetaData mdata) {
        if (mdata == null) {
            Debug.trace("Error - null MetaData passed into APIAssertionTest.checkMetaData()");
        }
        APIAssertionTest.logAPIPass("Connection.getMetaData() passed");
        try {
            String eisProdName = mdata.getEISProductName();
            APIAssertionTest.logAPIPass("ManagedConnectionMetaData.getEISProductName() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnectionMetaData.getEISProductName()");
        }
        try {
            String eisProdVer = mdata.getEISProductVersion();
            APIAssertionTest.logAPIPass("ManagedConnectionMetaData.getEISProductVersion() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnectionMetaData.getEISProductVersion()");
        }
        try {
            int maxCons = mdata.getMaxConnections();
            APIAssertionTest.logAPIPass("ManagedConnectionMetaData.getMaxConnections() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnectionMetaData.getMaxConnections()");
        }
        try {
            String userName = mdata.getUserName();
            APIAssertionTest.logAPIPass("ManagedConnectionMetaData.getUserName() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ManagedConnectionMetaData.getUserName()");
        }
    }

    public void runTests() {
        this.checkNotSupportedException();
        this.checkResourceException();
        this.checkLocalTransactionException();
        this.checkResourceAdapterInternalException();
        this.checkResourceAllocationException();
        this.checkSecurityException();
        this.checkSharingViolationException();
        this.checkUnavailableException();
        this.checkWorkException();
        this.checkWorkCompletedException();
        this.checkWorkRejectedException();
        this.checkEISSystemException();
        this.checkInvalidPropertyException();
        this.checkApplicationServerInternalException();
        this.checkCommException();
        this.checkIllegalStateException();
        this.checkRetryableUnavailableException();
        this.checkRetryableWorkRejectedException();
        this.checkHintsContext();
    }

    private void checkHintsContext() {
        try {
            HintsContext hc = new HintsContext();
            APIAssertionTest.logAPIPass("HintsContext() passed");
            hc.setName("hintName");
            String strname = hc.getName();
            if (strname != null && strname.equalsIgnoreCase("hintName")) {
                APIAssertionTest.logAPIPass("HintsContext.setName() and HintsContext.getName() passed.");
            }
            hc.setDescription("hintDescription");
            String strDesc = hc.getDescription();
            if (strDesc != null) {
                APIAssertionTest.logAPIPass("HintsContext.setDescription() and HintsContext.getDescription() passed.");
            }
            hc.setHint("jakarta.resource.Name", (Serializable)((Object)"someHintVal"));
            Map m = hc.getHints();
            APIAssertionTest.logAPIPass("HintsContext.setHints() and HintsContext.getHints() passed.");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(null)");
        }
    }

    private void checkInvalidPropertyException() {
        try {
            InvalidPropertyException ne = new InvalidPropertyException();
            throw ne;
        }
        catch (InvalidPropertyException ex) {
            APIAssertionTest.logAPIPass("InvalidPropertyException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(null)");
        }
        try {
            InvalidPropertyException ne = new InvalidPropertyException("message1");
            throw ne;
        }
        catch (InvalidPropertyException ex) {
            APIAssertionTest.logAPIPass("InvalidPropertyException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(str)");
        }
        try {
            InvalidPropertyException ne = new InvalidPropertyException("message1", "ERRCODE1");
            throw ne;
        }
        catch (InvalidPropertyException ex) {
            APIAssertionTest.logAPIPass("InvalidPropertyException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            InvalidPropertyException ne = new InvalidPropertyException((Throwable)someThrowable);
            throw ne;
        }
        catch (InvalidPropertyException ex) {
            APIAssertionTest.logAPIPass("InvalidPropertyException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            InvalidPropertyException ne = new InvalidPropertyException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (InvalidPropertyException ex) {
            APIAssertionTest.logAPIPass("InvalidPropertyException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(str, throwable)");
        }
        try {
            InvalidPropertyException ne = new InvalidPropertyException("message1");
            ArrayList<PropertyDescriptor> beanProps = new ArrayList<PropertyDescriptor>();
            beanProps.add(new PropertyDescriptor("destinationName", LocalTxActivationSpec.class));
            beanProps.add(new PropertyDescriptor("destinationType", LocalTxActivationSpec.class));
            PropertyDescriptor[] pd = beanProps.toArray(new PropertyDescriptor[beanProps.size()]);
            ne.setInvalidPropertyDescriptors(pd);
            Debug.trace("throwing setInvalidPropertyDescriptors(pd)");
            throw ne;
        }
        catch (InvalidPropertyException ex) {
            PropertyDescriptor[] pd = ex.getInvalidPropertyDescriptors();
            APIAssertionTest.logAPIPass("InvalidPropertyException.setInvalidPropertyDescriptors() passed");
            APIAssertionTest.logAPIPass("InvalidPropertyException.getInvalidPropertyDescriptors() passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying InvalidPropertyException(str)");
            ex.printStackTrace();
        }
    }

    private void checkEISSystemException() {
        try {
            EISSystemException ne = new EISSystemException();
            throw ne;
        }
        catch (EISSystemException ex) {
            APIAssertionTest.logAPIPass("EISSystemException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying EISSystemException(null)");
        }
        try {
            EISSystemException ne = new EISSystemException("message1");
            throw ne;
        }
        catch (EISSystemException ex) {
            APIAssertionTest.logAPIPass("EISSystemException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying EISSystemException(str)");
        }
        try {
            EISSystemException ne = new EISSystemException("message1", "ERRCODE1");
            throw ne;
        }
        catch (EISSystemException ex) {
            APIAssertionTest.logAPIPass("EISSystemException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying EISSystemException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            EISSystemException ne = new EISSystemException((Throwable)someThrowable);
            throw ne;
        }
        catch (EISSystemException ex) {
            APIAssertionTest.logAPIPass("EISSystemException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying EISSystemException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            EISSystemException ne = new EISSystemException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (EISSystemException ex) {
            APIAssertionTest.logAPIPass("EISSystemException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying EISSystemException(str, throwable)");
        }
    }

    private void checkIllegalStateException() {
        try {
            IllegalStateException ne = new IllegalStateException();
            throw ne;
        }
        catch (IllegalStateException ex) {
            APIAssertionTest.logAPIPass("IllegalStateException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying IllegalStateException(null)");
        }
        try {
            IllegalStateException ne = new IllegalStateException("message1");
            throw ne;
        }
        catch (IllegalStateException ex) {
            APIAssertionTest.logAPIPass("IllegalStateException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying IllegalStateException(str)");
        }
        try {
            IllegalStateException ne = new IllegalStateException("message1", "ERRCODE1");
            throw ne;
        }
        catch (IllegalStateException ex) {
            APIAssertionTest.logAPIPass("IllegalStateException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying IllegalStateException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            IllegalStateException ne = new IllegalStateException((Throwable)someThrowable);
            throw ne;
        }
        catch (IllegalStateException ex) {
            APIAssertionTest.logAPIPass("IllegalStateException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying IllegalStateException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            IllegalStateException ne = new IllegalStateException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (IllegalStateException ex) {
            APIAssertionTest.logAPIPass("IllegalStateException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying IllegalStateException(str, throwable)");
        }
    }

    private void checkCommException() {
        try {
            CommException ne = new CommException();
            throw ne;
        }
        catch (CommException ex) {
            APIAssertionTest.logAPIPass("CommException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying CommException(null)");
        }
        try {
            CommException ne = new CommException("message1");
            throw ne;
        }
        catch (CommException ex) {
            APIAssertionTest.logAPIPass("CommException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying CommException(str)");
        }
        try {
            CommException ne = new CommException("message1", "ERRCODE1");
            throw ne;
        }
        catch (CommException ex) {
            APIAssertionTest.logAPIPass("CommException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying CommException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            CommException ne = new CommException((Throwable)someThrowable);
            throw ne;
        }
        catch (CommException ex) {
            APIAssertionTest.logAPIPass("CommException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying CommException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            CommException ne = new CommException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (CommException ex) {
            APIAssertionTest.logAPIPass("CommException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying CommException(str, throwable)");
        }
    }

    private void checkRetryableWorkRejectedException() {
        try {
            RetryableWorkRejectedException ne = new RetryableWorkRejectedException();
            throw ne;
        }
        catch (RetryableWorkRejectedException ex) {
            APIAssertionTest.logAPIPass("RetryableWorkRejectedException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableWorkRejectedException(null)");
        }
        try {
            RetryableWorkRejectedException ne = new RetryableWorkRejectedException("message1");
            throw ne;
        }
        catch (RetryableWorkRejectedException ex) {
            APIAssertionTest.logAPIPass("RetryableWorkRejectedException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableWorkRejectedException(str)");
        }
        try {
            RetryableWorkRejectedException ne = new RetryableWorkRejectedException("message1", "ERRCODE1");
            throw ne;
        }
        catch (RetryableWorkRejectedException ex) {
            APIAssertionTest.logAPIPass("RetryableWorkRejectedException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableWorkRejectedException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            RetryableWorkRejectedException ne = new RetryableWorkRejectedException((Throwable)someThrowable);
            throw ne;
        }
        catch (RetryableWorkRejectedException ex) {
            APIAssertionTest.logAPIPass("RetryableWorkRejectedException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableWorkRejectedException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            RetryableWorkRejectedException ne = new RetryableWorkRejectedException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (RetryableWorkRejectedException ex) {
            APIAssertionTest.logAPIPass("RetryableWorkRejectedException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableWorkRejectedException(str, throwable)");
        }
    }

    private void checkRetryableUnavailableException() {
        try {
            RetryableUnavailableException ne = new RetryableUnavailableException();
            throw ne;
        }
        catch (RetryableUnavailableException ex) {
            APIAssertionTest.logAPIPass("RetryableUnavailableException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableUnavailableException(null)");
        }
        try {
            RetryableUnavailableException ne = new RetryableUnavailableException("message1");
            throw ne;
        }
        catch (RetryableUnavailableException ex) {
            APIAssertionTest.logAPIPass("RetryableUnavailableException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableUnavailableException(str)");
        }
        try {
            RetryableUnavailableException ne = new RetryableUnavailableException("message1", "ERRCODE1");
            throw ne;
        }
        catch (RetryableUnavailableException ex) {
            APIAssertionTest.logAPIPass("RetryableUnavailableException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableUnavailableException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            RetryableUnavailableException ne = new RetryableUnavailableException((Throwable)someThrowable);
            throw ne;
        }
        catch (RetryableUnavailableException ex) {
            APIAssertionTest.logAPIPass("RetryableUnavailableException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableUnavailableException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            RetryableUnavailableException ne = new RetryableUnavailableException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (RetryableUnavailableException ex) {
            APIAssertionTest.logAPIPass("RetryableUnavailableException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying RetryableUnavailableException(str, throwable)");
        }
    }

    private void checkApplicationServerInternalException() {
        try {
            ApplicationServerInternalException ne = new ApplicationServerInternalException();
            throw ne;
        }
        catch (ApplicationServerInternalException ex) {
            APIAssertionTest.logAPIPass("ApplicationServerInternalException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ApplicationServerInternalException(null)");
        }
        try {
            ApplicationServerInternalException ne = new ApplicationServerInternalException("message1");
            throw ne;
        }
        catch (ApplicationServerInternalException ex) {
            APIAssertionTest.logAPIPass("ApplicationServerInternalException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ApplicationServerInternalException(str)");
        }
        try {
            ApplicationServerInternalException ne = new ApplicationServerInternalException("message1", "ERRCODE1");
            throw ne;
        }
        catch (ApplicationServerInternalException ex) {
            APIAssertionTest.logAPIPass("ApplicationServerInternalException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ApplicationServerInternalException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ApplicationServerInternalException ne = new ApplicationServerInternalException((Throwable)someThrowable);
            throw ne;
        }
        catch (ApplicationServerInternalException ex) {
            APIAssertionTest.logAPIPass("ApplicationServerInternalException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ApplicationServerInternalException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ApplicationServerInternalException ne = new ApplicationServerInternalException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (ApplicationServerInternalException ex) {
            APIAssertionTest.logAPIPass("ApplicationServerInternalException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ApplicationServerInternalException(str, throwable)");
        }
    }

    private void checkWorkException() {
        try {
            WorkException ne = new WorkException();
            throw ne;
        }
        catch (WorkException ex) {
            APIAssertionTest.logAPIPass("WorkException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkException(null)");
        }
        try {
            WorkException ne = new WorkException("message1");
            throw ne;
        }
        catch (WorkException ex) {
            APIAssertionTest.logAPIPass("WorkException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkException(str)");
        }
        try {
            WorkException ne = new WorkException("message1", "ERRCODE1");
            throw ne;
        }
        catch (WorkException ex) {
            APIAssertionTest.logAPIPass("WorkException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            WorkException ne = new WorkException((Throwable)someThrowable);
            throw ne;
        }
        catch (WorkException ex) {
            APIAssertionTest.logAPIPass("WorkException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            WorkException ne = new WorkException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (WorkException ex) {
            APIAssertionTest.logAPIPass("WorkException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkException(str, throwable)");
        }
    }

    private void checkWorkCompletedException() {
        try {
            WorkCompletedException ne = new WorkCompletedException();
            throw ne;
        }
        catch (WorkCompletedException ex) {
            APIAssertionTest.logAPIPass("WorkCompletedException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkCompletedException(null)");
        }
        try {
            WorkCompletedException ne = new WorkCompletedException("message1");
            throw ne;
        }
        catch (WorkCompletedException ex) {
            APIAssertionTest.logAPIPass("WorkCompletedException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkCompletedException(str)");
        }
        try {
            WorkCompletedException ne = new WorkCompletedException("message1", "ERRCODE1");
            throw ne;
        }
        catch (WorkCompletedException ex) {
            APIAssertionTest.logAPIPass("WorkCompletedException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkCompletedException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            WorkCompletedException ne = new WorkCompletedException((Throwable)someThrowable);
            throw ne;
        }
        catch (WorkCompletedException ex) {
            APIAssertionTest.logAPIPass("WorkCompletedException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkCompletedException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            WorkCompletedException ne = new WorkCompletedException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (WorkCompletedException ex) {
            APIAssertionTest.logAPIPass("WorkCompletedException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkCompletedException(str, throwable)");
        }
    }

    private void checkWorkRejectedException() {
        try {
            WorkRejectedException ne = new WorkRejectedException();
            throw ne;
        }
        catch (WorkRejectedException ex) {
            APIAssertionTest.logAPIPass("WorkRejectedException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkRejectedException(null)");
        }
        try {
            WorkRejectedException ne = new WorkRejectedException("message1");
            throw ne;
        }
        catch (WorkRejectedException ex) {
            APIAssertionTest.logAPIPass("WorkRejectedException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkRejectedException(str)");
        }
        try {
            WorkRejectedException ne = new WorkRejectedException("message1", "ERRCODE1");
            throw ne;
        }
        catch (WorkRejectedException ex) {
            APIAssertionTest.logAPIPass("WorkRejectedException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkRejectedException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            WorkRejectedException ne = new WorkRejectedException((Throwable)someThrowable);
            throw ne;
        }
        catch (WorkRejectedException ex) {
            APIAssertionTest.logAPIPass("WorkRejectedException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkRejectedException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            WorkRejectedException ne = new WorkRejectedException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (WorkRejectedException ex) {
            APIAssertionTest.logAPIPass("WorkRejectedException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying WorkRejectedException(str, throwable)");
        }
    }

    private void checkUnavailableException() {
        try {
            UnavailableException ne = new UnavailableException();
            throw ne;
        }
        catch (UnavailableException ex) {
            APIAssertionTest.logAPIPass("UnavailableException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying UnavailableException(null)");
        }
        try {
            UnavailableException ne = new UnavailableException("message1");
            throw ne;
        }
        catch (UnavailableException ex) {
            APIAssertionTest.logAPIPass("UnavailableException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying UnavailableException(str)");
        }
        try {
            UnavailableException ne = new UnavailableException("message1", "ERRCODE1");
            throw ne;
        }
        catch (UnavailableException ex) {
            APIAssertionTest.logAPIPass("UnavailableException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying UnavailableException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            UnavailableException ne = new UnavailableException((Throwable)someThrowable);
            throw ne;
        }
        catch (UnavailableException ex) {
            APIAssertionTest.logAPIPass("UnavailableException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying UnavailableException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            UnavailableException ne = new UnavailableException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (UnavailableException ex) {
            APIAssertionTest.logAPIPass("UnavailableException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying UnavailableException(str, throwable)");
        }
    }

    private void checkSharingViolationException() {
        try {
            SharingViolationException ne = new SharingViolationException();
            throw ne;
        }
        catch (SharingViolationException ex) {
            APIAssertionTest.logAPIPass("SharingViolationException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SharingViolationException(null)");
        }
        try {
            SharingViolationException ne = new SharingViolationException("message1");
            throw ne;
        }
        catch (SharingViolationException ex) {
            APIAssertionTest.logAPIPass("SharingViolationException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SharingViolationException(str)");
        }
        try {
            SharingViolationException ne = new SharingViolationException("message1", "ERRCODE1");
            throw ne;
        }
        catch (SharingViolationException ex) {
            APIAssertionTest.logAPIPass("SharingViolationException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SharingViolationException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            SharingViolationException ne = new SharingViolationException((Throwable)someThrowable);
            throw ne;
        }
        catch (SharingViolationException ex) {
            APIAssertionTest.logAPIPass("SharingViolationException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SharingViolationException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            SharingViolationException ne = new SharingViolationException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (SharingViolationException ex) {
            APIAssertionTest.logAPIPass("SharingViolationException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SharingViolationException(str, throwable)");
        }
    }

    private void checkSecurityException() {
        try {
            SecurityException ne = new SecurityException();
            throw ne;
        }
        catch (SecurityException ex) {
            APIAssertionTest.logAPIPass("SecurityException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SecurityException(null)");
        }
        try {
            SecurityException ne = new SecurityException("message1");
            throw ne;
        }
        catch (SecurityException ex) {
            APIAssertionTest.logAPIPass("SecurityException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SecurityException(str)");
        }
        try {
            SecurityException ne = new SecurityException("message1", "ERRCODE1");
            throw ne;
        }
        catch (SecurityException ex) {
            APIAssertionTest.logAPIPass("SecurityException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SecurityException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            SecurityException ne = new SecurityException((Throwable)someThrowable);
            throw ne;
        }
        catch (SecurityException ex) {
            APIAssertionTest.logAPIPass("SecurityException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SecurityException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            SecurityException ne = new SecurityException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (SecurityException ex) {
            APIAssertionTest.logAPIPass("SecurityException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying SecurityException(str, throwable)");
        }
    }

    private void checkResourceAllocationException() {
        try {
            ResourceAllocationException ne = new ResourceAllocationException();
            throw ne;
        }
        catch (ResourceAllocationException ex) {
            APIAssertionTest.logAPIPass("ResourceAllocationException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAllocationException(null)");
        }
        try {
            ResourceAllocationException ne = new ResourceAllocationException("message1");
            throw ne;
        }
        catch (ResourceAllocationException ex) {
            APIAssertionTest.logAPIPass("ResourceAllocationException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAllocationException(str)");
        }
        try {
            ResourceAllocationException ne = new ResourceAllocationException("message1", "ERRCODE1");
            throw ne;
        }
        catch (ResourceAllocationException ex) {
            APIAssertionTest.logAPIPass("ResourceAllocationException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAllocationException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ResourceAllocationException ne = new ResourceAllocationException((Throwable)someThrowable);
            throw ne;
        }
        catch (ResourceAllocationException ex) {
            APIAssertionTest.logAPIPass("ResourceAllocationException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAllocationException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ResourceAllocationException ne = new ResourceAllocationException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (ResourceAllocationException ex) {
            APIAssertionTest.logAPIPass("ResourceAllocationException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAllocationException(str, throwable)");
        }
    }

    private void checkResourceAdapterInternalException() {
        try {
            ResourceAdapterInternalException ne = new ResourceAdapterInternalException();
            throw ne;
        }
        catch (ResourceAdapterInternalException ex) {
            APIAssertionTest.logAPIPass("ResourceAdapterInternalException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAdapterInternalException(null)");
        }
        try {
            ResourceAdapterInternalException ne = new ResourceAdapterInternalException("message1");
            throw ne;
        }
        catch (ResourceAdapterInternalException ex) {
            APIAssertionTest.logAPIPass("ResourceAdapterInternalException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAdapterInternalException(str)");
        }
        try {
            ResourceAdapterInternalException ne = new ResourceAdapterInternalException("message1", "ERRCODE1");
            throw ne;
        }
        catch (ResourceAdapterInternalException ex) {
            APIAssertionTest.logAPIPass("ResourceAdapterInternalException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAdapterInternalException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ResourceAdapterInternalException ne = new ResourceAdapterInternalException((Throwable)someThrowable);
            throw ne;
        }
        catch (ResourceAdapterInternalException ex) {
            APIAssertionTest.logAPIPass("ResourceAdapterInternalException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAdapterInternalException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ResourceAdapterInternalException ne = new ResourceAdapterInternalException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (ResourceAdapterInternalException ex) {
            APIAssertionTest.logAPIPass("ResourceAdapterInternalException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceAdapterInternalException(str, throwable)");
        }
    }

    private void checkLocalTransactionException() {
        try {
            LocalTransactionException ne = new LocalTransactionException();
            throw ne;
        }
        catch (LocalTransactionException ex) {
            APIAssertionTest.logAPIPass("LocalTransactionException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying LocalTransactionException(null)");
        }
        try {
            LocalTransactionException ne = new LocalTransactionException("message1");
            throw ne;
        }
        catch (LocalTransactionException ex) {
            APIAssertionTest.logAPIPass("LocalTransactionException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying LocalTransactionException(str)");
        }
        try {
            LocalTransactionException ne = new LocalTransactionException("message1", "ERRCODE1");
            throw ne;
        }
        catch (LocalTransactionException ex) {
            APIAssertionTest.logAPIPass("LocalTransactionException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying LocalTransactionException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            LocalTransactionException ne = new LocalTransactionException((Throwable)someThrowable);
            throw ne;
        }
        catch (LocalTransactionException ex) {
            APIAssertionTest.logAPIPass("LocalTransactionException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying LocalTransactionException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            LocalTransactionException ne = new LocalTransactionException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (LocalTransactionException ex) {
            APIAssertionTest.logAPIPass("LocalTransactionException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying LocalTransactionException(str, throwable)");
        }
    }

    private void checkNotSupportedException() {
        try {
            NotSupportedException ne = new NotSupportedException();
            throw ne;
        }
        catch (NotSupportedException ex) {
            APIAssertionTest.logAPIPass("NotSupportedException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying NotSupportedException(null)");
        }
        try {
            NotSupportedException ne = new NotSupportedException("message1");
            throw ne;
        }
        catch (NotSupportedException ex) {
            APIAssertionTest.logAPIPass("NotSupportedException(str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying NotSupportedException(str)");
        }
        try {
            NotSupportedException ne = new NotSupportedException("message1", "ERRCODE1");
            throw ne;
        }
        catch (NotSupportedException ex) {
            APIAssertionTest.logAPIPass("NotSupportedException(str, str) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying NotSupportedException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            NotSupportedException ne = new NotSupportedException((Throwable)someThrowable);
            throw ne;
        }
        catch (NotSupportedException ex) {
            APIAssertionTest.logAPIPass("NotSupportedException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying NotSupportedException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            NotSupportedException ne = new NotSupportedException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (NotSupportedException ex) {
            APIAssertionTest.logAPIPass("NotSupportedException(str, throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying NotSupportedException(str, throwable)");
        }
    }

    private void checkResourceException() {
        ResourceException ne;
        String str;
        try {
            ResourceException ne2 = new ResourceException();
            throw ne2;
        }
        catch (ResourceException ex) {
            APIAssertionTest.logAPIPass("ResourceException(null) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceException(null)");
        }
        try {
            ResourceException ne3 = new ResourceException("message1");
            ne3.setErrorCode("ERRCODE2");
            throw ne3;
        }
        catch (ResourceException ex) {
            APIAssertionTest.logAPIPass("ResourceException(str) passed");
            if (ex.getErrorCode() != null) {
                str = ex.getErrorCode().toUpperCase();
                if (str.indexOf("ERRCODE2") != -1) {
                    APIAssertionTest.logAPIPass("ResourceException.setErrorCode(str) passed");
                }
            } else {
                Debug.trace("Error verifying ResourceException(str, str)");
            }
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceException(str)");
        }
        try {
            ResourceException ne4 = new ResourceException("message1", "ERRCODE1");
            throw ne4;
        }
        catch (ResourceException ex) {
            APIAssertionTest.logAPIPass("ResourceException(str, str) passed");
            if (ex.getErrorCode() != null) {
                str = ex.getErrorCode().toUpperCase();
                if (str.indexOf("ERRCODE1") != -1) {
                    APIAssertionTest.logAPIPass("ResourceException.getErrorCode() passed");
                }
            } else {
                Debug.trace("Error verifying ResourceException(str, str)");
            }
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceException(str, str)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ne = new ResourceException((Throwable)someThrowable);
            throw ne;
        }
        catch (ResourceException ex) {
            APIAssertionTest.logAPIPass("ResourceException(throwable) passed");
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceException(throwable)");
        }
        try {
            Exception someThrowable = new Exception("test");
            ne = new ResourceException("someString", (Throwable)someThrowable);
            throw ne;
        }
        catch (ResourceException ex) {
            APIAssertionTest.logAPIPass("ResourceException(str, someThrowable) passed");
            if (ex.getMessage() != null) {
                APIAssertionTest.logAPIPass("ResourceException.getMessage() passed");
            } else {
                Debug.trace("Error verifying ResourceException(str, someThrowable)");
            }
        }
        catch (Exception ex) {
            Debug.trace("Error verifying ResourceException(str, throwable)");
        }
    }

    private static void logAPIPass(String outStr) {
        ConnectorStatus.getConnectorStatus().logState(outStr);
        Debug.trace(outStr);
    }
}

