/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkeycolumn;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkeycolumn.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkeycolumn.Department2;
import ee.jakarta.tck.persistence.core.annotations.mapkeycolumn.Employee;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    private static Employee[] empRef = new Employee[10];
    private static Department[] deptRef = new Department[5];
    private static Department2[] deptRef2 = new Department2[5];
    public Map<String, Employee> link = new HashMap<String, Employee>();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationMapKeyColumnTest1() throws Exception {
        boolean pass = false;
        List e = null;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find Employees belonging to Department: Marketing");
            e = this.getEntityManager().createQuery("Select e from Employee e where e.department.name = 'Marketing'").setMaxResults(10).getResultList();
            if (e.size() != 3) {
                this.logErr("Did not get expected resultsExpected 3 Employees, Received: " + e.size());
            } else {
                this.logTrace("annotationMapKeyColumnTest1: Expected results received. Expected 3 Employees, Received: " + e.size());
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMapKeyColumnTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationMapKeyColumnTest2() throws Exception {
        boolean pass = false;
        List e = null;
        try {
            this.getEntityTransaction().begin();
            Object[] expectedEmps = new Integer[]{4, 2};
            this.logTrace("find Employees belonging to Department: Marketing");
            e = this.getEntityManager().createQuery("Select e.id from Employee e where e.department.name = 'Administration' ORDER BY e.id DESC").setMaxResults(10).getResultList();
            Object[] result = e.toArray(new Integer[e.size()]);
            this.logTrace("Compare results of Employee Ids ");
            pass = Arrays.equals(expectedEmps, result);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 2 Employees :  Received: " + e.size());
                Iterator it = e.iterator();
                while (it.hasNext()) {
                    this.logTrace(" Employee PK : " + it.next());
                }
            } else {
                this.logTrace("Expected results received");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMapKeyColumnTest2 failed");
        }
    }

    public void annotationMapKeyColumnTest3() throws Exception {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(0);
        expected.add(2);
        expected.add(4);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            this.logTrace("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map<String, Employee> emps = dept.getLastNameEmployees();
            if (emps.size() == 3) {
                this.logTrace("number of employees=" + emps.size());
                for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                    this.logTrace("id=" + entry.getValue().getId() + ", Name=" + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                    actual.add(entry.getValue().getId() - 1);
                }
                Collections.sort(actual);
                if (expected.equals(actual)) {
                    this.logTrace("Received expected employees");
                    pass = true;
                } else {
                    this.logErr("Did not get correct employees");
                    this.logErr("Expected:");
                    for (Integer i : expected) {
                        this.logTrace("id=" + empRef[i].getId() + ", Name=" + empRef[i].getFirstName() + " " + empRef[i].getLastName());
                    }
                    this.logErr("Actual:");
                    for (Integer i : actual) {
                        this.logTrace("id=" + empRef[i].getId() + ", Name=" + empRef[i].getFirstName() + " " + empRef[i].getLastName());
                    }
                }
            } else {
                this.logErr("Expected 3 employees, actual:" + emps.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("annotationMapKeyColumnTest3 Failed");
        }
    }

    public void mapKeyColumnInsertableFalseTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department2 dept = (Department2)this.getEntityManager().find(Department2.class, (Object)3);
            if (dept != null) {
                this.logTrace("Dept=" + dept.getName());
                Map<String, Employee> emps = dept.getLastNameEmployees();
                if (emps.size() == 0) {
                    this.logTrace("Received expected number of employees");
                    pass = true;
                } else {
                    this.logErr("Expected 0 employees, actual:" + emps.size());
                    this.logErr("Actual:");
                    for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                        this.logErr("id=" + entry.getValue().getId() + ", Name=" + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                    }
                }
            } else {
                this.logErr("Department2 returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("mapKeyColumnInsertableFalseTest Failed");
        }
    }

    public void mapKeyColumnUpdatableFalseTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.logTrace("find Department");
            Department2 dept = (Department2)this.getEntityManager().find(Department2.class, (Object)deptRef2[0].getId());
            this.logTrace("Dept=" + dept.getName());
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-006", empRef[6]);
            this.logTrace("set last names of employees and save");
            dept.setLastNameEmployees(this.link);
            this.getEntityManager().merge((Object)dept);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find Department again");
            dept = (Department2)this.getEntityManager().find(Department2.class, (Object)deptRef2[0].getId());
            Map<String, Employee> emps = dept.getLastNameEmployees();
            if (emps.size() == 0) {
                this.logTrace("Received expected number of employees for department: " + deptRef2[0].getId());
                pass = true;
            } else {
                this.logErr("Expected 0 employees, actual:" + emps.size());
                this.logErr("Actual:");
                for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                    this.logErr("id=" + entry.getValue().getId() + ", Name=" + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("mapKeyColumnUpdatableFalseTest Failed");
        }
    }

    public void criteriaBuilderKeysValuesTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<String> expected = new HashSet<String>();
        expected.add("OFF-000");
        expected.add("OFF-002");
        expected.add("OFF-004");
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            System.out.println("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department dept = emp.getDepartment();
            System.out.println("Dept=" + dept.getName());
            Map<String, Employee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                    this.logTrace("map:" + entry.getKey() + ", " + entry.getValue().getId() + " " + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                }
            }
            Set<String> keys = emps.keySet();
            for (String key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (String key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (String key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[2]);
            hashSet.add(empRef[4]);
            Collection<Employee> employees = emps.values();
            for (Employee e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("criteriaBuilderKeysValuesTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create 2 Departments");
            Client.deptRef[0] = new Department(1, "Marketing");
            Client.deptRef[1] = new Department(2, "Administration");
            this.logTrace("Start to persist departments ");
            for (Department department : deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.logTrace("persisted department " + department.getName());
            }
            this.logTrace("Create 2 Department2 ");
            Client.deptRef2[0] = new Department2(3, "IT");
            this.logTrace("Start to persist Department2 ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted department " + ((Department2)serializable).getName());
            }
            this.logTrace("Create 5 employees");
            Client.empRef[0] = new Employee(1, "Alan", "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(2, "Arthur", "Frechette");
            empRef[1].setDepartment(deptRef[1]);
            Client.empRef[2] = new Employee(3, "Shelly", "McGowan");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef[3] = new Employee(4, "Robert", "Bissett");
            empRef[3].setDepartment(deptRef[1]);
            Client.empRef[4] = new Employee(5, "Stephen", "DMilla");
            empRef[4].setDepartment(deptRef[0]);
            this.link.put("OFF-000", empRef[0]);
            this.link.put("OFF-002", empRef[2]);
            this.link.put("OFF-004", empRef[4]);
            deptRef[0].setLastNameEmployees(this.link);
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-001", empRef[1]);
            this.link.put("OFF-003", empRef[3]);
            deptRef[1].setLastNameEmployees(this.link);
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-005", empRef[5]);
            deptRef2[0].setLastNameEmployees(this.link);
            this.logTrace("Start to persist employees ");
            for (Serializable serializable : empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted employee " + ((Employee)serializable).getId());
            }
            this.logTrace("Start to Merge department ");
            for (Serializable serializable : deptRef) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged department " + ((Department)serializable).getName());
            }
            this.logTrace("Start to Merge department ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged department " + ((Department2)serializable).getName());
            }
            this.logTrace("Start to persist employees ");
            for (Serializable serializable : empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted employee " + ((Employee)serializable).getId());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

