/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.DefaultHeaderOrFooterBuilder;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.HeaderBuilder;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.web.client.configuration.Configurations;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.ConfigurableComponentUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetMgmtUi;
import org.eclipse.kura.web.client.ui.drivers.assets.ConfigurationUiButtons;
import org.eclipse.kura.web.client.ui.drivers.assets.DriversAndAssetsRPC;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.Well;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class DriversAndAssetsListUi
extends Composite {
    private static final String CELL_NOT_VALID = "cell-not-valid";
    private static DriversAndAssetsListUiUiBinder uiBinder = (DriversAndAssetsListUiUiBinder)GWT.create(DriversAndAssetsListUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final ListDataProvider<DriverAssetInfo> driversAssetsDataProvider = new ListDataProvider();
    private final SingleSelectionModel<DriverAssetInfo> selectionModel = new SingleSelectionModel();
    @UiField
    Well driversAndAssetsMgmtPanel;
    @UiField
    Label emptyListLabel;
    @UiField
    CellTable<DriverAssetInfo> driversAssetsListTable;
    @UiField
    PanelHeader contentPanelHeader;
    @UiField
    Panel configurationArea;
    private Listener listener;
    private Configurations configurations;
    private ConfigurableComponentUi driverConfigUi;
    private AssetMgmtUi assetMgmtUi;

    public DriversAndAssetsListUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.driversAssetsListTable.setSelectionModel(this.selectionModel);
        this.driversAssetsDataProvider.addDataDisplay(this.driversAssetsListTable);
        this.emptyListLabel.setText(MSGS.noDriversAvailable());
        this.initTable();
        this.initSelectionModel();
    }

    private void initSelectionModel() {
        this.selectionModel.addSelectionChangeHandler(event -> {
            DriverAssetInfo selectedInstanceEntry = (DriverAssetInfo)this.selectionModel.getSelectedObject();
            if (this.listener != null) {
                this.listener.onSelectionChanged(selectedInstanceEntry);
            }
            this.cleanConfigurationArea();
            if (selectedInstanceEntry == null) {
                return;
            }
            String pid = selectedInstanceEntry.getPid();
            HasConfiguration hasConfiguration = this.configurations.getConfiguration(pid);
            if (hasConfiguration == null) {
                this.showWarning(selectedInstanceEntry.getPid(), MSGS.errorComponentConfigurationMissing(pid));
            } else {
                this.fillWithConfiguration(selectedInstanceEntry, pid, hasConfiguration);
            }
            this.configurationArea.setVisible(true);
        });
    }

    private void fillWithConfiguration(DriverAssetInfo selectedInstanceEntry, String pid, HasConfiguration hasConfiguration) {
        if (!selectedInstanceEntry.isAsset()) {
            ConfigurableComponentUi driverUi = new ConfigurableComponentUi(hasConfiguration.getConfiguration());
            ConfigurationUiButtons buttonBar = this.createDriverConfigButtonBar(driverUi);
            driverUi.renderForm();
            this.driverConfigUi = driverUi;
            this.contentPanelHeader.setText(MSGS.driverLabel(selectedInstanceEntry.getPid()));
            this.driversAndAssetsMgmtPanel.add((Widget)buttonBar);
            if (selectedInstanceEntry.getChannelDescriptor() == null) {
                this.showWarning(null, MSGS.errorDriverDescriptorMissing(pid));
            }
            this.driversAndAssetsMgmtPanel.add((Widget)this.driverConfigUi);
        } else if (selectedInstanceEntry.getChannelDescriptor() != null) {
            AssetMgmtUi assetUi;
            this.assetMgmtUi = assetUi = new AssetMgmtUi(hasConfiguration, this.configurations);
            this.contentPanelHeader.setText(MSGS.assetLabel(selectedInstanceEntry.getPid()));
            this.driversAndAssetsMgmtPanel.add((Widget)this.assetMgmtUi);
        } else {
            this.showWarning(MSGS.assetLabel(selectedInstanceEntry.getPid()), MSGS.errorDriverDescriptorMissingForAsset(pid, selectedInstanceEntry.getDriverPid()));
        }
    }

    private void showWarning(String caption, String message) {
        if (caption != null) {
            this.contentPanelHeader.setText(caption);
        }
        this.driversAndAssetsMgmtPanel.add((Widget)new Alert(message, AlertType.DANGER));
    }

    public void setConfigurations(Configurations configurations) {
        this.configurations = configurations;
    }

    private void initTable() {
        this.driversAssetsListTable.setHeaderBuilder((HeaderBuilder)new DefaultHeaderOrFooterBuilder(this.driversAssetsListTable, false));
        Column<DriverAssetInfo, String> c2 = new Column<DriverAssetInfo, String>((Cell)new TextCell()){

            public String getCellStyleNames(Cell.Context context, DriverAssetInfo object) {
                return object.isValid() ? null : DriversAndAssetsListUi.CELL_NOT_VALID;
            }

            public String getValue(DriverAssetInfo object) {
                return object.isAsset() ? " -> " + object.pid : object.pid;
            }
        };
        this.driversAssetsListTable.addColumn((Column)c2, (Header)new TextHeader(MSGS.servicePidLabel()));
        Column<DriverAssetInfo, String> c3 = new Column<DriverAssetInfo, String>((Cell)new TextCell()){

            public String getCellStyleNames(Cell.Context context, DriverAssetInfo object) {
                return object.isValid() ? null : DriversAndAssetsListUi.CELL_NOT_VALID;
            }

            public String getValue(DriverAssetInfo object) {
                return object.isAsset() ? "Asset" : "Driver";
            }
        };
        this.driversAssetsListTable.addColumn((Column)c3, (Header)new TextHeader(MSGS.typeLabel()));
        Column<DriverAssetInfo, String> c4 = new Column<DriverAssetInfo, String>((Cell)new TextCell()){

            public String getCellStyleNames(Cell.Context context, DriverAssetInfo object) {
                return object.isValid() ? null : DriversAndAssetsListUi.CELL_NOT_VALID;
            }

            public String getValue(DriverAssetInfo object) {
                String factoryPid = object.getFactoryPid();
                return factoryPid != null ? factoryPid : "Unknown";
            }
        };
        this.driversAssetsListTable.addColumn((Column)c4, (Header)new TextHeader(MSGS.factoryPidLabel()));
    }

    private List<DriverAssetInfo> getAssetsForDriver(Map<String, List<DriverAssetInfo>> map, String driverPid) {
        return map.computeIfAbsent(driverPid, pid -> new ArrayList());
    }

    private DriverAssetInfo getDriverEntry(String driverPid) {
        HasConfiguration driverConfig = this.configurations.getConfiguration(driverPid);
        if (driverConfig == null) {
            return new DriverAssetInfo(driverPid);
        }
        return new DriverAssetInfo(driverConfig);
    }

    private List<DriverAssetInfo> buildTableList() {
        ArrayList<DriverAssetInfo> result = new ArrayList<DriverAssetInfo>();
        HashMap<String, List<DriverAssetInfo>> grouped = new HashMap<String, List<DriverAssetInfo>>();
        Collection<HasConfiguration> configs = this.configurations.getConfigurations();
        for (HasConfiguration hasConfiguration : configs) {
            DriverAssetInfo entry = new DriverAssetInfo(hasConfiguration);
            if (entry.isAsset()) {
                this.getAssetsForDriver(grouped, entry.getDriverPid()).add(entry);
                continue;
            }
            if (!hasConfiguration.getConfiguration().isDriver()) continue;
            this.getAssetsForDriver(grouped, entry.getPid());
        }
        for (Map.Entry entry : grouped.entrySet()) {
            result.add(this.getDriverEntry((String)entry.getKey()));
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    public void refresh() {
        List<DriverAssetInfo> tableList = this.buildTableList();
        if (tableList.isEmpty()) {
            this.emptyListLabel.setVisible(true);
            this.driversAssetsListTable.setVisible(false);
        } else {
            this.emptyListLabel.setVisible(false);
            this.driversAssetsListTable.setVisible(true);
            this.driversAssetsDataProvider.getList().clear();
            this.driversAssetsDataProvider.getList().addAll(tableList);
            this.driversAssetsDataProvider.refresh();
            int size = this.driversAssetsDataProvider.getList().size();
            this.driversAssetsListTable.setVisibleRange(0, size);
            this.driversAssetsListTable.redraw();
        }
        this.selectionModel.clear();
        if (this.listener != null) {
            this.listener.onSelectionChanged(null);
        }
        this.cleanConfigurationArea();
    }

    private void cleanConfigurationArea() {
        this.configurationArea.setVisible(false);
        this.driversAndAssetsMgmtPanel.clear();
        this.driverConfigUi = null;
        this.assetMgmtUi = null;
    }

    public boolean isDirty() {
        boolean result = false;
        if (this.driverConfigUi != null) {
            result = this.driverConfigUi.isDirty();
        }
        if (this.assetMgmtUi != null) {
            result = result || this.assetMgmtUi.isDirty();
        }
        return result;
    }

    public void setDirty(boolean dirty) {
        if (dirty) {
            if (this.driverConfigUi != null) {
                this.driverConfigUi.setDirty(true);
            }
            if (this.assetMgmtUi != null) {
                this.assetMgmtUi.setDirty(true);
            }
        }
        if (!dirty) {
            this.driverConfigUi = null;
            this.assetMgmtUi = null;
            this.driversAndAssetsMgmtPanel.clear();
        }
    }

    public DriverAssetInfo getSelectedItem() {
        return (DriverAssetInfo)this.selectionModel.getSelectedObject();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    private ConfigurationUiButtons createDriverConfigButtonBar(final ConfigurableComponentUi driverUi) {
        final GwtConfigComponent gwtConfig = driverUi.getConfiguration();
        ConfigurationUiButtons result = new ConfigurationUiButtons(driverUi);
        result.setListener(new ConfigurationUiButtons.Listener(){

            @Override
            public void onReset() {
                driverUi.setConfiguration(DriversAndAssetsListUi.this.configurations.getConfiguration(gwtConfig.getComponentId()).getConfiguration());
                driverUi.renderForm();
            }

            @Override
            public void onApply() {
                GwtConfigComponent configuration = driverUi.getConfiguration();
                DriversAndAssetsRPC.updateConfiguration(configuration, result1 -> {
                    DriversAndAssetsListUi.this.configurations.setConfiguration(configuration);
                    driverUi.setDirty(false);
                });
            }
        });
        return result;
    }

    public class DriverAssetInfo {
        private final String pid;
        private final String factoryPid;
        private final String driverPid;
        private GwtConfigComponent channelDescriptor;

        public DriverAssetInfo(String pid) {
            this.pid = pid;
            this.factoryPid = null;
            this.driverPid = null;
        }

        public DriverAssetInfo(HasConfiguration hasConfig) {
            GwtConfigComponent config = hasConfig.getConfiguration();
            this.pid = config.getComponentId();
            this.factoryPid = config.getFactoryId();
            this.driverPid = config.getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value());
            this.channelDescriptor = DriversAndAssetsListUi.this.configurations.getChannelDescriptor(this.isAsset() ? this.getDriverPid() : this.pid);
        }

        public String getPid() {
            return this.pid;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public String getDriverPid() {
            return this.driverPid;
        }

        public boolean isAsset() {
            return this.driverPid != null;
        }

        public GwtConfigComponent getChannelDescriptor() {
            return this.channelDescriptor;
        }

        public boolean isValid() {
            return this.factoryPid != null && this.channelDescriptor != null;
        }
    }

    static interface DriversAndAssetsListUiUiBinder
    extends UiBinder<Widget, DriversAndAssetsListUi> {
    }

    public static interface Listener {
        public void onSelectionChanged(DriverAssetInfo var1);
    }
}

