/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.network.NetworkTab;
import org.eclipse.kura.web.client.ui.network.TabTcpIpUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.HelpButton;
import org.eclipse.kura.web.client.util.MessageUtils;
import org.eclipse.kura.web.shared.model.GwtModemAuthType;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtModemPdpEntry;
import org.eclipse.kura.web.shared.model.GwtModemPdpType;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.service.GwtNetworkServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;

public class TabModemUi
extends Composite
implements NetworkTab {
    private static final String DE910 = "DE910";
    private static final String LE910 = "LE910";
    private static final String HE910 = "HE910";
    private static final String MODEM_AUTH_NONE_MESSAGE = MessageUtils.get(GwtModemAuthType.netModemAuthNONE.name());
    private static TabModemUiUiBinder uiBinder = (TabModemUiUiBinder)GWT.create(TabModemUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final String REGEX_NUM = "(?:\\d*)?\\d+";
    private final GwtSession session;
    private final TabTcpIpUi tcpTab;
    private boolean dirty;
    private GwtModemInterfaceConfig selectedNetIfConfig;
    private final Map<String, String> defaultDialString = new HashMap<String, String>();
    private String dialString;
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtNetworkServiceAsync gwtNetworkService = (GwtNetworkServiceAsync)GWT.create(GwtNetworkService.class);
    private final ListDataProvider<GwtModemPdpEntry> pdpDataProvider = new ListDataProvider();
    private final SingleSelectionModel<GwtModemPdpEntry> pdpSelectionModel = new SingleSelectionModel();
    private boolean pdpInit = false;
    @UiField
    FormGroup groupReset;
    @UiField
    FormGroup groupMaxfail;
    @UiField
    FormGroup groupIdle;
    @UiField
    FormGroup groupInterval;
    @UiField
    FormGroup groupFailure;
    @UiField
    FormGroup groupNumber;
    @UiField
    FormGroup groupDial;
    @UiField
    FormGroup groupApn;
    @UiField
    FormLabel labelModel;
    @UiField
    FormLabel labelNetwork;
    @UiField
    FormLabel labelService;
    @UiField
    FormLabel labelModem;
    @UiField
    FormLabel labelNumber;
    @UiField
    FormLabel labelDial;
    @UiField
    FormLabel labelApn;
    @UiField
    FormLabel labelAuth;
    @UiField
    FormLabel labelUsername;
    @UiField
    FormLabel labelPassword;
    @UiField
    FormLabel labelReset;
    @UiField
    FormLabel labelPersist;
    @UiField
    FormLabel labelMaxfail;
    @UiField
    FormLabel labelIdle;
    @UiField
    FormLabel labelActive;
    @UiField
    FormLabel labelInterval;
    @UiField
    FormLabel labelFailure;
    @UiField
    HelpBlock helpReset;
    @UiField
    HelpBlock helpMaxfail;
    @UiField
    HelpBlock helpIdle;
    @UiField
    HelpBlock helpInterval;
    @UiField
    HelpBlock helpFailure;
    @UiField
    HelpBlock helpNumber;
    @UiField
    ListBox network;
    @UiField
    ListBox auth;
    @UiField
    TextBox modem;
    @UiField
    TextBox number;
    @UiField
    TextBox dial;
    @UiField
    Button buttonPdp;
    @UiField
    TextBox apn;
    @UiField
    TextBox username;
    @UiField
    TextBox reset;
    @UiField
    TextBox maxfail;
    @UiField
    TextBox idle;
    @UiField
    TextBox active;
    @UiField
    TextBox interval;
    @UiField
    TextBox failure;
    @UiField
    Modal pdpModal;
    @UiField
    PanelHeader pdpTitle;
    @UiField
    CellTable<GwtModemPdpEntry> pdpGrid = new CellTable();
    @UiField
    Alert searching;
    @UiField
    Alert noPdp;
    @UiField
    Alert pdpFail;
    @UiField
    Text searchingText;
    @UiField
    Text noPdpText;
    @UiField
    Text pdpFailText;
    @UiField
    FormControlStatic model;
    @UiField
    FormControlStatic service;
    @UiField
    Input password;
    @UiField
    InlineRadio radio1;
    @UiField
    InlineRadio radio2;
    @UiField
    PanelHeader helpTitle;
    @UiField
    ScrollPanel helpText;
    @UiField
    FieldSet field;
    @UiField
    HelpButton networkHelp;
    @UiField
    HelpButton modemHelp;
    @UiField
    HelpButton numberHelp;
    @UiField
    HelpButton dialHelp;
    @UiField
    HelpButton apnHelp;
    @UiField
    HelpButton authHelp;
    @UiField
    HelpButton usernameHelp;
    @UiField
    HelpButton passwordHelp;
    @UiField
    HelpButton resetHelp;
    @UiField
    HelpButton persistHelp;
    @UiField
    HelpButton maxfailHelp;
    @UiField
    HelpButton idleHelp;
    @UiField
    HelpButton activeHelp;
    @UiField
    HelpButton intervalHelp;
    @UiField
    HelpButton failureHelp;

    public TabModemUi(GwtSession currentSession, TabTcpIpUi tcp) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.session = currentSession;
        this.tcpTab = tcp;
        this.defaultDialString.put(HE910, "atd*99***1#");
        this.defaultDialString.put(LE910, "atd*99***2#");
        this.defaultDialString.put(DE910, "atd#777");
        this.initForm();
        this.initHelpButtons();
        this.tcpTab.status.addChangeHandler(event -> this.update());
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isValid() {
        if (this.number.getText() == null || "".equals(this.number.getText().trim())) {
            this.groupNumber.setValidationState(ValidationState.ERROR);
        }
        if (this.dial.getText() == null || "".equals(this.dial.getText().trim())) {
            this.groupDial.setValidationState(ValidationState.ERROR);
        }
        if ((this.apn.getText() == null || "".equals(this.apn.getText().trim())) && this.apn.isEnabled()) {
            this.groupApn.setValidationState(ValidationState.ERROR);
        }
        if (this.maxfail.getText() == null || "".equals(this.maxfail.getText().trim())) {
            this.groupMaxfail.setValidationState(ValidationState.ERROR);
        }
        if (this.idle.getText() == null || "".equals(this.idle.getText().trim())) {
            this.groupIdle.setValidationState(ValidationState.ERROR);
        }
        if (this.interval.getText() == null || "".equals(this.interval.getText().trim())) {
            this.groupInterval.setValidationState(ValidationState.ERROR);
        }
        if (this.failure.getText() == null || "".equals(this.failure.getText().trim())) {
            this.groupFailure.setValidationState(ValidationState.ERROR);
        }
        return !this.groupNumber.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupDial.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupApn.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupMaxfail.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupIdle.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupInterval.getValidationState().equals((Object)ValidationState.ERROR) && !this.groupFailure.getValidationState().equals((Object)ValidationState.ERROR);
    }

    @Override
    public void setNetInterface(GwtNetInterfaceConfig config) {
        this.setDirty(true);
        if (config instanceof GwtModemInterfaceConfig) {
            this.selectedNetIfConfig = (GwtModemInterfaceConfig)config;
        }
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.resetValidations();
            if (this.selectedNetIfConfig == null) {
                this.reset();
            } else {
                this.update();
            }
        }
    }

    @Override
    public void getUpdatedNetInterface(GwtNetInterfaceConfig updatedNetIf) {
        GwtModemInterfaceConfig updatedModemNetIf = (GwtModemInterfaceConfig)updatedNetIf;
        updatedModemNetIf.setPdpType(GwtModemPdpType.netModemPdpIP);
        if (this.model.getText() != null && this.service.getText() != null) {
            updatedModemNetIf.setPppNum(Integer.parseInt(this.number.getText()));
            updatedModemNetIf.setModemId(this.modem.getText().trim() != null ? this.modem.getText().trim() : "");
            updatedModemNetIf.setDialString(this.dial.getText().trim() != null ? this.dial.getText().trim() : "");
            updatedModemNetIf.setApn(this.apn.getText().trim() != null ? this.apn.getText().trim() : "");
            String authValue = this.auth.getSelectedValue();
            GwtModemAuthType[] gwtModemAuthTypeArray = GwtModemAuthType.values();
            int n = gwtModemAuthTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GwtModemAuthType authT = gwtModemAuthTypeArray[n2];
                if (MessageUtils.get(authT.name()).equals(authValue)) {
                    updatedModemNetIf.setAuthType(authT);
                }
                ++n2;
            }
            if (updatedModemNetIf.getAuthType() != GwtModemAuthType.netModemAuthNONE) {
                updatedModemNetIf.setUsername(this.username.getText().trim() != null ? this.username.getText().trim() : "");
                updatedModemNetIf.setPassword(this.password.getText().trim() != null ? this.password.getText().trim() : "");
            }
            updatedModemNetIf.setResetTimeout(Integer.parseInt(this.reset.getValue().trim()));
            updatedModemNetIf.setPersist(this.radio1.getValue());
            updatedModemNetIf.setMaxFail(Integer.parseInt(this.maxfail.getText().trim()));
            updatedModemNetIf.setIdle(Integer.parseInt(this.idle.getText().trim()));
            updatedModemNetIf.setActiveFilter(this.active.getText() != "" ? this.active.getText().trim() : "");
            updatedModemNetIf.setLcpEchoInterval(Integer.parseInt(this.interval.getText().trim()));
            updatedModemNetIf.setLcpEchoFailure(Integer.parseInt(this.failure.getText().trim()));
        } else {
            updatedModemNetIf.setPppNum(this.selectedNetIfConfig.getPppNum());
            updatedModemNetIf.setModemId(this.selectedNetIfConfig.getModemId());
            updatedModemNetIf.setDialString(this.selectedNetIfConfig.getDialString());
            updatedModemNetIf.setApn(this.selectedNetIfConfig.getApn());
            updatedModemNetIf.setAuthType(this.selectedNetIfConfig.getAuthType());
            updatedModemNetIf.setUsername(this.selectedNetIfConfig.getUsername());
            updatedModemNetIf.setPassword(this.selectedNetIfConfig.getPassword());
            updatedModemNetIf.setResetTimeout(this.selectedNetIfConfig.getResetTimeout());
            updatedModemNetIf.setPersist(this.selectedNetIfConfig.isPersist());
            updatedModemNetIf.setMaxFail(this.selectedNetIfConfig.getMaxFail());
            updatedModemNetIf.setIdle(this.selectedNetIfConfig.getIdle());
            updatedModemNetIf.setActiveFilter(this.selectedNetIfConfig.getActiveFilter());
            updatedModemNetIf.setLcpEchoInterval(this.selectedNetIfConfig.getLcpEchoInterval());
            updatedModemNetIf.setLcpEchoFailure(this.selectedNetIfConfig.getLcpEchoFailure());
        }
    }

    private void initHelpButtons() {
        this.networkHelp.setHelpText(MSGS.netModemToolTipNetworkTopology());
        this.modemHelp.setHelpText(MSGS.netModemToolTipModemIndentifier());
        this.numberHelp.setHelpText(MSGS.netModemToolTipModemInterfaceNumber());
        this.dialHelp.setHelpTextProvider(() -> {
            if ("".equals(this.dialString)) {
                return MSGS.netModemToolTipDialStringDefault();
            }
            return MSGS.netModemToolTipDialString(this.dial.getText());
        });
        this.apnHelp.setHelpText(MSGS.netModemToolTipApn());
        this.authHelp.setHelpText(MSGS.netModemToolTipAuthentication());
        this.usernameHelp.setHelpText(MSGS.netModemToolTipUsername());
        this.passwordHelp.setHelpText(MSGS.netModemToolTipPassword());
        this.resetHelp.setHelpText(MSGS.netModemToolTipResetTimeout());
        this.persistHelp.setHelpText(MSGS.netModemToolTipPersist());
        this.maxfailHelp.setHelpText(MSGS.netModemToolTipMaxFail());
        this.activeHelp.setHelpText(MSGS.netModemToolTipActiveFilter());
        this.idleHelp.setHelpText(MSGS.netModemToolTipIdle());
        this.intervalHelp.setHelpText(MSGS.netModemToolTipLcpEchoInterval());
        this.failureHelp.setHelpText(MSGS.netModemToolTipLcpEchoFailure());
    }

    private void initForm() {
        String modemModel;
        this.labelModel.setText(MSGS.netModemModel());
        this.labelNetwork.setText(MSGS.netModemNetworkTechnology());
        this.network.addItem(MSGS.unknown());
        this.network.addMouseOverHandler(event -> {
            if (this.network.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipNetworkTopology()));
            }
        });
        this.network.addMouseOutHandler(event -> this.resetHelp());
        this.network.addChangeHandler(event -> {
            this.setDirty(true);
            this.refreshForm();
        });
        this.labelService.setText(MSGS.netModemConnectionType());
        this.labelModem.setText(MSGS.netModemIdentifier());
        this.modem.addMouseOverHandler(event -> {
            if (this.modem.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipModemIndentifier()));
            }
        });
        this.modem.addMouseOutHandler(event -> this.resetHelp());
        this.modem.addValueChangeHandler(event -> this.setDirty(true));
        this.labelNumber.setText(String.valueOf(MSGS.netModemInterfaceNum()) + "*");
        this.number.addBlurHandler(event -> {
            this.setDirty(true);
            if (!(this.number.getText().trim() == null || this.number.getText().trim().matches(REGEX_NUM) && Integer.parseInt(this.number.getText()) >= 0)) {
                this.helpNumber.setText("This Field requires a numeric input");
                this.groupNumber.setValidationState(ValidationState.ERROR);
            } else {
                this.helpNumber.setText("");
                this.groupNumber.setValidationState(ValidationState.NONE);
            }
        });
        this.number.addMouseOverHandler(event -> {
            if (this.number.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipModemInterfaceNumber()));
            }
        });
        this.number.addMouseOutHandler(event -> this.resetHelp());
        this.labelDial.setText(String.valueOf(MSGS.netModemDialString()) + "*");
        this.dial.addMouseOutHandler(event -> this.resetHelp());
        this.dialString = "";
        if (this.selectedNetIfConfig != null && (modemModel = this.selectedNetIfConfig.getModel()) != null && !modemModel.isEmpty()) {
            this.dialString = modemModel.contains(HE910) ? this.defaultDialString.get(HE910) : (modemModel.contains(LE910) ? this.defaultDialString.get(LE910) : (modemModel.contains(DE910) ? this.defaultDialString.get(DE910) : ""));
        }
        this.dial.addMouseOverHandler(event -> {
            if (this.dial.isEnabled()) {
                this.helpText.clear();
                if (this.dialString.equals("")) {
                    this.helpText.add((Widget)new Span(MSGS.netModemToolTipDialStringDefault()));
                } else {
                    this.helpText.add((Widget)new Span(MSGS.netModemToolTipDialString(this.dial.getText())));
                }
            }
        });
        this.dial.addBlurHandler(event -> {
            this.setDirty(true);
            if (this.dial.getText() == null || "".equals(this.dial.getText().trim())) {
                this.groupDial.setValidationState(ValidationState.ERROR);
            } else {
                this.groupDial.setValidationState(ValidationState.NONE);
            }
        });
        this.buttonPdp.addClickHandler(event -> {
            if (!this.pdpInit) {
                this.initPdp();
                this.pdpDataProvider.getList().clear();
                this.searching.setVisible(true);
                this.noPdp.setVisible(false);
                this.pdpGrid.setVisible(false);
                this.pdpFail.setVisible(false);
            }
            this.initModal();
            this.loadPdpData();
        });
        this.labelApn.setText(String.valueOf(MSGS.netModemAPN()) + "*");
        this.apn.addMouseOverHandler(event -> {
            if (this.apn.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipApn()));
            }
        });
        this.apn.addMouseOutHandler(event -> this.resetHelp());
        this.apn.addBlurHandler(event -> {
            this.setDirty(true);
            if (this.apn.getText() == null || "".equals(this.apn.getText().trim())) {
                if (this.apn.isEnabled()) {
                    this.groupApn.setValidationState(ValidationState.ERROR);
                } else {
                    this.groupApn.setValidationState(ValidationState.NONE);
                }
            } else {
                this.groupApn.setValidationState(ValidationState.NONE);
            }
        });
        this.labelAuth.setText(MSGS.netModemAuthType());
        GwtModemAuthType[] gwtModemAuthTypeArray = GwtModemAuthType.values();
        int n = gwtModemAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GwtModemAuthType a = gwtModemAuthTypeArray[n2];
            this.auth.addItem(MessageUtils.get(a.name()));
            ++n2;
        }
        this.auth.addMouseOverHandler(event -> {
            if (this.auth.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipAuthentication()));
            }
        });
        this.auth.addMouseOutHandler(event -> this.resetHelp());
        this.auth.addChangeHandler(event -> {
            this.setDirty(true);
            this.refreshForm();
        });
        this.labelUsername.setText(MSGS.netModemUsername());
        this.username.addMouseOverHandler(event -> {
            if (this.username.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipUsername()));
            }
        });
        this.username.addMouseOutHandler(event -> this.resetHelp());
        this.username.addValueChangeHandler(event -> this.setDirty(true));
        this.labelPassword.setText(MSGS.netModemPassword());
        this.password.addMouseOverHandler(event -> {
            if (this.network.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipPassword()));
            }
        });
        this.password.addMouseOutHandler(event -> this.resetHelp());
        this.password.addValueChangeHandler(event -> this.setDirty(true));
        this.labelReset.setText(String.valueOf(MSGS.netModemResetTimeout()) + "*");
        this.reset.addMouseOverHandler(event -> {
            if (this.reset.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipResetTimeout()));
            }
        });
        this.reset.addMouseOutHandler(event -> this.resetHelp());
        this.reset.addBlurHandler(event -> {
            this.setDirty(true);
            if (!(this.reset.getText().trim() == null || this.reset.getText().trim().matches(REGEX_NUM) && Integer.parseInt(this.reset.getText()) >= 0 && Integer.parseInt(this.reset.getText()) != 1)) {
                this.helpReset.setText(MSGS.netModemInvalidResetTimeout());
                this.groupReset.setValidationState(ValidationState.ERROR);
            } else {
                this.helpReset.setText("");
                this.groupReset.setValidationState(ValidationState.NONE);
            }
        });
        this.labelPersist.setText(MSGS.netModemPersist());
        this.radio1.addMouseOverHandler(event -> {
            if (this.radio1.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipPersist()));
            }
        });
        this.radio1.addMouseOutHandler(event -> this.resetHelp());
        this.radio2.addMouseOverHandler(event -> {
            if (this.radio2.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipPersist()));
            }
        });
        this.radio2.addMouseOutHandler(event -> this.resetHelp());
        this.radio1.addValueChangeHandler(event -> this.setDirty(true));
        this.radio2.addValueChangeHandler(event -> this.setDirty(true));
        this.labelMaxfail.setText(String.valueOf(MSGS.netModemMaxFail()) + "*");
        this.maxfail.addMouseOverHandler(event -> {
            if (this.maxfail.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipMaxFail()));
            }
        });
        this.maxfail.addMouseOutHandler(event -> this.resetHelp());
        this.maxfail.addBlurHandler(event -> {
            this.setDirty(true);
            if (this.maxfail.getText().trim() != null && (!this.maxfail.getText().trim().matches(REGEX_NUM) || Integer.parseInt(this.maxfail.getText()) < 0) || this.maxfail.getText().trim().length() <= 0) {
                this.helpMaxfail.setText(MSGS.netModemInvalidMaxFail());
                this.groupMaxfail.setValidationState(ValidationState.ERROR);
            } else {
                this.helpMaxfail.setText("");
                this.groupMaxfail.setValidationState(ValidationState.NONE);
            }
        });
        this.labelIdle.setText(String.valueOf(MSGS.netModemIdle()) + "*");
        this.idle.addMouseOverHandler(event -> {
            if (this.idle.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipIdle()));
            }
        });
        this.idle.addMouseOutHandler(event -> this.resetHelp());
        this.idle.addBlurHandler(event -> {
            this.setDirty(true);
            if (!(this.idle.getText().trim() == null || this.idle.getText().trim().matches(REGEX_NUM) && Integer.parseInt(this.idle.getText()) >= 0)) {
                this.helpIdle.setText(MSGS.netModemInvalidIdle());
                this.groupIdle.setValidationState(ValidationState.ERROR);
            } else {
                this.helpIdle.setText("");
                this.groupIdle.setValidationState(ValidationState.NONE);
            }
        });
        this.labelActive.setText(MSGS.netModemActiveFilter());
        this.active.addMouseOverHandler(event -> {
            if (this.active.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipActiveFilter()));
            }
        });
        this.active.addMouseOutHandler(event -> this.resetHelp());
        this.active.addValueChangeHandler(event -> this.setDirty(true));
        this.labelInterval.setText(String.valueOf(MSGS.netModemLcpEchoInterval()) + "*");
        this.interval.addMouseOverHandler(event -> {
            if (this.interval.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipLcpEchoInterval()));
            }
        });
        this.interval.addMouseOutHandler(event -> this.resetHelp());
        this.interval.addBlurHandler(event -> {
            this.setDirty(true);
            if (!(this.interval.getText().trim() == null || this.interval.getText().trim().matches(REGEX_NUM) && Integer.parseInt(this.interval.getText()) >= 0)) {
                this.helpInterval.setText(MSGS.netModemInvalidLcpEchoInterval());
                this.groupInterval.setValidationState(ValidationState.ERROR);
            } else {
                this.groupInterval.setValidationState(ValidationState.NONE);
            }
        });
        this.labelFailure.setText(String.valueOf(MSGS.netModemLcpEchoFailure()) + "*");
        this.failure.addMouseOverHandler(event -> {
            if (this.failure.isEnabled()) {
                this.helpText.clear();
                this.helpText.add((Widget)new Span(MSGS.netModemToolTipLcpEchoFailure()));
            }
        });
        this.failure.addMouseOutHandler(event -> this.resetHelp());
        this.failure.addBlurHandler(event -> {
            this.setDirty(true);
            if (!(this.failure.getText().trim() == null || this.failure.getText().trim().matches(REGEX_NUM) && Integer.parseInt(this.failure.getText()) >= 0)) {
                this.helpFailure.setText(MSGS.netModemInvalidLcpEchoFailure());
                this.groupFailure.setValidationState(ValidationState.ERROR);
            } else {
                this.helpFailure.setText("");
                this.groupFailure.setValidationState(ValidationState.NONE);
            }
        });
        this.helpTitle.setText(MSGS.netHelpTitle());
        this.radio1.setText(MSGS.trueLabel());
        this.radio2.setText(MSGS.falseLabel());
        this.radio1.setValue(Boolean.valueOf(true));
        this.radio2.setValue(Boolean.valueOf(false));
    }

    private void resetValidations() {
        this.groupApn.setValidationState(ValidationState.NONE);
        this.groupDial.setValidationState(ValidationState.NONE);
        this.groupFailure.setValidationState(ValidationState.NONE);
        this.groupIdle.setValidationState(ValidationState.NONE);
        this.groupInterval.setValidationState(ValidationState.NONE);
        this.groupMaxfail.setValidationState(ValidationState.NONE);
        this.groupNumber.setValidationState(ValidationState.NONE);
        this.groupReset.setValidationState(ValidationState.NONE);
        this.helpReset.setText("");
        this.helpMaxfail.setText("");
        this.helpIdle.setText("");
        this.helpInterval.setText("");
        this.helpFailure.setText("");
        this.helpNumber.setText("");
    }

    private void resetHelp() {
        this.helpText.clear();
        this.helpText.add((Widget)new Span(MSGS.netHelpDefaultHint()));
    }

    private void update() {
        if (this.selectedNetIfConfig != null) {
            this.model.setText(String.valueOf(this.selectedNetIfConfig.getManufacturer()) + "-" + this.selectedNetIfConfig.getModel());
            this.network.clear();
            List<String> networkTechnologies = this.selectedNetIfConfig.getNetworkTechnology();
            if (networkTechnologies != null && !networkTechnologies.isEmpty()) {
                for (String techType : this.selectedNetIfConfig.getNetworkTechnology()) {
                    this.network.addItem(techType);
                }
            } else {
                this.network.addItem(MSGS.unknown());
            }
            this.service.setText(this.selectedNetIfConfig.getConnectionType());
            this.modem.setText(this.selectedNetIfConfig.getModemId());
            this.number.setText(String.valueOf(this.selectedNetIfConfig.getPppNum()));
            this.dial.setText(this.selectedNetIfConfig.getDialString());
            this.apn.setText(this.selectedNetIfConfig.getApn());
            GwtModemAuthType authType = GwtModemAuthType.netModemAuthNONE;
            if (this.selectedNetIfConfig.getAuthType() != null) {
                authType = this.selectedNetIfConfig.getAuthType();
            }
            int i = 0;
            while (i < this.auth.getItemCount()) {
                if (this.auth.getItemText(i).equals(MessageUtils.get(authType.name()))) {
                    this.auth.setSelectedIndex(i);
                }
                ++i;
            }
            this.username.setText(this.selectedNetIfConfig.getUsername());
            this.password.setText(this.selectedNetIfConfig.getPassword());
            this.reset.setText(String.valueOf(this.selectedNetIfConfig.getResetTimeout()));
            if (this.selectedNetIfConfig.isPersist()) {
                this.radio1.setValue(Boolean.valueOf(true));
                this.radio2.setValue(Boolean.valueOf(false));
            } else {
                this.radio1.setValue(Boolean.valueOf(false));
                this.radio2.setValue(Boolean.valueOf(true));
            }
            this.maxfail.setText(String.valueOf(this.selectedNetIfConfig.getMaxFail()));
            this.idle.setText(String.valueOf(this.selectedNetIfConfig.getIdle()));
            this.active.setText(this.selectedNetIfConfig.getActiveFilter());
            this.interval.setText(String.valueOf(this.selectedNetIfConfig.getLcpEchoInterval()));
            this.failure.setText(String.valueOf(this.selectedNetIfConfig.getLcpEchoFailure()));
        }
        this.refreshForm();
    }

    private void refreshForm() {
        this.network.setEnabled(true);
        this.modem.setEnabled(true);
        this.number.setEnabled(true);
        this.dial.setEnabled(true);
        this.buttonPdp.setEnabled(true);
        this.apn.setEnabled(true);
        this.auth.setEnabled(true);
        this.username.setEnabled(true);
        this.password.setEnabled(true);
        this.reset.setEnabled(true);
        this.radio1.setEnabled(true);
        this.radio2.setEnabled(true);
        this.maxfail.setEnabled(true);
        this.idle.setEnabled(true);
        this.active.setEnabled(true);
        this.interval.setEnabled(true);
        this.failure.setEnabled(true);
        String authTypeVal = this.auth.getSelectedItemText().trim();
        if (authTypeVal == null || authTypeVal.equalsIgnoreCase(MODEM_AUTH_NONE_MESSAGE)) {
            this.username.setEnabled(false);
            this.password.setEnabled(false);
        } else {
            this.username.setEnabled(true);
            this.password.setEnabled(true);
        }
        if (this.selectedNetIfConfig != null) {
            for (String techType : this.selectedNetIfConfig.getNetworkTechnology()) {
                if (!"EVDO".equals(techType) && !"CDMA".equals(techType)) continue;
                this.apn.setEnabled(false);
                this.auth.setEnabled(false);
                this.username.setEnabled(false);
                this.password.setEnabled(false);
                this.buttonPdp.setEnabled(false);
            }
        }
    }

    private void reset() {
        this.model.setText(null);
        this.network.setSelectedIndex(0);
        this.service.setText(null);
        this.modem.setText(null);
        this.number.setText(null);
        this.dial.setText(null);
        this.apn.setText(null);
        this.auth.setSelectedIndex(1);
        this.username.setText(null);
        this.password.setText(null);
        this.reset.setText(null);
        this.radio1.setValue(Boolean.valueOf(true));
        this.radio2.setValue(Boolean.valueOf(false));
        this.maxfail.setText(null);
        this.idle.setText(null);
        this.active.setText(null);
        this.interval.setText(null);
        this.failure.setText(null);
        this.update();
    }

    private void initModal() {
        this.pdpModal.setTitle("PDP Context Information");
        this.pdpTitle.setText("Available PDP Profiles");
        this.pdpModal.show();
        this.searchingText.setText(MSGS.netModemAlertObtainingPdpInfo());
        this.noPdpText.setText(MSGS.netModemAlertNoPdp());
        this.pdpFailText.setText(MSGS.netModemAlertObtainPdpInfoFail());
    }

    private void initPdp() {
        this.pdpInit = true;
        TextColumn<GwtModemPdpEntry> col1 = new TextColumn<GwtModemPdpEntry>(){

            public String getValue(GwtModemPdpEntry object) {
                return String.valueOf(object.getContextNumber());
            }
        };
        col1.setCellStyleNames("status-table-row");
        this.pdpGrid.addColumn((Column)col1, "Context Number");
        this.pdpGrid.setColumnWidth((Column)col1, "70px");
        TextColumn<GwtModemPdpEntry> col2 = new TextColumn<GwtModemPdpEntry>(){

            public String getValue(GwtModemPdpEntry object) {
                return object.getPdpType();
            }
        };
        col2.setCellStyleNames("status-table-row");
        this.pdpGrid.addColumn((Column)col2, "PDP Type");
        this.pdpGrid.setColumnWidth((Column)col2, "85px");
        TextColumn<GwtModemPdpEntry> col3 = new TextColumn<GwtModemPdpEntry>(){

            public String getValue(GwtModemPdpEntry object) {
                return object.getApn();
            }
        };
        col3.setCellStyleNames("status-table-row");
        this.pdpGrid.addColumn((Column)col3, "Access Point Name (APN)");
        this.pdpGrid.setColumnWidth((Column)col3, "400px");
        this.pdpDataProvider.addDataDisplay(this.pdpGrid);
        this.pdpGrid.setSelectionModel(this.pdpSelectionModel);
        this.pdpSelectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                GwtModemPdpEntry modemPdpEntry = (GwtModemPdpEntry)TabModemUi.this.pdpSelectionModel.getSelectedObject();
                if (modemPdpEntry != null) {
                    TabModemUi.this.dial.setValue((Object)TabModemUi.this.formDialString(modemPdpEntry.getContextNumber()));
                    if (!modemPdpEntry.getApn().contains("new PDP context")) {
                        TabModemUi.this.apn.setValue((Object)modemPdpEntry.getApn());
                    } else {
                        TabModemUi.this.apn.setValue((Object)"");
                    }
                    TabModemUi.this.pdpModal.hide();
                }
            }
        });
    }

    private String formDialString(int pdpContextNo) {
        StringBuilder sb = new StringBuilder();
        sb.append("atd*99***");
        sb.append(pdpContextNo);
        sb.append("#");
        return sb.toString();
    }

    private void loadPdpData() {
        this.pdpDataProvider.getList().clear();
        this.searching.setVisible(true);
        this.noPdp.setVisible(false);
        this.pdpGrid.setVisible(false);
        this.pdpFail.setVisible(false);
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                TabModemUi.this.gwtNetworkService.findPdpContextInfo(token, TabModemUi.this.selectedNetIfConfig.getName(), new AsyncCallback<List<GwtModemPdpEntry>>(){

                    public void onFailure(Throwable caught) {
                        (this).TabModemUi.this.searching.setVisible(false);
                        (this).TabModemUi.this.noPdp.setVisible(false);
                        (this).TabModemUi.this.pdpGrid.setVisible(false);
                        (this).TabModemUi.this.pdpFail.setVisible(true);
                    }

                    public void onSuccess(List<GwtModemPdpEntry> result) {
                        for (GwtModemPdpEntry pair : result) {
                            TabModemUi.this.pdpDataProvider.getList().add(pair);
                        }
                        TabModemUi.this.pdpDataProvider.flush();
                        if (!TabModemUi.this.pdpDataProvider.getList().isEmpty()) {
                            (this).TabModemUi.this.searching.setVisible(false);
                            (this).TabModemUi.this.noPdp.setVisible(false);
                            int size = TabModemUi.this.pdpDataProvider.getList().size();
                            (this).TabModemUi.this.pdpGrid.setVisibleRange(0, size);
                            (this).TabModemUi.this.pdpGrid.setVisible(true);
                            (this).TabModemUi.this.pdpFail.setVisible(false);
                        } else {
                            (this).TabModemUi.this.searching.setVisible(false);
                            (this).TabModemUi.this.noPdp.setVisible(true);
                            (this).TabModemUi.this.pdpGrid.setVisible(false);
                            (this).TabModemUi.this.pdpFail.setVisible(false);
                        }
                    }
                });
            }
        });
    }

    static interface TabModemUiUiBinder
    extends UiBinder<Widget, TabModemUi> {
    }
}

