/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloud.factory.CloudServiceFactory;
import org.eclipse.kura.cloudconnection.CloudConnectionConstants;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtCloudComponentFactories;
import org.eclipse.kura.web.shared.model.GwtCloudConnectionEntry;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtCloudPubSubEntry;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtCloudConnectionServiceImpl
extends OsgiRemoteServiceServlet
implements GwtCloudConnectionService {
    private static final long serialVersionUID = 693996483299382655L;
    private static final String CLOUD_CONNECTION_FACTORY_FILTER = "(|(objectClass=org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory)(objectClass=org.eclipse.kura.cloud.factory.CloudServiceFactory))";
    private static final String KURA_UI_CSF_PID_DEFAULT = "kura.ui.csf.pid.default";
    private static final String KURA_UI_CSF_PID_REGEX = "kura.ui.csf.pid.regex";
    private static final String CLOUD_PUBLISHER = CloudPublisher.class.getName();
    private static final String CLOUD_SUBSCRIBER = CloudSubscriber.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(GwtCloudConnectionServiceImpl.class);

    @Override
    public List<GwtCloudEntry> findCloudEntries() throws GwtKuraException {
        ArrayList<GwtCloudEntry> result = new ArrayList<GwtCloudEntry>();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            String factoryPid = service.getFactoryPid();
            if (factoryPid == null) {
                return;
            }
            for (String pid : service.getManagedCloudConnectionPids()) {
                if (pid == null) continue;
                GwtCloudConnectionEntry cloudConnectionEntry = new GwtCloudConnectionEntry();
                cloudConnectionEntry.setCloudConnectionFactoryPid(factoryPid);
                cloudConnectionEntry.setPid(pid);
                GwtCloudConnectionServiceImpl.fillState(cloudConnectionEntry);
                result.add(cloudConnectionEntry);
            }
        });
        result.addAll(GwtCloudConnectionServiceImpl.getPublisherInstances());
        result.addAll(GwtCloudConnectionServiceImpl.getSubscriberInstances());
        return result;
    }

    private static void fillState(GwtCloudConnectionEntry cloudConnectionEntry) throws GwtKuraException {
        cloudConnectionEntry.setState(GwtCloudConnectionEntry.GwtCloudConnectionState.UNREGISTERED);
        String filter = String.format("(%s=%s)", "kura.service.pid", cloudConnectionEntry.getPid());
        ServiceLocator.withAllServices(null, filter, service -> {
            if (service instanceof CloudConnectionManager) {
                cloudConnectionEntry.setState(((CloudConnectionManager)service).isConnected() ? GwtCloudConnectionEntry.GwtCloudConnectionState.CONNECTED : GwtCloudConnectionEntry.GwtCloudConnectionState.DISCONNECTED);
                cloudConnectionEntry.setConnectionType(GwtCloudConnectionEntry.GwtCloudConnectionType.CONNECTION);
            } else if (service instanceof CloudEndpoint) {
                cloudConnectionEntry.setConnectionType(GwtCloudConnectionEntry.GwtCloudConnectionType.ENDPOINT);
            } else if (service instanceof CloudService) {
                cloudConnectionEntry.setState(((CloudService)service).isConnected() ? GwtCloudConnectionEntry.GwtCloudConnectionState.CONNECTED : GwtCloudConnectionEntry.GwtCloudConnectionState.DISCONNECTED);
                cloudConnectionEntry.setConnectionType(GwtCloudConnectionEntry.GwtCloudConnectionType.CONNECTION);
            }
        });
    }

    @Override
    public GwtCloudComponentFactories getCloudComponentFactories() throws GwtKuraException {
        ArrayList<String> cloudConnectionFactoryPids = new ArrayList<String>();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            boolean bl = cloudConnectionFactoryPids.add(service.getFactoryPid());
        });
        List<GwtCloudEntry> pubSubFactories = GwtCloudConnectionServiceImpl.getPubSubFactories();
        GwtCloudComponentFactories result = new GwtCloudComponentFactories();
        result.setCloudConnectionFactoryPids(cloudConnectionFactoryPids);
        result.setPubSubFactories(pubSubFactories);
        return result;
    }

    @Override
    public List<String> findStackPidsByFactory(String factoryPid, String cloudServicePid) throws GwtKuraException {
        ArrayList<String> result = new ArrayList<String>();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(factory -> {
            if (factoryPid.equals(factory.getFactoryPid())) {
                result.addAll(factory.getStackComponentsPids(cloudServicePid));
            }
        });
        return result;
    }

    @Override
    public void createCloudServiceFromFactory(GwtXSRFToken xsrfToken, String factoryPid, String cloudServicePid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (factoryPid == null || factoryPid.trim().isEmpty() || cloudServicePid == null || cloudServicePid.trim().isEmpty()) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT);
        }
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            if (service.getFactoryPid().equals(factoryPid)) {
                service.createConfiguration(cloudServicePid);
            }
        });
    }

    @Override
    public void deleteCloudServiceFromFactory(GwtXSRFToken xsrfToken, String factoryPid, String cloudServicePid) throws GwtKuraException {
        if (factoryPid == null || factoryPid.trim().isEmpty() || cloudServicePid == null || cloudServicePid.trim().isEmpty()) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT);
        }
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactories(service -> {
            if (service.getFactoryPid().equals(factoryPid)) {
                service.deleteConfiguration(cloudServicePid);
            }
        });
    }

    @Override
    public String findSuggestedCloudServicePid(String factoryPid) throws GwtKuraException {
        AtomicReference result = new AtomicReference();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactoryRefs((ref, ctx) -> {
            CloudConnectionFactory cloudServiceFactory = GwtCloudConnectionServiceImpl.wrap(ctx.getService(ref));
            try {
                if (!cloudServiceFactory.getFactoryPid().equals(factoryPid)) {
                    return;
                }
                Object propertyObject = ref.getProperty(KURA_UI_CSF_PID_DEFAULT);
                if (propertyObject != null) {
                    result.set((String)propertyObject);
                }
            }
            finally {
                ctx.ungetService(ref);
            }
        });
        return (String)result.get();
    }

    @Override
    public String findCloudServicePidRegex(String factoryPid) throws GwtKuraException {
        AtomicReference result = new AtomicReference();
        GwtCloudConnectionServiceImpl.withAllCloudConnectionFactoryRefs((ref, ctx) -> {
            CloudConnectionFactory cloudServiceFactory = GwtCloudConnectionServiceImpl.wrap(ctx.getService(ref));
            try {
                if (!cloudServiceFactory.getFactoryPid().equals(factoryPid)) {
                    return;
                }
                Object propertyObject = ref.getProperty(KURA_UI_CSF_PID_REGEX);
                ServiceLocator.getInstance().ungetService(ref);
                if (propertyObject != null) {
                    result.set((String)propertyObject);
                }
            }
            finally {
                ctx.ungetService(ref);
            }
        });
        return (String)result.get();
    }

    @Override
    public void createPubSubInstance(GwtXSRFToken token, String pid, String factoryPid, String cloudConnectionPid) throws GwtKuraException {
        this.checkXSRFToken(token);
        ServiceLocator.applyToServiceOptionally(ConfigurationService.class, cs -> {
            cs.createFactoryConfiguration(factoryPid, pid, Collections.singletonMap(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value(), cloudConnectionPid), true);
            return null;
        });
    }

    @Override
    public void deletePubSubInstance(GwtXSRFToken token, String pid) throws GwtKuraException {
        this.checkXSRFToken(token);
        ServiceLocator.applyToServiceOptionally(ConfigurationService.class, cs -> {
            cs.deleteFactoryConfiguration(pid, true);
            return null;
        });
    }

    private static GwtCloudEntry toGwt(ComponentDescriptionDTO component) {
        if (Arrays.stream(component.serviceInterfaces).noneMatch(intf -> CLOUD_PUBLISHER.equals(intf) || CLOUD_SUBSCRIBER.equals(intf))) {
            return null;
        }
        String ccsfFactoryPidPropName = CloudConnectionConstants.CLOUD_CONNECTION_FACTORY_PID_PROP_NAME.value();
        Object ccsfFactoryPid = component.properties.get(ccsfFactoryPidPropName);
        Object factoryPid = component.properties.get("service.pid");
        Object defaultFactoryPid = component.properties.get(KURA_UI_CSF_PID_DEFAULT);
        Object defaultFactoryPidRegex = component.properties.get(KURA_UI_CSF_PID_REGEX);
        if (!(factoryPid instanceof String)) {
            logger.warn("component {} defines a CloudPublisher or CloudSubscriber but does not specify the service.pid property, ignoring it", (Object)component.name);
            return null;
        }
        if (!(ccsfFactoryPid instanceof String)) {
            logger.warn("component {} defines a CloudPublisher or CloudSubscriber but does not specify the {} property, ignoring it", (Object)component.name, (Object)ccsfFactoryPidPropName);
            return null;
        }
        GwtCloudEntry entry = new GwtCloudEntry();
        entry.setPid((String)factoryPid);
        entry.setFactoryPid((String)ccsfFactoryPid);
        entry.setDefaultFactoryPid((String)defaultFactoryPid);
        entry.setDefaultFactoryPidRegex((String)defaultFactoryPidRegex);
        return entry;
    }

    private static List<GwtCloudEntry> getPubSubFactories() throws GwtKuraException {
        return ServiceLocator.applyToServiceOptionally(ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().map(GwtCloudConnectionServiceImpl::toGwt).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static GwtCloudPubSubEntry toGwt(ServiceReference<?> ref, GwtCloudPubSubEntry.Type type) {
        Object ccsPid = ref.getProperty(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value());
        Object factoryPid = ref.getProperty("service.factoryPid");
        if (!(ccsPid instanceof String) || !(factoryPid instanceof String)) {
            return null;
        }
        String kuraServicePid = (String)ref.getProperty("kura.service.pid");
        GwtCloudPubSubEntry result = new GwtCloudPubSubEntry();
        result.setPid(kuraServicePid);
        result.setCloudConnectionPid((String)ccsPid);
        result.setFactoryPid((String)factoryPid);
        result.setType(type);
        return result;
    }

    private static Set<GwtCloudPubSubEntry> getPublisherInstances() throws GwtKuraException {
        BundleContext context = FrameworkUtil.getBundle(GwtCloudConnectionServiceImpl.class).getBundleContext();
        HashSet<GwtCloudPubSubEntry> result = new HashSet<GwtCloudPubSubEntry>();
        try {
            context.getServiceReferences(CloudPublisher.class, null).stream().map(ref -> GwtCloudConnectionServiceImpl.toGwt(ref, GwtCloudPubSubEntry.Type.PUBLISHER)).filter(Objects::nonNull).forEach(result::add);
            return result;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new GwtKuraException("Unexpected error");
        }
    }

    private static Set<GwtCloudPubSubEntry> getSubscriberInstances() throws GwtKuraException {
        BundleContext context = FrameworkUtil.getBundle(GwtCloudConnectionServiceImpl.class).getBundleContext();
        HashSet<GwtCloudPubSubEntry> result = new HashSet<GwtCloudPubSubEntry>();
        try {
            context.getServiceReferences(CloudSubscriber.class, null).stream().map(ref -> GwtCloudConnectionServiceImpl.toGwt(ref, GwtCloudPubSubEntry.Type.SUBSCRIBER)).filter(Objects::nonNull).forEach(result::add);
            return result;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new GwtKuraException("Unexpected error");
        }
    }

    private static void withAllCloudConnectionFactoryRefs(ServiceLocator.ServiceReferenceConsumer<Object> consumer) throws GwtKuraException {
        ServiceLocator.withAllServiceReferences(CLOUD_CONNECTION_FACTORY_FILTER, consumer, new Class[0]);
    }

    private static void withAllCloudConnectionFactories(ServiceLocator.ServiceConsumer<CloudConnectionFactory> consumer) throws GwtKuraException {
        ServiceLocator.withAllServices(CLOUD_CONNECTION_FACTORY_FILTER, o -> consumer.consume(GwtCloudConnectionServiceImpl.wrap(o)), new Class[0]);
    }

    public static CloudConnectionFactory wrap(Object o) {
        if (o instanceof CloudConnectionFactory) {
            return (CloudConnectionFactory)o;
        }
        if (o instanceof CloudServiceFactory) {
            final CloudServiceFactory f = (CloudServiceFactory)o;
            return new CloudConnectionFactory(){

                public List<String> getStackComponentsPids(String pid) throws KuraException {
                    return f.getStackComponentsPids(pid);
                }

                public Set<String> getManagedCloudConnectionPids() throws KuraException {
                    return f.getManagedCloudServicePids();
                }

                public String getFactoryPid() {
                    return f.getFactoryPid();
                }

                public void deleteConfiguration(String pid) throws KuraException {
                    f.deleteConfiguration(pid);
                }

                public void createConfiguration(String pid) throws KuraException {
                    f.createConfiguration(pid);
                }
            };
        }
        return null;
    }
}

