/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.io.InputStream;

public class LazyInputStream
extends InputStream {
    private InputStreamProvider provider;
    private InputStream original = null;

    public LazyInputStream(InputStreamProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
    }

    private void initOriginal() throws IOException {
        if (this.original == null) {
            this.original = this.provider.getInputStream();
        }
    }

    @Override
    public int available() throws IOException {
        this.initOriginal();
        return this.original.available();
    }

    @Override
    public void close() throws IOException {
        this.initOriginal();
        this.original.close();
    }

    public boolean equals(Object obj) {
        try {
            this.initOriginal();
            return this.original.equals(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            this.initOriginal();
            return this.original.hashCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.initOriginal();
            this.original.mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            this.initOriginal();
            return this.original.markSupported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        this.initOriginal();
        return this.original.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.initOriginal();
        return this.original.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.initOriginal();
        return this.original.read(b);
    }

    @Override
    public void reset() throws IOException {
        this.initOriginal();
        this.original.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.initOriginal();
        return this.original.skip(n);
    }

    public String toString() {
        try {
            this.initOriginal();
            return this.original.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

