/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.runner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.model.RoutesDefinition;
import org.apache.commons.io.input.ReaderInputStream;
import org.eclipse.kura.camel.runner.AbstractRoutesProvider;

public class XmlRoutesProvider
extends AbstractRoutesProvider {
    private final Supplier<InputStream> inputStreamProvider;

    public XmlRoutesProvider(String xml) {
        Objects.requireNonNull(xml);
        this.inputStreamProvider = () -> new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
    }

    private XmlRoutesProvider(Supplier<InputStream> inputStreamProvider) {
        Objects.requireNonNull(inputStreamProvider);
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    protected RoutesDefinition getRoutes(CamelContext camelContext) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = this.inputStreamProvider.get();){
            return camelContext.loadRoutesDefinition(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static XmlRoutesProvider fromString(String xml) {
        return new XmlRoutesProvider(xml);
    }

    public static XmlRoutesProvider fromReader(Supplier<Reader> reader) {
        Objects.requireNonNull(reader);
        return new XmlRoutesProvider(() -> new ReaderInputStream((Reader)reader.get(), StandardCharsets.UTF_8));
    }

    public static XmlRoutesProvider fromInputStream(Supplier<InputStream> inputStream) {
        return new XmlRoutesProvider(inputStream);
    }
}

