/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.eclipse.kura.util.jdbc.SQLBiFunction;
import org.eclipse.kura.util.jdbc.SQLSupplier;

public class JdbcUtil {
    private JdbcUtil() {
    }

    public static <T> Optional<T> getFirstColumnValueOrEmpty(SQLSupplier<ResultSet> resultSet, SQLBiFunction<ResultSet, Integer, T> extractor) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSet rs = resultSet.get();){
            if (rs.next()) {
                return Optional.of(extractor.call(rs, 1));
            }
            return Optional.empty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T getFirstColumnValue(SQLSupplier<ResultSet> resultSet, SQLBiFunction<ResultSet, Integer, T> extractor) throws SQLException {
        return JdbcUtil.getFirstColumnValueOrEmpty(resultSet, extractor).orElseThrow(() -> new SQLException("empty result set"));
    }
}

