/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import com.github.hypfvieh.bluetooth.wrapper.BluetoothDevice;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.kura.KuraBluetoothConnectionException;
import org.eclipse.kura.KuraBluetoothPairException;
import org.eclipse.kura.KuraBluetoothRemoveException;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.internal.ble.BluetoothLeAdapterImpl;
import org.eclipse.kura.internal.ble.BluetoothLeGattServiceImpl;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.UInt16;

public class BluetoothLeDeviceImpl
implements BluetoothLeDevice {
    private final BluetoothDevice device;

    public BluetoothLeDeviceImpl(BluetoothDevice device) {
        this.device = device;
    }

    public BluetoothLeGattService findService(UUID uuid) throws KuraBluetoothResourceNotFoundException {
        BluetoothGattService service = this.device.getGattServiceByUuid(uuid.toString());
        if (service != null) {
            return new BluetoothLeGattServiceImpl(service);
        }
        throw new KuraBluetoothResourceNotFoundException((Object)"Gatt service not found.");
    }

    public BluetoothLeGattService findService(UUID uuid, long timeout) throws KuraBluetoothResourceNotFoundException {
        return this.findService(uuid);
    }

    public List<BluetoothLeGattService> findServices() throws KuraBluetoothResourceNotFoundException {
        List serviceList = this.device.getGattServices();
        ArrayList<BluetoothLeGattService> services = new ArrayList<BluetoothLeGattService>();
        if (serviceList != null) {
            for (BluetoothGattService service : serviceList) {
                services.add(new BluetoothLeGattServiceImpl(service));
            }
        } else {
            throw new KuraBluetoothResourceNotFoundException((Object)"Gatt services not found.");
        }
        return services;
    }

    public void disconnect() throws KuraBluetoothConnectionException {
        if (!this.device.disconnect()) {
            throw new KuraBluetoothConnectionException((Object)"Disconnection from device failed");
        }
    }

    public void connect() throws KuraBluetoothConnectionException {
        if (!this.device.connect()) {
            throw new KuraBluetoothConnectionException((Object)"Connection to device failed");
        }
    }

    public void connectProfile(UUID uuid) throws KuraBluetoothConnectionException {
        if (!this.device.connectProfile(uuid.toString())) {
            throw new KuraBluetoothConnectionException((Object)"Connection to profile failed");
        }
    }

    public void disconnectProfile(UUID uuid) throws KuraBluetoothConnectionException {
        if (!this.device.disconnectProfile(uuid.toString())) {
            throw new KuraBluetoothConnectionException((Object)"Disconnection from profile failed");
        }
    }

    public void pair() throws KuraBluetoothPairException {
        if (!this.device.pair()) {
            throw new KuraBluetoothPairException((Object)"Pairing failed");
        }
    }

    public void cancelPairing() throws KuraBluetoothPairException {
        if (!this.device.cancelPairing()) {
            throw new KuraBluetoothPairException((Object)"Cancel pairing failed");
        }
    }

    public String getAddress() {
        return this.device.getAddress();
    }

    public String getName() {
        return this.device.getName();
    }

    public String getAlias() {
        return this.device.getAlias();
    }

    public void setAlias(String value) {
        this.device.setAlias(value);
    }

    public int getBluetoothClass() {
        Integer btClass = this.device.getBluetoothClass();
        return btClass == null ? -1 : btClass;
    }

    public short getAppearance() {
        Integer appearance = this.device.getAppearance();
        return appearance == null ? (short)-1 : (short)appearance.shortValue();
    }

    public String getIcon() {
        return this.device.getIcon();
    }

    public boolean isPaired() {
        Boolean paired = this.device.isPaired();
        if (paired != null) {
            return paired;
        }
        return false;
    }

    public boolean isTrusted() {
        Boolean trusted = this.device.isTrusted();
        if (trusted != null) {
            return trusted;
        }
        return false;
    }

    public void setTrusted(boolean value) {
        this.device.setTrusted(value);
    }

    public boolean isBlocked() {
        Boolean blocked = this.device.isBlocked();
        if (blocked != null) {
            return blocked;
        }
        return false;
    }

    public void setBlocked(boolean value) {
        this.device.setBlocked(Boolean.valueOf(value));
    }

    public boolean isLegacyPairing() {
        Boolean legacyPairing = this.device.isLegacyPairing();
        if (legacyPairing != null) {
            return legacyPairing;
        }
        return false;
    }

    public short getRSSI() {
        Short rssi = this.device.getRssi();
        return rssi == null ? (short)0 : rssi;
    }

    public boolean isConnected() {
        Boolean connected = this.device.isConnected();
        if (connected != null) {
            return connected;
        }
        return false;
    }

    public UUID[] getUUIDs() {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        String[] strUuids = this.device.getUuids();
        if (strUuids != null) {
            String[] stringArray = strUuids;
            int n = strUuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                uuidList.add(UUID.fromString(uuid));
                ++n2;
            }
        }
        UUID[] uuids = new UUID[uuidList.size()];
        return uuidList.toArray(uuids);
    }

    public String getModalias() {
        return this.device.getModAlias();
    }

    public BluetoothLeAdapter getAdapter() {
        return new BluetoothLeAdapterImpl(this.device.getAdapter());
    }

    public Map<Short, byte[]> getManufacturerData() {
        HashMap<Short, byte[]> manufacturerData = new HashMap<Short, byte[]>();
        Map originalData = this.device.getManufacturerData();
        if (originalData != null) {
            for (Map.Entry entry : originalData.entrySet()) {
                manufacturerData.put(((UInt16)entry.getKey()).shortValue(), (byte[])entry.getValue());
            }
        }
        return manufacturerData;
    }

    public Map<UUID, byte[]> getServiceData() {
        HashMap<UUID, byte[]> serviceData = new HashMap<UUID, byte[]>();
        Map originalData = this.device.getServiceData();
        if (originalData != null) {
            for (Map.Entry entry : originalData.entrySet()) {
                serviceData.put(UUID.fromString((String)entry.getKey()), (byte[])entry.getValue());
            }
        }
        return serviceData;
    }

    public short getTxPower() {
        Short txPower = this.device.getTxPower();
        return txPower == null ? (short)0 : this.device.getTxPower();
    }

    public boolean isServicesResolved() {
        Boolean servicesResolved = this.device.isServicesResolved();
        if (servicesResolved != null) {
            return servicesResolved;
        }
        return false;
    }

    public boolean remove() throws KuraBluetoothRemoveException {
        this.removeDevice();
        return true;
    }

    public void removeDevice() throws KuraBluetoothRemoveException {
        try {
            this.device.getAdapter().removeDevice(this.device.getRawDevice());
        }
        catch (DBusException e) {
            throw new KuraBluetoothRemoveException((Throwable)e, (Object)"Failed to remove the device");
        }
    }
}

