/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.net2.configuration;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.net.status.NetworkInterfaceType;
import org.eclipse.kura.web.server.net2.configuration.GwtNetInterfaceConfigBuilder;
import org.eclipse.kura.web.server.net2.configuration.NetworkConfigurationServicePropertiesBuilder;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfigurationServiceAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfigurationServiceAdapter.class);
    private static final String NETWORK_CONFIGURATION_SERVICE_PID = "org.eclipse.kura.net.admin.NetworkConfigurationService";
    private static final String NET_INTERFACES = "net.interfaces";
    private final ConfigurationService configurationService = ServiceLocator.getInstance().getService(ConfigurationService.class);
    private final Map<String, Object> netConfServProperties;

    public NetworkConfigurationServiceAdapter() throws GwtKuraException, KuraException {
        ComponentConfiguration config = this.configurationService.getComponentConfiguration(NETWORK_CONFIGURATION_SERVICE_PID);
        this.netConfServProperties = config.getConfigurationProperties();
    }

    public GwtNetInterfaceConfig getGwtNetInterfaceConfig(String ifName) {
        return new GwtNetInterfaceConfigBuilder(this.netConfServProperties).forInterface(ifName).build();
    }

    public GwtNetInterfaceConfig getDefaultGwtNetInterfaceConfig(String ifName, NetworkInterfaceType ifType) {
        return new GwtNetInterfaceConfigBuilder().forInterface(ifName).forType(ifType).build();
    }

    public void updateConfiguration(GwtNetInterfaceConfig gwtConfig) throws KuraException, GwtKuraException {
        NetworkConfigurationServicePropertiesBuilder builder = new NetworkConfigurationServicePropertiesBuilder(gwtConfig);
        Map<String, Object> newProperties = builder.build();
        newProperties.put(NET_INTERFACES, this.addNetworkInterfaceIfNotPresent(gwtConfig.getName()));
        logger.debug("Updating Network Configuration Service with properties:\n{}\n", newProperties);
        this.configurationService.updateConfiguration(NETWORK_CONFIGURATION_SERVICE_PID, newProperties);
    }

    private String addNetworkInterfaceIfNotPresent(String ifname) {
        List<String> ifnames = this.getConfiguredNetworkInterfaceNames();
        if (!ifnames.contains(ifname)) {
            ifnames.add(ifname);
        }
        StringBuilder result = new StringBuilder();
        for (String name : ifnames) {
            result.append(name);
            result.append(",");
        }
        return String.join((CharSequence)",", ifnames.stream().collect(Collectors.toList()));
    }

    public List<String> getConfiguredNetworkInterfaceNames() {
        String[] interfaces;
        LinkedList<String> ifnames = new LinkedList<String>();
        String netInterfaces = (String)this.netConfServProperties.get(NET_INTERFACES);
        String[] stringArray = interfaces = netInterfaces.split(",");
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ifnames.add(name.trim());
            ++n2;
        }
        return ifnames;
    }
}

