/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.backend;

import de.taimos.gpsd4java.types.TPVObject;

public final class GISTool {
    private static final int EARTH_RADIUS_KILOMETERS = 6371;

    private GISTool() {
    }

    public static double getDistance(TPVObject tpv1, TPVObject tpv2) {
        return GISTool.getDistance(tpv1.getLongitude(), tpv2.getLongitude(), tpv1.getLatitude(), tpv2.getLatitude());
    }

    public static double getDistance(double x1, double x2, double y1, double y2) {
        double deg2rad = Math.PI / 180;
        double x1rad = x1 * (Math.PI / 180);
        double x2rad = x2 * (Math.PI / 180);
        double y1rad = y1 * (Math.PI / 180);
        double y2rad = y2 * (Math.PI / 180);
        double dlong = x1rad - x2rad;
        double dlat = y1rad - y2rad;
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(y1rad) * Math.cos(y2rad) * Math.pow(Math.sin(dlong / 2.0), 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 6371.0 * c;
    }
}

