/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.asset.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.kura.asset.provider.BaseAsset;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.listener.ChannelListener;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.driver.PreparedRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverState {
    private static final Logger logger = LoggerFactory.getLogger(DriverState.class);
    private final Driver driver;
    private final Set<BaseAsset.ChannelListenerHolder> attachedListeners;
    private PreparedRead preparedRead;

    public DriverState(Driver driver) {
        this.driver = driver;
        this.attachedListeners = new HashSet<BaseAsset.ChannelListenerHolder>();
    }

    public Driver getDriver() {
        return this.driver;
    }

    public PreparedRead getPreparedRead() {
        return this.preparedRead;
    }

    public PreparedRead tryPrepareRead(List<ChannelRecord> records) {
        PreparedRead pRead;
        try {
            pRead = this.driver.prepareRead(records);
        }
        catch (Exception exception) {
            pRead = null;
        }
        if (pRead != null) {
            this.preparedRead = pRead;
        }
        return pRead;
    }

    private void closePreparedRead() {
        if (this.preparedRead != null) {
            try {
                this.preparedRead.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close prepared read", (Throwable)e);
            }
            this.preparedRead = null;
        }
    }

    public void syncChannelListeners(Set<BaseAsset.ChannelListenerHolder> targetState, Map<String, Channel> channels) {
        this.setChannelListenersInternal(new HashSet<BaseAsset.ChannelListenerHolder>(targetState), channels);
    }

    private void setChannelListenersInternal(Set<BaseAsset.ChannelListenerHolder> targetState, Map<String, Channel> channels) {
        Iterator<BaseAsset.ChannelListenerHolder> iter = this.attachedListeners.iterator();
        while (iter.hasNext()) {
            BaseAsset.ChannelListenerHolder reg = iter.next();
            if (targetState.contains(reg)) continue;
            this.detach(iter, reg);
        }
        for (BaseAsset.ChannelListenerHolder holder : targetState) {
            Channel channel;
            if (this.attachedListeners.contains(holder) || (channel = channels.get(holder.getChannelName())) == null || !channel.isEnabled()) continue;
            this.attach(holder, channel);
        }
    }

    private void attach(BaseAsset.ChannelListenerHolder holder, Channel channel) {
        try {
            logger.debug("Registering Channel Listener for monitoring...");
            this.driver.registerChannelListener(channel.getConfiguration(), (ChannelListener)holder);
            this.attachedListeners.add(holder);
            logger.debug("Registering Channel Listener for monitoring...done");
        }
        catch (Exception e) {
            logger.warn("Failed to register channel listener", (Throwable)e);
        }
    }

    private void detach(Iterator<BaseAsset.ChannelListenerHolder> iter, BaseAsset.ChannelListenerHolder holder) {
        try {
            logger.debug("Unregistering Asset Listener...");
            this.driver.unregisterChannelListener((ChannelListener)holder);
            iter.remove();
            logger.debug("Unregistering Asset Listener...done");
        }
        catch (Exception e) {
            logger.warn("Failed to unregister channel listener", (Throwable)e);
        }
    }

    public synchronized void shutdown() {
        this.closePreparedRead();
        this.setChannelListenersInternal(Collections.emptySet(), Collections.emptyMap());
    }
}

