/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.MeanPayoffGame;

public class ZwickPatersonInt {
    private ZwickPatersonInt() {
    }

    protected static <V, E> Map<V, Fraction> solve(MeanPayoffGame<V, E, Integer> game) {
        Map<V, Integer> valueMap = ZwickPatersonInt.computePathValues(game);
        HashMap mwMap = new HashMap();
        Integer n = game.getVertices().size();
        Integer k = 4 * n * n * n * (Integer)game.getMaxAbsValue();
        Integer denominator = 2 * n * (n - 1);
        for (Object v : game.getVertices()) {
            double estimate = (float)valueMap.get(v).intValue() * 1.0f / ((float)k.intValue() * 1.0f);
            double distance = 1.0f / ((float)denominator.intValue() * 1.0f);
            double leftBound = estimate - distance;
            double rightBound = estimate + distance;
            Fraction fraction = ZwickPatersonInt.findUniqueRational(leftBound, rightBound, (Integer)game.getMaxAbsValue(), n);
            mwMap.put(v, fraction);
        }
        return mwMap;
    }

    private static Fraction findUniqueRational(Double leftBound, Double rightBound, Integer maxW, Integer nn) {
        int w = -nn.intValue() * maxW;
        while (w <= nn * maxW) {
            int n = 1;
            while (n <= nn) {
                double fraction = (float)w * 1.0f / ((float)n * 1.0f);
                if (leftBound <= fraction && fraction <= rightBound) {
                    return new Fraction(w, n);
                }
                ++n;
            }
            ++w;
        }
        assert (false);
        return null;
    }

    protected static <V, E> Map<V, Fraction> computeEstimate(MeanPayoffGame<V, E, Integer> game) {
        Map<V, Integer> valueMap = ZwickPatersonInt.computePathValues(game);
        HashMap<V, Fraction> estimateMap = new HashMap<V, Fraction>();
        Integer n = game.getVertices().size();
        Integer k = 4 * n * n * n * (Integer)game.getMaxAbsValue();
        for (V v : valueMap.keySet()) {
            if (k != 0) {
                estimateMap.put(v, new Fraction(valueMap.get(v).intValue(), k.intValue()));
                continue;
            }
            estimateMap.put(v, Fraction.ZERO);
        }
        return estimateMap;
    }

    private static <V, E> Map<V, Integer> computePathValues(MeanPayoffGame<V, E, Integer> game) {
        HashMap valueMap = new HashMap();
        for (Object v : game.getVertices()) {
            valueMap.put(v, 0);
        }
        Integer n = game.getVertices().size();
        Integer k = 4 * n * n * n * (Integer)game.getMaxAbsValue();
        int i = 1;
        while (i <= k) {
            HashMap oldVector = valueMap;
            HashMap newVector = new HashMap();
            for (Object v : game.getVertices()) {
                Integer newValue;
                if (game.getV0().contains(v)) {
                    Integer maxValue = Integer.MIN_VALUE;
                    for (Object e : game.outgoingEdgesOf(v)) {
                        u = game.getEdgeTarget(e);
                        maxValue = Math.max(maxValue, (Integer)oldVector.get(u) + (Integer)game.getWeight(e));
                    }
                    newValue = maxValue;
                } else {
                    Integer minValue = Integer.MAX_VALUE;
                    for (Object e : game.outgoingEdgesOf(v)) {
                        u = game.getEdgeTarget(e);
                        minValue = Math.min(minValue, (Integer)oldVector.get(u) + (Integer)game.getWeight(e));
                    }
                    newValue = minValue;
                }
                newVector.put(v, newValue);
            }
            valueMap = newVector;
            ++i;
        }
        return valueMap;
    }
}

