/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.mdd;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.mdd.MddCifVarInfoBuilder;
import org.eclipse.escet.cif.controllercheck.mdd.MddSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class MddDeterminismCheck
extends CifCheckNoCompDefInst {
    private final Termination termination;
    private MddSpecBuilder builder;

    MddDeterminismCheck(Termination termination) {
        this.termination = termination;
    }

    protected void preprocessSpecification(Specification spec, CifCheckViolations violations) {
        List variables = Lists.list();
        CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)spec, (Collection)variables);
        boolean READINDEX = false;
        boolean WRITEINDEX = true;
        MddCifVarInfoBuilder cifVarInfoBuilder = new MddCifVarInfoBuilder(1);
        cifVarInfoBuilder.addVariablesGroupOnVariable(variables);
        this.builder = new MddSpecBuilder(cifVarInfoBuilder, 0, 1);
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        Map edgesPredsByEvent = Maps.map();
        for (Edge edge : loc.getEdges()) {
            for (EdgeEvent ee : edge.getEvents()) {
                if (this.termination.isRequested()) {
                    return;
                }
                Expression eventExpr = ee.getEvent();
                Assert.check((boolean)(eventExpr instanceof EventExpression));
                Event event = ((EventExpression)eventExpr).getEvent();
                if (!event.getControllable().booleanValue()) continue;
                List edgesPreds = edgesPredsByEvent.computeIfAbsent(event, e -> Lists.list());
                edgesPreds.add(edge.getGuards());
            }
        }
        block2: for (Map.Entry entry : edgesPredsByEvent.entrySet()) {
            if (this.termination.isRequested()) {
                return;
            }
            List edgesGuards = (List)entry.getValue();
            if (edgesGuards.size() == 1) continue;
            List edgesGuardsNodes = Lists.listc((int)edgesGuards.size());
            for (List edgeGuards : edgesGuards) {
                Node edgeGuardsNode = this.builder.getExpressionConvertor().convert(edgeGuards).get(1);
                edgesGuardsNodes.add(edgeGuardsNode);
                if (!this.termination.isRequested()) continue;
                return;
            }
            Event event = (Event)entry.getKey();
            int i = 0;
            while (i < edgesGuardsNodes.size() - 1) {
                int j = i + 1;
                while (j < edgesGuardsNodes.size()) {
                    Node overlap = this.builder.tree.conjunct((Node)edgesGuardsNodes.get(i), (Node)edgesGuardsNodes.get(j));
                    if (this.termination.isRequested()) {
                        return;
                    }
                    if (overlap != Tree.ZERO) {
                        violations.add((PositionObject)loc, "Non-deterministic edges with overlapping guards within a location, for controllable event \"%s\"", new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                        continue block2;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

