/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.text.MessageFormat;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeRefreshContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.ui.provider.Messages;

public abstract class AbstractDTreeItemRunnableWithProgress
implements IRunnableWithProgress {
    private final Session session;
    private final boolean all;
    private TransactionalEditingDomain domain;
    private GlobalContext globalContext;
    private CommandStack commandStack;

    public AbstractDTreeItemRunnableWithProgress(Session session, DTreeItem dTreeItem) {
        if (dTreeItem == null) {
            throw new IllegalArgumentException(Messages.AbstractDTreeItemRunnableWithProgress_nullDTreeItemParameter);
        }
        this.session = session;
        this.all = false;
    }

    public AbstractDTreeItemRunnableWithProgress(Session session, boolean all, int size) {
        if (size == 0) {
            throw new IllegalArgumentException(Messages.AbstractDTreeItemRunnableWithProgress_emptyDTreeItemsParameter);
        }
        this.session = session;
        this.all = all;
    }

    protected boolean isCollapseOrExpandAll() {
        return this.all;
    }

    protected Session getSession() {
        return this.session;
    }

    protected TransactionalEditingDomain getDomain() {
        if (this.domain == null) {
            this.domain = this.getSession().getTransactionalEditingDomain();
        }
        return this.domain;
    }

    protected GlobalContext getGlobalContext() {
        if (this.globalContext == null) {
            this.globalContext = new TreeRefreshContext(this.getSession().getModelAccessor(), this.getSession().getInterpreter(), this.getSession().getSemanticResources(), this.getSession().getTransactionalEditingDomain());
        }
        return this.globalContext;
    }

    protected CommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = this.domain.getCommandStack();
        }
        return this.commandStack;
    }

    public static String getCommandLabel(DTreeItem dTreeItem, String singleElementCommandName, String allElementsCommandName, boolean isCollapseOrExpandAll) {
        String commandLabel = isCollapseOrExpandAll ? MessageFormat.format(allElementsCommandName, dTreeItem.getName()) : MessageFormat.format(singleElementCommandName, dTreeItem.getName());
        return commandLabel;
    }
}

