/**
 */
package distributions.impl;

import distributions.DistributionsPackage;
import distributions.TriangularDistribution;

import distributions.math.ModeDistribution;

import expressions.Expression;

import expressions.impl.ExpressionImpl;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Triangular Distribution</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getDefault <em>Default</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getDefaultExp <em>Default Exp</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getModeDistributionInstance <em>Mode Distribution Instance</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getMode <em>Mode</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getMin <em>Min</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getMax <em>Max</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getModeExp <em>Mode Exp</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getMinExp <em>Min Exp</em>}</li>
 *   <li>{@link distributions.impl.TriangularDistributionImpl#getMaxExp <em>Max Exp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TriangularDistributionImpl extends ExpressionImpl implements TriangularDistribution
{
    /**
     * The default value of the '{@link #getDefault() <em>Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefault()
     * @generated
     * @ordered
     */
    protected static final BigDecimal DEFAULT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDefaultExp() <em>Default Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefaultExp()
     * @generated
     * @ordered
     */
    protected Expression defaultExp;

    /**
     * The default value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected static final ModeDistribution MODE_DISTRIBUTION_INSTANCE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected ModeDistribution modeDistributionInstance = MODE_DISTRIBUTION_INSTANCE_EDEFAULT;

    /**
     * The default value of the '{@link #getMode() <em>Mode</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMode()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MODE_EDEFAULT = null;

    /**
     * The default value of the '{@link #getMin() <em>Min</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMin()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MIN_EDEFAULT = null;

    /**
     * The default value of the '{@link #getMax() <em>Max</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMax()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MAX_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getModeExp() <em>Mode Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeExp()
     * @generated
     * @ordered
     */
    protected Expression modeExp;

    /**
     * The cached value of the '{@link #getMinExp() <em>Min Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMinExp()
     * @generated
     * @ordered
     */
    protected Expression minExp;

    /**
     * The cached value of the '{@link #getMaxExp() <em>Max Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMaxExp()
     * @generated
     * @ordered
     */
    protected Expression maxExp;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TriangularDistributionImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return DistributionsPackage.Literals.TRIANGULAR_DISTRIBUTION;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getDefault()
    {
        return defaultExp==null ? null:  defaultExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getDefaultExp()
    {
        return defaultExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetDefaultExp(Expression newDefaultExp, NotificationChain msgs)
    {
        Expression oldDefaultExp = defaultExp;
        defaultExp = newDefaultExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP, oldDefaultExp, newDefaultExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setDefaultExp(Expression newDefaultExp)
    {
        if (newDefaultExp != defaultExp)
        {
            NotificationChain msgs = null;
            if (defaultExp != null)
                msgs = ((InternalEObject)defaultExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            if (newDefaultExp != null)
                msgs = ((InternalEObject)newDefaultExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            msgs = basicSetDefaultExp(newDefaultExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP, newDefaultExp, newDefaultExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistributionInstance()
    {
        return modeDistributionInstance;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setModeDistributionInstance(ModeDistribution newModeDistributionInstance)
    {
        ModeDistribution oldModeDistributionInstance = modeDistributionInstance;
        modeDistributionInstance = newModeDistributionInstance;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE, oldModeDistributionInstance, modeDistributionInstance));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMode()
    {
        return modeExp==null ? null:  modeExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMin()
    {
        return minExp==null ? null:  minExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMax()
    {
        return maxExp==null ? null:  maxExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getModeExp()
    {
        return modeExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetModeExp(Expression newModeExp, NotificationChain msgs)
    {
        Expression oldModeExp = modeExp;
        modeExp = newModeExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP, oldModeExp, newModeExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setModeExp(Expression newModeExp)
    {
        if (newModeExp != modeExp)
        {
            NotificationChain msgs = null;
            if (modeExp != null)
                msgs = ((InternalEObject)modeExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP, null, msgs);
            if (newModeExp != null)
                msgs = ((InternalEObject)newModeExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP, null, msgs);
            msgs = basicSetModeExp(newModeExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP, newModeExp, newModeExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getMinExp()
    {
        return minExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetMinExp(Expression newMinExp, NotificationChain msgs)
    {
        Expression oldMinExp = minExp;
        minExp = newMinExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP, oldMinExp, newMinExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMinExp(Expression newMinExp)
    {
        if (newMinExp != minExp)
        {
            NotificationChain msgs = null;
            if (minExp != null)
                msgs = ((InternalEObject)minExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP, null, msgs);
            if (newMinExp != null)
                msgs = ((InternalEObject)newMinExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP, null, msgs);
            msgs = basicSetMinExp(newMinExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP, newMinExp, newMinExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getMaxExp()
    {
        return maxExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetMaxExp(Expression newMaxExp, NotificationChain msgs)
    {
        Expression oldMaxExp = maxExp;
        maxExp = newMaxExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP, oldMaxExp, newMaxExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMaxExp(Expression newMaxExp)
    {
        if (newMaxExp != maxExp)
        {
            NotificationChain msgs = null;
            if (maxExp != null)
                msgs = ((InternalEObject)maxExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP, null, msgs);
            if (newMaxExp != null)
                msgs = ((InternalEObject)newMaxExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP, null, msgs);
            msgs = basicSetMaxExp(newMaxExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP, newMaxExp, newMaxExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution createModeDistribution(final RandomGenerator generator)
    {
        return new distributions.math.TriangularModeDistribution(generator, 
            getMin().doubleValue(), 
            getMode().doubleValue(), 
            getMax().doubleValue(),
            null == getDefault() ? null : getDefault().doubleValue()
        );
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal evaluate()
    {
        var adapter =  distributions.DistributionsAdapter.getAdapter(this);
        var mode = adapter.getCalculationMode();
        if( mode == distributions.CalculationMode.DISTRIBUTED ){
            if( adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on Distributions");
            }
            return BigDecimal.valueOf(getModeDistribution().nextSample());
        }
        return BigDecimal.valueOf(getModeDistribution().getDefault());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistribution()
    {
        if( modeDistributionInstance == null){
            var adapter = distributions.DistributionsAdapter.getAdapter(this);
            if( adapter.getCalculationMode()==distributions.CalculationMode.DISTRIBUTED && adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on DistributionsAdapter");
            }
            setModeDistributionInstance( createModeDistribution(adapter.getRandomGenerator()) );
        }
        return modeDistributionInstance;
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP:
                return basicSetDefaultExp(null, msgs);
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP:
                return basicSetModeExp(null, msgs);
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP:
                return basicSetMinExp(null, msgs);
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP:
                return basicSetMaxExp(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT:
                return getDefault();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP:
                return getDefaultExp();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return getModeDistributionInstance();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE:
                return getMode();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN:
                return getMin();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX:
                return getMax();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP:
                return getModeExp();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP:
                return getMinExp();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP:
                return getMaxExp();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)newValue);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance((ModeDistribution)newValue);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP:
                setModeExp((Expression)newValue);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP:
                setMinExp((Expression)newValue);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP:
                setMaxExp((Expression)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)null);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance(MODE_DISTRIBUTION_INSTANCE_EDEFAULT);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP:
                setModeExp((Expression)null);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP:
                setMinExp((Expression)null);
                return;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP:
                setMaxExp((Expression)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT:
                return DEFAULT_EDEFAULT == null ? getDefault() != null : !DEFAULT_EDEFAULT.equals(getDefault());
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__DEFAULT_EXP:
                return defaultExp != null;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return MODE_DISTRIBUTION_INSTANCE_EDEFAULT == null ? modeDistributionInstance != null : !MODE_DISTRIBUTION_INSTANCE_EDEFAULT.equals(modeDistributionInstance);
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE:
                return MODE_EDEFAULT == null ? getMode() != null : !MODE_EDEFAULT.equals(getMode());
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN:
                return MIN_EDEFAULT == null ? getMin() != null : !MIN_EDEFAULT.equals(getMin());
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX:
                return MAX_EDEFAULT == null ? getMax() != null : !MAX_EDEFAULT.equals(getMax());
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MODE_EXP:
                return modeExp != null;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MIN_EXP:
                return minExp != null;
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION__MAX_EXP:
                return maxExp != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR:
                return createModeDistribution((RandomGenerator)arguments.get(0));
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION___EVALUATE:
                return evaluate();
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION___GET_MODE_DISTRIBUTION:
                return getModeDistribution();
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (modeDistributionInstance: ");
        result.append(modeDistributionInstance);
        result.append(')');
        return result.toString();
    }

} //TriangularDistributionImpl
