/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.engine.python.ui.handlers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class ExecutionEngineGeneratorDialog extends Dialog {
    private boolean simulate = false;

    private boolean removeClaimAndReleases = true;

    ExecutionEngineGeneratorDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Generate Python Execution Engine");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 15;
        gl_container.marginBottom = 5;
        gl_container.marginTop = 5;
        gl_container.marginRight = 5;
        gl_container.marginLeft = 5;
        container.setLayout(gl_container);

        Button checkBox1 = new Button(container, SWT.CHECK);
        checkBox1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        checkBox1.setText("Remove claims and releases");
        checkBox1.setSelection(removeClaimAndReleases);
        checkBox1.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent event) {
                removeClaimAndReleases = checkBox1.getSelection();
            }
        });

        Button checkBox2 = new Button(container, SWT.CHECK);
        checkBox2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        checkBox2.setText("Simulate execution");
        checkBox2.setSelection(simulate);
        checkBox2.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent event) {
                simulate = checkBox2.getSelection();
            }
        });

        return container;
    }

    /**
     * @return The simulate.
     */
    public boolean isSimulate() {
        return simulate;
    }

    /**
     * @return The removeClaimAndReleases.
     */
    public boolean isRemoveClaimAndReleases() {
        return removeClaimAndReleases;
    }
}
