/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.sirius_xtext.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.MenuHelper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OpenSiriusMenu
extends CompoundContributionItem {
    private final AdapterFactory adapter_factory = DialectUIManager.INSTANCE.createAdapterFactory();

    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> menuContent = new ArrayList<ActionContributionItem>();
        EObject context = this.getContext();
        URI contextUri = context.eResource().getURI();
        URI representationsUri = contextUri.trimSegments(contextUri.segmentCount() - 2).appendSegment("representations.aird");
        Session siriusSession = SessionManager.INSTANCE.getSession(representationsUri, (IProgressMonitor)new NullProgressMonitor());
        if (siriusSession != null) {
            URI semanticUri = contextUri.appendFragment(context.eResource().getURIFragment(context));
            EObject semantic = siriusSession.getTransactionalEditingDomain().getResourceSet().getEObject(semanticUri, true);
            Collection representations = DialectManager.INSTANCE.getRepresentationDescriptors(semantic, siriusSession);
            for (DRepresentationDescriptor representation : representations) {
                menuContent.add(new ActionContributionItem(MenuHelper.buildOpenRepresentationAction((Session)siriusSession, (DRepresentationDescriptor)representation, (AdapterFactory)this.adapter_factory)));
            }
        }
        return menuContent.toArray(new IContributionItem[menuContent.size()]);
    }

    private EObject getContext() {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor();
        ISelection selection = xtextEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            final int offset = ((ITextSelection)selection).getOffset();
            return (EObject)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource state) throws Exception {
                    return new EObjectAtOffsetHelper().resolveElementAt(state, offset);
                }
            });
        }
        return null;
    }
}

