/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.format;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4e.format.DefaultFormatRegionsProvider;
import org.eclipse.lsp4e.format.IFormatRegionsProvider;
import org.eclipse.lsp4e.internal.FormatRegionsProviderUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class FormatRegionsProviderUtilTest {
    @Test
    public void lookupOnlyDefault() throws Exception {
        IFormatRegionsProvider provider = FormatRegionsProviderUtil.lookup((String)"noFormatProviderForThisId");
        Assertions.assertTrue((boolean)(provider instanceof DefaultFormatRegionsProvider));
    }

    @Test
    public void lookup() throws Exception {
        IFormatRegionsProvider instance = new IFormatRegionsProvider(){

            public IRegion @Nullable [] getFormattingRegions(IDocument document) {
                return null;
            }
        };
        BundleContext bundleContext = FrameworkUtil.getBundle(FormatRegionsProviderUtil.class).getBundleContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("serverDefinitionId", "foo");
        ServiceRegistration serviceRegistration = bundleContext.registerService(IFormatRegionsProvider.class, (Object)instance, props);
        IFormatRegionsProvider provider = FormatRegionsProviderUtil.lookup((String)"notMatching");
        Assertions.assertTrue((boolean)(provider instanceof DefaultFormatRegionsProvider));
        provider = FormatRegionsProviderUtil.lookup((String)"foo");
        Assertions.assertTrue((provider == instance ? 1 : 0) != 0);
        serviceRegistration.unregister();
    }
}

