/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal.files;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.files.PathPatternMatcher;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.RelativePattern;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class FileSystemWatcherManager {
    private static final int WATCH_KIND_ANY = 7;
    private final Map<String, List<FileSystemWatcher>> registry = new HashMap<String, List<FileSystemWatcher>>();
    private final @Nullable Path basePath;
    private volatile @Nullable Set<FileSystemWatcher> fileSystemWatchers;
    private volatile @Nullable Map<Integer, List<PathPatternMatcher>> pathPatternMatchers;

    public FileSystemWatcherManager(@Nullable IProject project) {
        Path watchedFilesBasePath = null;
        try {
            URI loc;
            if (project != null && (loc = project.getLocationURI()) != null) {
                watchedFilesBasePath = Paths.get(loc);
            }
        }
        catch (IllegalArgumentException ex) {
            LanguageServerPlugin.logError(ex);
        }
        this.basePath = watchedFilesBasePath;
    }

    public FileSystemWatcherManager(@Nullable Path basePath) {
        this.basePath = basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFileSystemWatchers(String id, @Nullable List<FileSystemWatcher> watchers) {
        if (watchers == null) {
            return;
        }
        Map<String, List<FileSystemWatcher>> map = this.registry;
        synchronized (map) {
            this.registry.put(id, new ArrayList<FileSystemWatcher>(watchers));
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFileSystemWatchers(String id) {
        Map<String, List<FileSystemWatcher>> map = this.registry;
        synchronized (map) {
            this.registry.remove(id);
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, List<FileSystemWatcher>> map = this.registry;
        synchronized (map) {
            this.registry.clear();
            this.reset();
        }
    }

    private void reset() {
        this.fileSystemWatchers = this.registry.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
        this.pathPatternMatchers = null;
    }

    public @Nullable Set<FileSystemWatcher> getFileSystemWatchers() {
        Set<FileSystemWatcher> watchers = this.fileSystemWatchers;
        return watchers == null ? null : Set.copyOf(watchers);
    }

    public boolean hasFilePatterns() {
        return this.fileSystemWatchers != null && !this.fileSystemWatchers.isEmpty();
    }

    public boolean hasFilePatternsFor(int kind) {
        if (!this.hasFilePatterns()) {
            return false;
        }
        this.computePatternMatchersIfNeeded();
        Map<Integer, List<PathPatternMatcher>> pathPatternMatchers = this.pathPatternMatchers;
        if (pathPatternMatchers == null) {
            return false;
        }
        List<PathPatternMatcher> matchersForKind = pathPatternMatchers.get(kind);
        return matchersForKind != null && !matchersForKind.isEmpty();
    }

    public boolean isMatchFilePattern(@Nullable URI uri, int kind) {
        if (uri == null || !this.hasFilePatterns()) {
            return false;
        }
        this.computePatternMatchersIfNeeded();
        HashMap<Path, Either<Path, Boolean>> basePathToRelativePath = new HashMap<Path, Either<Path, Boolean>>();
        try {
            Path path = Paths.get(uri);
            return this.match(path, kind, basePathToRelativePath) || this.match(path, 7, basePathToRelativePath);
        }
        catch (Exception ex) {
            LanguageServerPlugin.logWarning(ex.getMessage(), ex);
            return false;
        }
    }

    private void computePatternMatchersIfNeeded() {
        if (this.pathPatternMatchers == null) {
            this.computePatternMatchers();
        }
    }

    private synchronized void computePatternMatchers() {
        if (this.pathPatternMatchers != null) {
            return;
        }
        Set<FileSystemWatcher> watchers = this.fileSystemWatchers;
        if (watchers == null) {
            this.pathPatternMatchers = Map.of();
            return;
        }
        HashMap<Integer, List<PathPatternMatcher>> matchers = new HashMap<Integer, List<PathPatternMatcher>>();
        for (FileSystemWatcher watcher : watchers) {
            PathPatternMatcher matcher = FileSystemWatcherManager.getPathPatternMatcher(watcher, this.basePath);
            if (matcher == null) continue;
            Integer kind = watcher.getKind();
            FileSystemWatcherManager.tryAddingMatcher(matcher, matchers, kind, 1);
            FileSystemWatcherManager.tryAddingMatcher(matcher, matchers, kind, 2);
            FileSystemWatcherManager.tryAddingMatcher(matcher, matchers, kind, 4);
        }
        this.pathPatternMatchers = matchers;
    }

    private boolean match(Path path, int kind, Map<Path, Either<Path, Boolean>> basePathToRelativePath) {
        Map<Integer, List<PathPatternMatcher>> pathPatternMatchers = this.pathPatternMatchers;
        if (pathPatternMatchers == null) {
            return false;
        }
        List<PathPatternMatcher> matchers = pathPatternMatchers.get(kind);
        if (matchers == null) {
            return false;
        }
        for (PathPatternMatcher matcher : matchers) {
            Path relativePath;
            Path matcherBasePath = matcher.getBasePath();
            if (matcherBasePath == null || (relativePath = FileSystemWatcherManager.matchBasePath(path, matcherBasePath, basePathToRelativePath)) == null || !matcher.matches(matcherBasePath.relativize(path))) continue;
            return true;
        }
        return false;
    }

    private static @Nullable Path matchBasePath(Path path, @Nullable Path basePath, Map<Path, Either<Path, Boolean>> basePathToRelativePath) {
        if (basePath == null) {
            return null;
        }
        Either<Path, Boolean> matches = basePathToRelativePath.get(basePath);
        if (matches != null) {
            return matches.isLeft() ? (Path)matches.getLeft() : null;
        }
        if (path.startsWith(basePath)) {
            Path relativePath = basePath.relativize(path);
            basePathToRelativePath.put(basePath, (Either<Path, Boolean>)Either.forLeft((Object)relativePath));
            return relativePath;
        }
        basePathToRelativePath.put(basePath, (Either<Path, Boolean>)Either.forRight((Object)Boolean.FALSE));
        return null;
    }

    private static @Nullable PathPatternMatcher getPathPatternMatcher(FileSystemWatcher fileSystemMatcher, @Nullable Path basePath) {
        Either globPattern = fileSystemMatcher.getGlobPattern();
        if (globPattern.isLeft()) {
            String pattern = (String)globPattern.getLeft();
            return pattern.isBlank() ? null : new PathPatternMatcher(pattern, basePath);
        }
        RelativePattern relativePattern = (RelativePattern)globPattern.getRight();
        String pattern = relativePattern.getPattern();
        if (pattern.isBlank()) {
            return null;
        }
        Path relativeBasePath = FileSystemWatcherManager.getRelativeBasePath((Either<WorkspaceFolder, String>)relativePattern.getBaseUri());
        if (relativeBasePath == null) {
            return null;
        }
        return new PathPatternMatcher(pattern, relativeBasePath);
    }

    private static @Nullable Path getRelativeBasePath(@Nullable Either<WorkspaceFolder, String> baseUri) {
        if (baseUri == null) {
            return null;
        }
        String baseDir = null;
        if (baseUri.isRight()) {
            baseDir = (String)baseUri.getRight();
        } else if (baseUri.isLeft()) {
            WorkspaceFolder workspaceFolder = (WorkspaceFolder)baseUri.getLeft();
            baseDir = workspaceFolder.getUri();
        }
        if (baseDir == null || baseDir.isBlank()) {
            return null;
        }
        try {
            return Paths.get(URI.create(baseDir));
        }
        catch (Exception ex) {
            LanguageServerPlugin.logWarning(ex.getMessage(), ex);
            return null;
        }
    }

    private static void tryAddingMatcher(PathPatternMatcher matcher, Map<Integer, List<PathPatternMatcher>> matchers, @Nullable Integer watcherKind, int kind) {
        if (!FileSystemWatcherManager.isWatchKind(watcherKind, kind)) {
            return;
        }
        List matchersForKind = matchers.computeIfAbsent(kind, k -> new ArrayList());
        matchersForKind.add(matcher);
    }

    private static boolean isWatchKind(@Nullable Integer watcherKind, int kind) {
        return watcherKind == null || (watcherKind & kind) != 0;
    }
}

