/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.rename;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.rename.LSPRenameParticipant;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LSPRenameParticipantTest
extends AbstractTestWithProject {
    LSPRenameParticipantTest() {
    }

    @BeforeEach
    void setupCaps() {
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            WorkspaceServerCapabilities ws = new WorkspaceServerCapabilities();
            FileOperationsServerCapabilities fileOps = new FileOperationsServerCapabilities();
            fileOps.setWillRename(new FileOperationOptions());
            ws.setFileOperations(fileOps);
            caps.setWorkspace(ws);
            return caps;
        });
    }

    @Test
    void computesNewUriFromNewName() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        String newName = "renamed-" + file.getName();
        URI oldUri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)oldUri);
        IContainer parent = file.getParent();
        IPath parentLoc = parent.getRawLocation();
        if (parentLoc == null) {
            parentLoc = parent.getLocation();
        }
        Assertions.assertNotNull((Object)parentLoc);
        URI expectedNewUri = LSPEclipseUtils.toUri((IPath)parentLoc.append(newName));
        TestableRenameParticipant participant = new TestableRenameParticipant();
        participant.setArgs(new RenameArguments(newName, false));
        Assertions.assertTrue((boolean)participant.initialize(file));
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillRename());
        Assertions.assertEquals((int)1, (int)ws.getLastWillRename().getFiles().size());
        Assertions.assertEquals((Object)oldUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getOldUri());
        Assertions.assertEquals((Object)expectedNewUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getNewUri());
    }

    @Test
    void computesNewUriForFolderFromNewName() throws Exception {
        IFile starter = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(starter);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        IFolder folder = this.project.getFolder("oldFolder");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        String newName = "newFolder";
        URI oldUri = LSPEclipseUtils.toUri((IResource)folder);
        Assertions.assertNotNull((Object)oldUri);
        IContainer parent = folder.getParent();
        IPath parentLoc = parent.getRawLocation();
        if (parentLoc == null) {
            parentLoc = parent.getLocation();
        }
        Assertions.assertNotNull((Object)parentLoc);
        URI expectedNewUri = LSPEclipseUtils.toUri((IPath)parentLoc.append(newName));
        TestableRenameParticipant participant = new TestableRenameParticipant();
        participant.setArgs(new RenameArguments(newName, false));
        Assertions.assertTrue((boolean)participant.initialize(folder));
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillRename());
        Assertions.assertEquals((int)1, (int)ws.getLastWillRename().getFiles().size());
        Assertions.assertEquals((Object)oldUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getOldUri());
        Assertions.assertEquals((Object)expectedNewUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getNewUri());
    }

    static class TestableRenameParticipant
    extends LSPRenameParticipant {
        private RenameArguments args;

        TestableRenameParticipant() {
        }

        void setArgs(RenameArguments args) {
            this.args = args;
        }

        public boolean initialize(Object element) {
            return super.initialize(element);
        }

        public RenameArguments getArguments() {
            return this.args;
        }
    }
}

