/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.beanvalidation;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class BeanValidationTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void validFieldConstraints() throws Exception {
        IJavaProject javaProject = BeanValidationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/beanvalidation/ValidConstraints.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, new Diagnostic[0]);
    }

    @Test
    public void fieldConstraintValidation() throws Exception {
        IJavaProject javaProject = BeanValidationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/beanvalidation/FieldConstraintValidation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(10, 16, 23, "The @AssertTrue annotation can only be used on boolean and Boolean type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBooleanMethodOrField", (Object)"jakarta.validation.constraints.AssertTrue");
        Diagnostic d2 = JakartaForJavaAssert.d(13, 19, 24, "The @AssertFalse annotation can only be used on boolean and Boolean type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBooleanMethodOrField", (Object)"jakarta.validation.constraints.AssertFalse");
        Diagnostic d3 = JakartaForJavaAssert.d(17, 19, 29, "The @DecimalMax annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField", (Object)"jakarta.validation.constraints.DecimalMax");
        Diagnostic d4 = JakartaForJavaAssert.d(17, 19, 29, "The @DecimalMin annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField", (Object)"jakarta.validation.constraints.DecimalMin");
        Diagnostic d5 = JakartaForJavaAssert.d(20, 20, 26, "The @Digits annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField", (Object)"jakarta.validation.constraints.Digits");
        Diagnostic d6 = JakartaForJavaAssert.d(23, 20, 32, "The @Email annotation can only be used on String and CharSequence type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonStringMethodOrField", (Object)"jakarta.validation.constraints.Email");
        Diagnostic d7 = JakartaForJavaAssert.d(26, 20, 34, "The @FutureOrPresent annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"jakarta.validation.constraints.FutureOrPresent");
        Diagnostic d8 = JakartaForJavaAssert.d(29, 19, 30, "The @Future annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"jakarta.validation.constraints.Future");
        Diagnostic d9 = JakartaForJavaAssert.d(33, 20, 23, "The @Min annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonMinMaxMethodOrField", (Object)"jakarta.validation.constraints.Min");
        Diagnostic d10 = JakartaForJavaAssert.d(33, 20, 23, "The @Max annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonMinMaxMethodOrField", (Object)"jakarta.validation.constraints.Max");
        Diagnostic d11 = JakartaForJavaAssert.d(36, 20, 27, "The @Negative annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"jakarta.validation.constraints.Negative");
        Diagnostic d12 = JakartaForJavaAssert.d(39, 19, 25, "The @NegativeOrZero annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"jakarta.validation.constraints.NegativeOrZero");
        Diagnostic d13 = JakartaForJavaAssert.d(42, 20, 32, "The @NotBlank annotation can only be used on String and CharSequence type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonStringMethodOrField", (Object)"jakarta.validation.constraints.NotBlank");
        Diagnostic d14 = JakartaForJavaAssert.d(45, 21, 31, "The @Pattern annotation can only be used on String and CharSequence type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonStringMethodOrField", (Object)"jakarta.validation.constraints.Pattern");
        Diagnostic d15 = JakartaForJavaAssert.d(48, 19, 33, "The @Past annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"jakarta.validation.constraints.Past");
        Diagnostic d16 = JakartaForJavaAssert.d(51, 19, 33, "The @PastOrPresent annotation can only be used on: Date, Calendar, Instant, LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, OffsetTime, Year, YearMonth, ZonedDateTime, HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and ThaiBuddhistDate type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonDateTimeMethodOrField", (Object)"jakarta.validation.constraints.PastOrPresent");
        Diagnostic d17 = JakartaForJavaAssert.d(54, 21, 25, "The @Positive annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"jakarta.validation.constraints.Positive");
        Diagnostic d18 = JakartaForJavaAssert.d(57, 25, 34, "The @PositiveOrZero annotation can only be used on \n- BigDecimal \n- BigInteger\n- byte, short, int, long, float, double (and their respective wrappers) \n type fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonPositiveMethodOrField", (Object)"jakarta.validation.constraints.PositiveOrZero");
        Diagnostic d19 = JakartaForJavaAssert.d(60, 27, 36, "Constraint annotations are not allowed on static fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"jakarta.validation.constraints.AssertTrue");
        Diagnostic d20 = JakartaForJavaAssert.d(63, 27, 36, "Constraint annotations are not allowed on static fields.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"jakarta.validation.constraints.Past");
        Diagnostic d21 = JakartaForJavaAssert.d(66, 20, 26, "This annotation can only be used on fields of type CharSequence, Collection, Array, or Map.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonSizeMethodOrField", (Object)"jakarta.validation.constraints.Size");
        Diagnostic d22 = JakartaForJavaAssert.d(69, 29, 45, "This annotation can only be used on fields of type CharSequence, Collection, Array, or Map.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonSizeMethodOrField", (Object)"jakarta.validation.constraints.NotEmpty");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, d22);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(9, 4, 10, 4, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d1, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
        JakartaJavaCodeActionParams codeActionParams5 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te6 = JakartaForJavaAssert.te(12, 4, 13, 4, "");
        CodeAction ca6 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertFalse from element", d2, te6);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams5, IJDT_UTILS, ca6);
        JakartaJavaCodeActionParams codeActionParams6 = JakartaForJavaAssert.createCodeActionParams(uri, d3);
        TextEdit te7 = JakartaForJavaAssert.te(15, 4, 16, 4, "");
        CodeAction ca7 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation DecimalMax from element", d3, te7);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams6, IJDT_UTILS, ca7);
        JakartaJavaCodeActionParams codeActionParams7 = JakartaForJavaAssert.createCodeActionParams(uri, d4);
        TextEdit te8 = JakartaForJavaAssert.te(16, 4, 17, 4, "");
        CodeAction ca8 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation DecimalMin from element", d4, te8);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams7, IJDT_UTILS, ca8);
        JakartaJavaCodeActionParams codeActionParams8 = JakartaForJavaAssert.createCodeActionParams(uri, d5);
        TextEdit te9 = JakartaForJavaAssert.te(19, 4, 20, 4, "");
        CodeAction ca9 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Digits from element", d5, te9);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams8, IJDT_UTILS, ca9);
        JakartaJavaCodeActionParams codeActionParams9 = JakartaForJavaAssert.createCodeActionParams(uri, d6);
        TextEdit te10 = JakartaForJavaAssert.te(22, 4, 23, 4, "");
        CodeAction ca10 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Email from element", d6, te10);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams9, IJDT_UTILS, ca10);
        JakartaJavaCodeActionParams codeActionParams10 = JakartaForJavaAssert.createCodeActionParams(uri, d7);
        TextEdit te11 = JakartaForJavaAssert.te(25, 4, 26, 4, "");
        CodeAction ca11 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation FutureOrPresent from element", d7, te11);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams10, IJDT_UTILS, ca11);
        JakartaJavaCodeActionParams codeActionParams11 = JakartaForJavaAssert.createCodeActionParams(uri, d8);
        TextEdit te12 = JakartaForJavaAssert.te(28, 4, 29, 4, "");
        CodeAction ca12 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Future from element", d8, te12);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams11, IJDT_UTILS, ca12);
        JakartaJavaCodeActionParams codeActionParams12 = JakartaForJavaAssert.createCodeActionParams(uri, d9);
        TextEdit te13 = JakartaForJavaAssert.te(31, 4, 32, 4, "");
        CodeAction ca13 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Min from element", d9, te13);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams12, IJDT_UTILS, ca13);
        JakartaJavaCodeActionParams codeActionParams13 = JakartaForJavaAssert.createCodeActionParams(uri, d10);
        TextEdit te14 = JakartaForJavaAssert.te(32, 4, 33, 4, "");
        CodeAction ca14 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Max from element", d10, te14);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams13, IJDT_UTILS, ca14);
        JakartaJavaCodeActionParams codeActionParams14 = JakartaForJavaAssert.createCodeActionParams(uri, d11);
        TextEdit te15 = JakartaForJavaAssert.te(35, 4, 36, 4, "");
        CodeAction ca15 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Negative from element", d11, te15);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams14, IJDT_UTILS, ca15);
        JakartaJavaCodeActionParams codeActionParams15 = JakartaForJavaAssert.createCodeActionParams(uri, d12);
        TextEdit te16 = JakartaForJavaAssert.te(38, 4, 39, 4, "");
        CodeAction ca16 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation NegativeOrZero from element", d12, te16);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams15, IJDT_UTILS, ca16);
        JakartaJavaCodeActionParams codeActionParams16 = JakartaForJavaAssert.createCodeActionParams(uri, d13);
        TextEdit te17 = JakartaForJavaAssert.te(41, 4, 42, 4, "");
        CodeAction ca17 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation NotBlank from element", d13, te17);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams16, IJDT_UTILS, ca17);
        JakartaJavaCodeActionParams codeActionParams17 = JakartaForJavaAssert.createCodeActionParams(uri, d14);
        TextEdit te18 = JakartaForJavaAssert.te(44, 4, 45, 4, "");
        CodeAction ca18 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Pattern from element", d14, te18);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams17, IJDT_UTILS, ca18);
        JakartaJavaCodeActionParams codeActionParams18 = JakartaForJavaAssert.createCodeActionParams(uri, d15);
        TextEdit te19 = JakartaForJavaAssert.te(47, 4, 48, 4, "");
        CodeAction ca19 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Past from element", d15, te19);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams18, IJDT_UTILS, ca19);
        JakartaJavaCodeActionParams codeActionParams19 = JakartaForJavaAssert.createCodeActionParams(uri, d16);
        TextEdit te20 = JakartaForJavaAssert.te(50, 4, 51, 4, "");
        CodeAction ca20 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation PastOrPresent from element", d16, te20);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams19, IJDT_UTILS, ca20);
        JakartaJavaCodeActionParams codeActionParams20 = JakartaForJavaAssert.createCodeActionParams(uri, d17);
        TextEdit te21 = JakartaForJavaAssert.te(53, 4, 54, 4, "");
        CodeAction ca21 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Positive from element", d17, te21);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams20, IJDT_UTILS, ca21);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d19);
        TextEdit te1 = JakartaForJavaAssert.te(59, 4, 60, 4, "");
        TextEdit te2 = JakartaForJavaAssert.te(60, 11, 60, 18, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d19, te1);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d19, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, IJDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams3 = JakartaForJavaAssert.createCodeActionParams(uri, d20);
        TextEdit te3 = JakartaForJavaAssert.te(62, 4, 63, 4, "");
        TextEdit te4 = JakartaForJavaAssert.te(63, 11, 63, 18, "");
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Past from element", d20, te3);
        CodeAction ca4 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d20, te4);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams3, IJDT_UTILS, ca3, ca4);
        JakartaJavaCodeActionParams codeActionParams4 = JakartaForJavaAssert.createCodeActionParams(uri, d18);
        TextEdit te5 = JakartaForJavaAssert.te(56, 4, 57, 4, "");
        CodeAction ca5 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation PositiveOrZero from element", d18, te5);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams4, IJDT_UTILS, ca5);
        JakartaJavaCodeActionParams codeActionParams21 = JakartaForJavaAssert.createCodeActionParams(uri, d21);
        TextEdit te22 = JakartaForJavaAssert.te(65, 4, 66, 4, "");
        CodeAction ca22 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Size from element", d21, te22);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams21, IJDT_UTILS, ca22);
        JakartaJavaCodeActionParams codeActionParams22 = JakartaForJavaAssert.createCodeActionParams(uri, d22);
        TextEdit te23 = JakartaForJavaAssert.te(68, 4, 69, 4, "");
        CodeAction ca23 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation NotEmpty from element", d22, te23);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams22, IJDT_UTILS, ca23);
    }

    @Test
    public void methodConstraintValidation() throws Exception {
        IJavaProject javaProject = BeanValidationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/beanvalidation/MethodConstraintValidation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(21, 26, 38, "Constraint annotations are not allowed on static methods.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"jakarta.validation.constraints.AssertTrue");
        Diagnostic d2 = JakartaForJavaAssert.d(26, 18, 28, "The @AssertTrue annotation can only be used on boolean and Boolean type methods.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonBooleanMethodOrField", (Object)"jakarta.validation.constraints.AssertTrue");
        Diagnostic d3 = JakartaForJavaAssert.d(31, 23, 33, "Constraint annotations are not allowed on static methods.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidConstrainAnnotationOnStaticMethodOrField", (Object)"jakarta.validation.constraints.AssertFalse");
        Diagnostic d4 = JakartaForJavaAssert.d(36, 19, 28, "This annotation can only be used on methods that have CharSequence, Collection, Array or Map as a return type.", DiagnosticSeverity.Error, "jakarta-bean-validation", "InvalidAnnotationOnNonSizeMethodOrField", (Object)"jakarta.validation.constraints.Size");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3, d4);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(20, 4, 21, 4, "");
        TextEdit te2 = JakartaForJavaAssert.te(21, 10, 21, 17, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d1, te);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d1, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca2);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        te = JakartaForJavaAssert.te(25, 4, 26, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertTrue from element", d2, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d3);
        te = JakartaForJavaAssert.te(20, 4, 21, 4, "");
        te2 = JakartaForJavaAssert.te(21, 10, 21, 17, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove constraint annotation AssertFalse from element", d3, te);
        ca2 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d3, te2);
        JakartaJavaCodeActionParams codeActionParams4 = JakartaForJavaAssert.createCodeActionParams(uri, d4);
        TextEdit te4 = JakartaForJavaAssert.te(35, 4, 36, 4, "");
        CodeAction ca4 = JakartaForJavaAssert.ca(uri, "Remove constraint annotation Size from element", d4, te4);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams4, IJDT_UTILS, ca4);
    }
}

