/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.di;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class InnerClassInjectionTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void NonStaticInnerClassInjection() throws Exception {
        IJavaProject javaProject = InnerClassInjectionTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/InnerClassInjection.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 19, 23, "Cannot inject non-static inner class. Injection target must be a top-level or static nested class.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnNonStaticInnerClass");
        Diagnostic d2 = JakartaForJavaAssert.d(29, 13, 20, "Cannot inject non-static inner class. Injection target must be a top-level or static nested class.", DiagnosticSeverity.Error, "jakarta-di", "InvalidInjectAnnotationOnNonStaticInnerClass");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(33, 7, 33, 7, " static");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Add 'static' modifier to the nested class", d1, te);
        TextEdit te1 = JakartaForJavaAssert.te(21, 1, 22, 1, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove @Inject", d1, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        te = JakartaForJavaAssert.te(33, 7, 33, 7, " static");
        ca = JakartaForJavaAssert.ca(uri, "Add 'static' modifier to the nested class", d2, te);
        te1 = JakartaForJavaAssert.te(28, 1, 29, 1, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove @Inject", d2, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
    }
}

