/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.RemoveParamsProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public class RemoveAllMethodParametersQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(RemoveAllMethodParametersQuickFix.class.getName());

    @Override
    public String getParticipantId() {
        return RemoveAllMethodParametersQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ExtendedCodeAction codeAction = new ExtendedCodeAction(this.getLabel());
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), null, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), JakartaCodeActionId.RemoveAllParameters));
        return Collections.singletonList(codeAction);
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        IMethodBinding parentMethod = parentNode.resolveBinding();
        new ArrayList();
        List parameters = parentNode.parameters();
        RemoveParamsProposal proposal = new RemoveParamsProposal(this.getLabel(), context.getCompilationUnit(), context.getASTRoot(), (IBinding)parentMethod, 0, parameters, null);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to create workspace edit to remove all parameters", e);
        }
        return toResolve;
    }

    public String getLabel() {
        return Messages.getMessage("RemoveAllParameters", new Object[0]);
    }
}

