/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.providers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSourceProvider;
import org.eclipse.lsp4mp.jdt.core.project.PropertiesConfigSource;

public class MicroProfileConfigSourceProvider
implements IConfigSourceProvider {
    private static final String META_INF_FOLDER = "META-INF";
    private static final String MICROPROFILE_CONFIG_PROPERTIES_FILE_NAME = "microprofile-config.properties";
    public static final String MICROPROFILE_CONFIG_PROPERTIES_FILE = "META-INF/microprofile-config.properties";
    private static final Pattern PER_PROFILE_FILE_NAME_PTN = Pattern.compile("microprofile-config-([A-Za-z]+)\\.properties");

    @Override
    public List<IConfigSource> getConfigSources(IJavaProject javaProject, File outputFolder) {
        ArrayList<IConfigSource> configSources = new ArrayList<IConfigSource>();
        File metaInfDir = outputFolder.toPath().resolve(META_INF_FOLDER).toFile();
        if (metaInfDir.exists() && metaInfDir.isDirectory()) {
            File[] fileArray = metaInfDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName;
                IConfigSource configSource;
                File file = fileArray[n2];
                if (file.isFile() && (configSource = MicroProfileConfigSourceProvider.createConfigSource(fileName = file.getName(), javaProject)) != null) {
                    configSources.add(configSource);
                }
                ++n2;
            }
        }
        return configSources;
    }

    private static IConfigSource createConfigSource(String fileName, IJavaProject javaProject) {
        if (MICROPROFILE_CONFIG_PROPERTIES_FILE_NAME.equals(fileName)) {
            return new PropertiesConfigSource("META-INF/" + fileName, javaProject);
        }
        Matcher m = PER_PROFILE_FILE_NAME_PTN.matcher(fileName);
        if (m.matches()) {
            return new PropertiesConfigSource("META-INF/" + fileName, m.group(1), 101, javaProject);
        }
        return null;
    }

    @Override
    public boolean isConfigSource(String fileName) {
        return MICROPROFILE_CONFIG_PROPERTIES_FILE_NAME.equals(fileName) | PER_PROFILE_FILE_NAME_PTN.matcher(fileName).matches();
    }
}

