/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileProjectRuntime;

public class TypeSignatureParser {
    public static Type parse(String signature) {
        return TypeSignatureParser.parse(signature, null);
    }

    public static Type parse(String signature, EnumConstantsProvider enumConstNamesProvider) {
        return TypeSignatureParser.parse(signature, enumConstNamesProvider, Thread.currentThread().getContextClassLoader());
    }

    public static Type parse(String signature, EnumConstantsProvider enumConstNamesProvider, ClassLoader classLoader) {
        return new Parser(signature, enumConstNamesProvider, classLoader).parseType();
    }

    public static class EmulateType
    implements Type {
        private final String typeName;

        public EmulateType(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }
    }

    public static class EnumType
    extends EmulateType {
        private List<String> enumConstNames;

        public EnumType(String typeName, List<String> enumConstNames) {
            super(typeName);
            this.enumConstNames = enumConstNames;
        }

        public List<String> getEnumConstants() {
            return this.enumConstNames;
        }

        public void setEnumConstNames(List<String> enumConstNames) {
            this.enumConstNames = enumConstNames;
        }
    }

    private static class Parser {
        private final String s;
        private int pos = 0;
        private final ClassLoader classLoader;
        private final EnumConstantsProvider enumConstNamesProvider;

        Parser(String s, EnumConstantsProvider enumConstNamesProvider, ClassLoader classLoader) {
            this.s = s;
            this.enumConstNamesProvider = enumConstNamesProvider;
            this.classLoader = classLoader;
        }

        Type parseType() {
            String raw = this.readIdentifier();
            this.skipSpaces();
            if (this.peek() != '<') {
                return this.loadClass(raw);
            }
            this.next();
            ArrayList<Type> args = new ArrayList<Type>();
            while (true) {
                this.skipSpaces();
                args.add(this.parseType());
                this.skipSpaces();
                if (this.peek() != ',') break;
                this.next();
            }
            this.expect('>');
            return this.parameterized(raw, (Type[])args.toArray(Type[]::new));
        }

        String readIdentifier() {
            int start = this.pos;
            while (this.pos < this.s.length() && !this.isBoundary(this.s.charAt(this.pos))) {
                ++this.pos;
            }
            return this.s.substring(start, this.pos).trim();
        }

        boolean isBoundary(char c) {
            return c == '<' || c == '>' || c == ',' || Character.isWhitespace(c);
        }

        char peek() {
            return this.pos < this.s.length() ? this.s.charAt(this.pos) : (char)'\u0000';
        }

        int next() {
            return this.pos < this.s.length() ? (int)this.s.charAt(this.pos++) : -1;
        }

        void skipSpaces() {
            while (this.pos < this.s.length() && Character.isWhitespace(this.s.charAt(this.pos))) {
                ++this.pos;
            }
        }

        void expect(char c) {
            if (this.peek() != c) {
                throw new IllegalArgumentException("Expected '" + c + "' at position " + this.pos + " in: " + this.s);
            }
            ++this.pos;
        }

        Type loadClass(String name) {
            return MicroProfileProjectRuntime.findType(name, this.enumConstNamesProvider, this.classLoader);
        }

        ParameterizedType parameterized(final String raw, final Type ... args) {
            return new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return args;
                }

                @Override
                public Type getRawType() {
                    return this.loadClass(raw);
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }

                public String toString() {
                    CharSequence[] parts = new String[args.length];
                    int i = 0;
                    while (i < args.length) {
                        parts[i] = args[i].toString();
                        ++i;
                    }
                    return raw + "<" + String.join((CharSequence)", ", parts) + ">";
                }
            };
        }
    }
}

