/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.health.java;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4mp.jdt.internal.health.java.MicroProfileHealthErrorCode;

public class MicroProfileHealthDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.health.HealthCheck") != null;
    }

    @Override
    public void collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaElement[] elements = typeRoot.getChildren();
        MicroProfileHealthDiagnosticsParticipant.collectDiagnostics(elements, context, monitor);
    }

    private static void collectDiagnostics(IJavaElement[] elements, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7 && !(type = (IType)element).isInterface()) {
                MicroProfileHealthDiagnosticsParticipant.validateClassType(type, context, monitor);
            }
            ++n2;
        }
    }

    private static void validateClassType(IType classType, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        Range healthCheckInterfaceRange;
        IJDTUtils utils = context.getUtils();
        DocumentFormat documentFormat = context.getDocumentFormat();
        IType[] interfaces = MicroProfileHealthDiagnosticsParticipant.findImplementedInterfaces(classType, monitor);
        boolean implementsHealthCheck = Stream.of(interfaces).anyMatch(interfaceType -> "HealthCheck".equals(interfaceType.getElementName()));
        boolean hasOneOfHealthAnnotation = AnnotationUtils.hasAnyAnnotation((IAnnotatable)classType, "org.eclipse.microprofile.health.Liveness", "org.eclipse.microprofile.health.Readiness", "org.eclipse.microprofile.health.Startup", "org.eclipse.microprofile.health.Health");
        if (hasOneOfHealthAnnotation && !implementsHealthCheck) {
            healthCheckInterfaceRange = PositionUtils.toNameRange(classType, utils);
            context.addDiagnostic(MicroProfileHealthDiagnosticsParticipant.createDiagnostic1Message(classType, documentFormat), healthCheckInterfaceRange, "microprofile-health", MicroProfileHealthErrorCode.ImplementHealthCheck);
        }
        if (implementsHealthCheck && !hasOneOfHealthAnnotation) {
            healthCheckInterfaceRange = PositionUtils.toNameRange(classType, utils);
            context.addDiagnostic(MicroProfileHealthDiagnosticsParticipant.createDiagnostic2Message(classType, documentFormat), healthCheckInterfaceRange, "microprofile-health", MicroProfileHealthErrorCode.HealthAnnotationMissing);
        }
    }

    private static String createDiagnostic1Message(IType classType, DocumentFormat documentFormat) {
        StringBuilder message = MicroProfileHealthDiagnosticsParticipant.getMessage(classType, documentFormat);
        message.append(" using the ");
        MicroProfileHealthDiagnosticsParticipant.listAvailableAnnotations(classType, message);
        message.append(" annotation should implement the HealthCheck interface.");
        return message.toString();
    }

    private static String createDiagnostic2Message(IType classType, DocumentFormat documentFormat) {
        StringBuilder message = MicroProfileHealthDiagnosticsParticipant.getMessage(classType, documentFormat);
        message.append(" implementing the HealthCheck interface should use the ");
        MicroProfileHealthDiagnosticsParticipant.listAvailableAnnotations(classType, message);
        message.append(" annotation.");
        return message.toString();
    }

    private static StringBuilder getMessage(IType classType, DocumentFormat documentFormat) {
        StringBuilder message = new StringBuilder("The class ");
        String backtick = documentFormat == DocumentFormat.Markdown ? "`" : "";
        message.append(backtick).append(classType.getFullyQualifiedName()).append(backtick);
        return message;
    }

    private static void listAvailableAnnotations(IType classType, StringBuilder message) {
        ArrayList<String> annotations = new ArrayList<String>(4);
        annotations.add("@Liveness");
        annotations.add("@Readiness");
        if (JDTTypeUtils.findType(classType.getJavaProject(), "org.eclipse.microprofile.health.Startup") != null) {
            annotations.add("@Startup");
        }
        if (JDTTypeUtils.findType(classType.getJavaProject(), "org.eclipse.microprofile.health.Health") != null) {
            annotations.add("@Health");
        }
        int size = annotations.size();
        int secondLast = size - 2;
        int i = 0;
        while (i < size) {
            message.append((String)annotations.get(i));
            if (i == secondLast) {
                message.append(" or ");
            } else if (i < secondLast) {
                message.append(", ");
            }
            ++i;
        }
    }

    private static IType[] findImplementedInterfaces(IType type, IProgressMonitor progressMonitor) throws CoreException {
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
        return typeHierarchy.getRootInterfaces();
    }
}

