/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.jaxrs.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4mp.jdt.core.java.symbols.IJavaWorkspaceSymbolsParticipant;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsMethodInfo;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.JavaFeaturesRegistry;

public class JaxRsWorkspaceSymbolParticipant
implements IJavaWorkspaceSymbolsParticipant {
    private static final Logger LOGGER = Logger.getLogger(JaxRsWorkspaceSymbolParticipant.class.getName());

    @Override
    public void collectSymbols(IJavaProject project, IJDTUtils utils, List<SymbolInformation> symbols, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        JaxRsContext jaxrsContext = new JaxRsContext(project);
        Set<ITypeRoot> jaxrsTypes = JaxRsWorkspaceSymbolParticipant.getAllJaxRsTypes(project, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        ArrayList<JaxRsMethodInfo> methodsInfo = new ArrayList<JaxRsMethodInfo>();
        for (ITypeRoot typeRoot : jaxrsTypes) {
            IJaxRsInfoProvider provider = JaxRsWorkspaceSymbolParticipant.getProviderForType(typeRoot, monitor);
            if (provider != null) {
                methodsInfo.addAll(provider.getJaxRsMethodInfo(typeRoot, jaxrsContext, utils, monitor));
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
        methodsInfo.forEach(methodInfo -> {
            try {
                symbols.add(JaxRsWorkspaceSymbolParticipant.createSymbol(methodInfo, utils));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "failed to create workspace symbol for jax-rs method", e);
            }
        });
    }

    private static IJaxRsInfoProvider getProviderForType(ITypeRoot typeRoot, IProgressMonitor monitor) {
        for (IJaxRsInfoProvider provider : JavaFeaturesRegistry.getInstance().getJaxRsInfoProviders()) {
            if (!provider.canProvideJaxRsMethodInfoForClass(typeRoot, monitor)) continue;
            return provider;
        }
        LOGGER.severe("Attempted to collect JAX-RS info for " + typeRoot.getElementName() + ", but no participant was suitable, despite the fact that an earlier check found a suitable participant");
        return null;
    }

    private static Set<ITypeRoot> getAllJaxRsTypes(IJavaProject javaProject, IProgressMonitor monitor) {
        HashSet<ITypeRoot> jaxrsTypes = new HashSet<ITypeRoot>();
        for (IJaxRsInfoProvider provider : JavaFeaturesRegistry.getInstance().getJaxRsInfoProviders()) {
            jaxrsTypes.addAll(provider.getAllJaxRsClasses(javaProject, monitor));
            if (!monitor.isCanceled()) continue;
            return null;
        }
        return jaxrsTypes;
    }

    private static SymbolInformation createSymbol(JaxRsMethodInfo methodInfo, IJDTUtils utils) throws JavaModelException, MalformedURLException {
        ISourceRange sourceRange = methodInfo.getJavaMethod().getNameRange();
        Range r = utils.toRange(methodInfo.getJavaMethod().getOpenable(), sourceRange.getOffset(), sourceRange.getLength());
        Location location = new Location(methodInfo.getDocumentUri(), r);
        StringBuilder nameBuilder = new StringBuilder("@");
        URL url = new URL(methodInfo.getUrl());
        String path = url.getPath();
        nameBuilder.append(path);
        nameBuilder.append(": ");
        nameBuilder.append((Object)methodInfo.getHttpMethod());
        SymbolInformation symbol = new SymbolInformation();
        symbol.setName(nameBuilder.toString());
        symbol.setKind(SymbolKind.Method);
        symbol.setLocation(location);
        return symbol;
    }
}

