/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.adt.debug.core.AtlRunTarget;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.ui.vm.AtlSourceLocator;
import org.eclipse.m2m.atl.core.ui.vm.Messages;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.AtlSuperimposeModule;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.NetworkDebugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.VMException;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularVMLauncher
implements ILauncher {
    private static final String LAUNCHER_NAME = "Regular VM (with debugger)";
    private Map<String, IModel> models;
    private Map<String, ASM> libraries;
    private boolean checkSameModel;

    public String getName() {
        return LAUNCHER_NAME;
    }

    public void addInModel(IModel model, String name, String referenceModelName) {
        this.setCheckSameModel(model);
        if (this.models.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("RegularVMLauncher.MODEL_EVER_REGISTERED", new Object[]{name}));
        } else {
            this.models.put(name, model);
        }
        if (!this.models.containsKey(referenceModelName)) {
            this.models.put(referenceModelName, (IModel)model.getReferenceModel());
        }
    }

    public void addInOutModel(IModel model, String name, String referenceModelName) {
        this.setCheckSameModel(model);
        model.setIsTarget(true);
        this.addInModel(model, name, referenceModelName);
    }

    public void addOutModel(IModel model, String name, String referenceModelName) {
        this.setCheckSameModel(model);
        model.setIsTarget(true);
        this.addInModel(model, name, referenceModelName);
    }

    public void addLibrary(String name, Object library) {
        if (this.libraries.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("RegularVMLauncher.LIBRARY_EVER_REGISTERED", new Object[]{name}));
        } else {
            this.libraries.put(name, this.getASMFromObject(library));
        }
    }

    public void initialize(Map<String, Object> options) {
        this.models = new HashMap<String, IModel>();
        this.libraries = new HashMap<String, ASM>();
        this.checkSameModel = "false".equals(options.get("allowInterModelReferences"));
    }

    public String getDefaultModelFactoryName() {
        return "ASM";
    }

    public Object launch(String mode, IProgressMonitor monitor, final Map<String, Object> options, final Object ... modules) {
        AtlRunTarget mTarget = null;
        ILaunch launchParam = (ILaunch)options.get("launch");
        try {
            if (mode.equals("debug")) {
                String portOption = launchParam.getLaunchConfiguration().getAttribute("Port", Integer.valueOf(6060).toString());
                if (portOption.equals("")) {
                    portOption = Integer.valueOf(6060).toString();
                }
                if (launchParam != null) {
                    launchParam.setSourceLocator((ISourceLocator)new AtlSourceLocator());
                    mTarget = new AtlDebugTarget(launchParam);
                }
                final int port = new Integer(portOption);
                Thread th = new Thread(){

                    public void run() {
                        RegularVMLauncher.this.launch((Debugger)new NetworkDebugger(port, true), options, modules);
                    }
                };
                th.start();
                if (launchParam != null) {
                    ((AtlDebugTarget)mTarget).start();
                    launchParam.addDebugTarget((IDebugTarget)mTarget);
                }
            } else {
                if (launchParam != null) {
                    launchParam.setSourceLocator((ISourceLocator)new AtlSourceLocator());
                    mTarget = new AtlRunTarget(launchParam);
                    launchParam.addDebugTarget((IDebugTarget)mTarget);
                }
                this.launch((Debugger)new SimpleDebugger("true".equals(options.get("step")), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true, "true".equals(options.get("showSummary")), "true".equals(options.get("profile")), "true".equals(options.get("continueAfterError"))), options, modules);
                if (launchParam != null) {
                    mTarget.terminate();
                }
            }
        }
        catch (DebugException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    private Object launch(Debugger debugger, Map<String, Object> options, Object[] modules) {
        ASMOclAny ret = null;
        ASM asm = this.getASMFromObject(modules[0]);
        ASMModule asmModule = new ASMModule(asm);
        ASMExecEnv env = new ASMExecEnv(asmModule, debugger, !"true".equals(options.get("disableAttributeHelperCache")));
        env.addPermission("file.read");
        env.addPermission("file.write");
        for (String mname : this.models.keySet()) {
            env.addModel(mname, ((ASMModelWrapper)this.models.get(mname)).getAsmModel());
        }
        for (String lname : this.libraries.keySet()) {
            ASM lib = this.libraries.get(lname);
            env.registerOperations(lib);
            ASMOperation op = lib.getOperation("main");
            if (op == null) continue;
            op.exec((StackFrame)ASMStackFrame.rootFrame((ASMExecEnv)env, (ASMOperation)op, Arrays.asList(asmModule)));
        }
        env.registerOperations(asm);
        try {
            int i = 1;
            while (i < modules.length) {
                ASM module = this.getASMFromObject(modules[i]);
                AtlSuperimposeModule ami = new AtlSuperimposeModule(env, module);
                ami.adaptModuleOperations();
                env.registerOperations(module);
                ++i;
            }
        }
        catch (AtlSuperimposeModule.AtlSuperimposeModuleException e) {
            throw new VMException(null, e.getLocalizedMessage(), (Throwable)e);
        }
        boolean printExecutionTime = "true".equals(options.get("printExecutionTime"));
        long startTime = System.currentTimeMillis();
        ASMInterpreter ai = new ASMInterpreter(asm, asmModule, env, options);
        long endTime = System.currentTimeMillis();
        if (printExecutionTime && !(debugger instanceof NetworkDebugger)) {
            ATLLogger.info((String)(String.valueOf(asm.getName()) + " executed in " + (double)(endTime - startTime) / 1000.0 + "s."));
        }
        ret = ai.getReturnValue();
        return ret;
    }

    public Object loadModule(InputStream inputStream) {
        return new ASMXMLReader().read(inputStream);
    }

    private ASM getASMFromObject(Object module) {
        if (module instanceof InputStream) {
            return (ASM)this.loadModule((InputStream)module);
        }
        if (module instanceof ASM) {
            return (ASM)module;
        }
        return null;
    }

    public IModel getModel(String modelName) {
        return this.models.get(modelName);
    }

    public Object getLibrary(String libraryName) {
        return this.libraries.get(libraryName);
    }

    private void setCheckSameModel(IModel model) {
        if (model instanceof ASMModelWrapper) {
            ASMModel asmModel = ((ASMModelWrapper)model).getAsmModel();
            ((ASMEMFModel)asmModel).setCheckSameModel(this.checkSameModel);
        }
    }
}

