/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.etl;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.flock.FlockModule;
import org.eclipse.epsilon.flock.FlockResult;
import org.eclipse.epsilon.flock.IFlockContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockUnsupportedModelException;
import org.eclipse.qvtd.compiler.internal.etl.EpsilonTask;
import org.eclipse.qvtd.compiler.internal.etl.QvtMtcExecutionException;

public class FlockTask
extends EpsilonTask {
    private IModel originalModel;
    private IModel migratedModel;

    public FlockTask(URI flockSourceURI) {
        this.sourceURI = flockSourceURI;
        this.models = new ArrayList();
    }

    public FlockTask(String flockSourcePath) {
        this.sourceURI = URI.create(flockSourcePath);
        this.models = new ArrayList();
    }

    @Override
    public IEolExecutableModule createModule() {
        return new FlockModule();
    }

    public IModel getOriginalModel() {
        return this.originalModel;
    }

    public void setOriginalModel(IModel originalModel) {
        this.originalModel = originalModel;
        this.addModel(originalModel);
    }

    public IModel getMigratedModel() {
        return this.migratedModel;
    }

    public void setMigratedModel(IModel migratedModel) {
        this.migratedModel = migratedModel;
        this.addModel(migratedModel);
    }

    @Override
    public void execute() throws QvtMtcExecutionException {
        this.module = this.createModule();
        try {
            this.module.parse(this.sourceURI);
        }
        catch (Exception e) {
            throw new QvtMtcExecutionException("There was an error loading the Flock script.", e.getCause());
        }
        if (this.module.getParseProblems().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ParseProblem problem : this.module.getParseProblems()) {
                sb.append(String.valueOf(problem.toString()) + "\\n");
            }
            throw new QvtMtcExecutionException("Parse errors occured: " + sb.toString());
        }
        for (IModel model : this.getModels()) {
            this.module.getContext().getModelRepository().addModel(model);
        }
        try {
            ((IFlockContext)this.module.getContext()).setOriginalModel(this.originalModel);
            ((IFlockContext)this.module.getContext()).setMigratedModel(this.migratedModel);
        }
        catch (FlockUnsupportedModelException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        this.preProcess();
        try {
            this.result = this.module.execute();
        }
        catch (EolRuntimeException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        this.postProcess();
        for (IModel model : this.getModels()) {
            if (model.isStoredOnDisposal()) {
                try {
                    model.store();
                }
                catch (Exception e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            this.module.getContext().getModelRepository().removeModel(model);
        }
    }

    @Override
    public void postProcess() {
        super.postProcess();
        ((FlockResult)this.result).printWarnings(System.out);
    }
}

