/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.QVTcoreBaseFactory;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTiTuneUpVisitor
extends AbstractExtendingQVTimperativeVisitor<Boolean, Object> {
    public static final @NonNull QVTiTuneUpVisitor INSTANCE = new QVTiTuneUpVisitor(QVTiTuneUpVisitor.class);

    protected QVTiTuneUpVisitor(@NonNull Object context) {
        super(context);
    }

    protected @NonNull VariableExp rewritePropertyAssignmentTerm(@NonNull BottomPattern bottomPattern, @NonNull List<Assignment> variableAssignments, @NonNull OCLExpression expression) {
        Variable variable = PivotFactory.eINSTANCE.createVariable();
        variable.setName("_" + variableAssignments.size());
        variable.setType(expression.getType());
        variable.setTypeValue(expression.getTypeValue());
        variable.setIsRequired(expression.isIsRequired());
        bottomPattern.getVariable().add((Object)variable);
        VariableAssignment variableAssignment = QVTcoreBaseFactory.eINSTANCE.createVariableAssignment();
        variableAssignment.setTargetVariable(variable);
        variableAssignment.setValue(expression);
        variableAssignments.add((Assignment)variableAssignment);
        VariableExp variableExp = PivotFactory.eINSTANCE.createVariableExp();
        variableExp.setReferredVariable((VariableDeclaration)variable);
        variableExp.setType(expression.getType());
        variableExp.setTypeValue(expression.getTypeValue());
        variableExp.setIsRequired(expression.isIsRequired());
        return variableExp;
    }

    public @Nullable Boolean visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for QVTi Tune Up");
    }

    public @Nullable Boolean visitBottomPattern(@NonNull BottomPattern object) {
        ArrayList<Assignment> variableAssignments = new ArrayList<Assignment>();
        ArrayList<PropertyAssignment> propertyAssignments = new ArrayList<PropertyAssignment>();
        for (Assignment assignment : object.getAssignment()) {
            if (assignment instanceof ConnectionAssignment) {
                variableAssignments.add(assignment);
                continue;
            }
            if (assignment instanceof VariableAssignment) {
                variableAssignments.add(assignment);
                continue;
            }
            if (assignment instanceof PropertyAssignment) {
                OCLExpression value;
                PropertyAssignment propertyAssignment = (PropertyAssignment)assignment;
                OCLExpression slot = propertyAssignment.getSlotExpression();
                if (slot != null && slot.accept((Visitor)this) != Boolean.TRUE) {
                    propertyAssignment.setSlotExpression(null);
                    VariableExp variableExp = this.rewritePropertyAssignmentTerm(object, variableAssignments, slot);
                    propertyAssignment.setSlotExpression((OCLExpression)variableExp);
                }
                if ((value = propertyAssignment.getValue()) != null && value.accept((Visitor)this) != Boolean.TRUE) {
                    propertyAssignment.setValue(null);
                    VariableExp variableExp = this.rewritePropertyAssignmentTerm(object, variableAssignments, value);
                    propertyAssignment.setValue((OCLExpression)variableExp);
                }
                propertyAssignments.add(propertyAssignment);
                continue;
            }
            assignment.accept((Visitor)this);
        }
        variableAssignments.addAll(propertyAssignments);
        ECollections.setEList((EList)object.getAssignment(), variableAssignments);
        return (Boolean)super.visitBottomPattern(object);
    }

    public @Nullable Boolean visitCallExp(@NonNull CallExp object) {
        return Boolean.FALSE;
    }

    public @Nullable Boolean visitCollectionItem(@NonNull CollectionItem object) {
        OCLExpression ownedItem = object.getOwnedItem();
        if (ownedItem != null && ownedItem.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        for (CollectionLiteralPart part : object.getOwnedParts()) {
            if (part == null || part.accept((Visitor)this) == Boolean.TRUE) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitCollectionRange(@NonNull CollectionRange object) {
        OCLExpression ownedFirst = object.getOwnedFirst();
        OCLExpression ownedLast = object.getOwnedLast();
        if (ownedFirst != null && ownedFirst.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        if (ownedLast != null && ownedLast.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitConnectionStatement(@NonNull ConnectionStatement object) {
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitCoreDomain(@NonNull CoreDomain object) {
        object.getGuardPattern().accept((Visitor)this);
        object.getBottomPattern().accept((Visitor)this);
        return Boolean.TRUE;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Boolean visitCorePattern(@NonNull CorePattern object) {
        @NonNull EList variables = ClassUtil.nullFree((EList)object.getVariable());
        QVTcoreBaseUtil.sortPatternVariables((List)variables);
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitIfExp(@NonNull IfExp object) {
        OCLExpression ownedCondition = object.getOwnedCondition();
        OCLExpression ownedThen = object.getOwnedThen();
        OCLExpression ownedElse = object.getOwnedElse();
        if (ownedCondition != null && ownedCondition.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        if (ownedThen != null && ownedThen.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        if (ownedElse != null && ownedElse.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitLetExp(@NonNull LetExp object) {
        OCLExpression ownedIn = object.getOwnedIn();
        Variable ownedVariable = object.getOwnedVariable();
        if (ownedIn != null && ownedIn.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        if (ownedVariable != null && ownedVariable.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitLiteralExp(@NonNull LiteralExp object) {
        return Boolean.TRUE;
    }

    @Override
    public @Nullable Boolean visitMapping(@NonNull Mapping object) {
        for (Domain domain : object.getDomain()) {
            domain.accept((Visitor)this);
        }
        object.getGuardPattern().accept((Visitor)this);
        object.getBottomPattern().accept((Visitor)this);
        MappingStatement mappingStatement = object.getMappingStatement();
        if (mappingStatement != null) {
            mappingStatement.accept((Visitor)this);
        }
        return Boolean.TRUE;
    }

    @Override
    public @Nullable Boolean visitMappingCall(@NonNull MappingCall object) {
        ECollections.sort(object.getBinding(), (Comparator)QVTimperativeUtil.MappingCallBindingComparator.INSTANCE);
        return Boolean.TRUE;
    }

    @Override
    public @Nullable Boolean visitMappingLoop(@NonNull MappingLoop object) {
        object.getOwnedBody().accept((Visitor)this);
        return Boolean.TRUE;
    }

    @Override
    public @Nullable Boolean visitMappingSequence(@NonNull MappingSequence object) {
        for (MappingStatement mappingStatement : object.getMappingStatements()) {
            if (mappingStatement == null) continue;
            mappingStatement.accept((Visitor)this);
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitShadowExp(@NonNull ShadowExp object) {
        for (ShadowPart part : object.getOwnedParts()) {
            if (part == null || part.accept((Visitor)this) == Boolean.TRUE) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitShadowPart(@NonNull ShadowPart object) {
        OCLExpression ownedInit = object.getOwnedInit();
        if (ownedInit != null && ownedInit.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitTransformation(@NonNull Transformation object) {
        for (Rule rule : object.getRule()) {
            rule.accept((Visitor)this);
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        for (TupleLiteralPart part : object.getOwnedParts()) {
            if (part == null || part.accept((Visitor)this) == Boolean.TRUE) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitTupleLiteralPart(@NonNull TupleLiteralPart object) {
        OCLExpression ownedInit = object.getOwnedInit();
        if (ownedInit != null && ownedInit.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitVariable(@NonNull Variable object) {
        OCLExpression ownedInit = object.getOwnedInit();
        if (ownedInit != null && ownedInit.accept((Visitor)this) != Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public @Nullable Boolean visitVariableExp(@NonNull VariableExp object) {
        return Boolean.TRUE;
    }
}

