/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SingletonIterator;

public abstract class AbstractSimpleNode
extends AbstractNode
implements SimpleNode {
    private final @NonNull List<@NonNull TypedElement> typedElements = new ArrayList<TypedElement>();

    protected AbstractSimpleNode(@NonNull NodeRole nodeRole, @NonNull SimpleRegion region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        super(nodeRole, region, name, classDatumAnalysis);
    }

    @Override
    public void addTypedElement(@NonNull TypedElement typedElement) {
        boolean wasAdded = this.typedElements.add(typedElement);
        assert (wasAdded);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull SimpleNavigationEdge> getCastEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsCastEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @Nullable SimpleNavigationEdge getNavigationEdge(@NonNull Property source2targetProperty) {
        return (SimpleNavigationEdge)super.getNavigationEdge(source2targetProperty);
    }

    @Override
    public @Nullable SimpleNode getNavigationTarget(@NonNull Property source2targetProperty) {
        return (SimpleNode)super.getNavigationTarget(source2targetProperty);
    }

    @Override
    public final @Nullable SimpleEdge getPredicateEdge(@NonNull Property source2targetProperty) {
        for (Edge edge : this.getOutgoingEdges()) {
            if (!edge.isPredicated() || !(edge instanceof NavigationEdge) || !(edge instanceof SimpleEdge) || ((NavigationEdge)edge).getProperty() != source2targetProperty) continue;
            return (SimpleEdge)edge;
        }
        return null;
    }

    @Override
    public @NonNull SimpleRegion getRegion() {
        return (SimpleRegion)this.region;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull ? extends SimpleEdge> getResultEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsExpressionEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @NonNull Iterable<@NonNull SimpleNode> getSimpleNodes() {
        return this;
    }

    @Override
    public @NonNull Iterator<@NonNull SimpleNode> iterator() {
        return new SingletonIterator<SimpleNode>(this);
    }

    @Override
    public @NonNull Iterable<@NonNull TypedElement> getTypedElements() {
        return this.typedElements;
    }
}

