/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edges;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ExpressionAnalyzer;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.IsConstantExpressionVisitor;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergeableRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Nodes;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Role;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SingletonIterator;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.AbstractMapping;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;
import org.eclipse.qvtd.pivot.schedule.AbstractAction;
import org.eclipse.qvtd.pivot.schedule.AbstractDatum;
import org.eclipse.qvtd.pivot.schedule.ClassDatum;
import org.eclipse.qvtd.pivot.schedule.MappingAction;

public class SimpleMappingRegion
extends AbstractMappingRegion
implements SimpleRegion,
Comparable<SimpleMappingRegion>,
MergeableRegion,
Iterable<MergeableRegion> {
    private final @NonNull MappingAction mappingAction;
    private final int naturalOrder;
    private final @NonNull Set<Predicate> complexPredicates = new HashSet<Predicate>();
    private List<SimpleMappingRegion> successors;
    private final @NonNull ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(this);
    private final @NonNull Map<VariableDeclaration, SimpleNode> variable2simpleNode = new HashMap<VariableDeclaration, SimpleNode>();
    private List<@NonNull SimpleNode> extraNodes = null;

    public SimpleMappingRegion(@NonNull SuperRegion superRegion, @NonNull MappingAction mappingAction, int naturalOrder) {
        super(superRegion);
        this.mappingAction = mappingAction;
        this.naturalOrder = naturalOrder;
        AbstractMapping mapping = mappingAction.getMapping();
        assert (mapping != null);
        ArrayList<@NonNull GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
        ArrayList<@NonNull BottomPattern> bottomPatterns = new ArrayList<BottomPattern>();
        guardPatterns.add((GuardPattern)ClassUtil.nonNull((Object)mapping.getGuardPattern()));
        bottomPatterns.add((BottomPattern)ClassUtil.nonNull((Object)mapping.getBottomPattern()));
        for (Domain domain : mapping.getDomain()) {
            if (!(domain instanceof CoreDomain)) continue;
            CoreDomain coreDomain = (CoreDomain)domain;
            guardPatterns.add((GuardPattern)ClassUtil.nonNull((Object)coreDomain.getGuardPattern()));
            bottomPatterns.add((BottomPattern)ClassUtil.nonNull((Object)coreDomain.getBottomPattern()));
        }
        this.analyzePredicates(guardPatterns);
        this.analyzePredicates(bottomPatterns);
        for (Predicate predicate : this.complexPredicates) {
            OCLExpression conditionExpression = predicate.getConditionExpression();
            SimpleNode resultNode = this.expressionAnalyzer.analyze((Visitable)conditionExpression);
            SimpleNode trueNode = Nodes.TRUE.createSimpleNode(this);
            Edges.ARGUMENT.createSimpleEdge(this, resultNode, null, trueNode);
        }
        for (BottomPattern bottomPattern : bottomPatterns) {
            for (RealizedVariable realizedVariable : bottomPattern.getRealizedVariable()) {
                Nodes.REALIZED_VARIABLE.createSimpleNode(this, (VariableDeclaration)realizedVariable);
            }
        }
        for (BottomPattern bottomPattern : bottomPatterns) {
            for (Assignment assignment : bottomPattern.getAssignment()) {
                assignment.accept((org.eclipse.ocl.pivot.util.Visitor)this.expressionAnalyzer);
            }
        }
        this.getHeadNodes();
        this.toGraph((GraphStringBuilder)new DOTStringBuilder());
        this.toGraph((GraphStringBuilder)new GraphMLStringBuilder());
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitSimpleMappingRegion(this);
    }

    public void addAssignmentEdge(@NonNull SimpleNode sourceNode, @NonNull Property source2targetProperty, @NonNull SimpleNode targetNode) {
        assert (sourceNode.isClassNode());
        Edge assignmentEdge = sourceNode.getAssignmentEdge(source2targetProperty);
        if (assignmentEdge == null) {
            Edges.REALIZED.createEdge(this, sourceNode, source2targetProperty, targetNode);
        } else assert (assignmentEdge.getTarget() == targetNode);
    }

    @Override
    public void addEdge(@NonNull Edge edge) {
        assert (this.basicGetSymbolName() == null || !edge.isNavigation());
        super.addEdge(edge);
    }

    @Override
    protected void addHeadNode(@NonNull Node headNode) {
        assert (this.basicGetSymbolName() == null);
        super.addHeadNode(headNode);
    }

    @Override
    public void addNode(@NonNull Node node) {
        assert (this.basicGetSymbolName() == null);
        super.addNode(node);
    }

    private void addPredicateNavigation(@NonNull VariableDeclaration sourceVariable, @NonNull List<Property> path, @Nullable VariableDeclaration targetVariable) {
        Property oppositeProperty;
        SimpleNode targetNode;
        assert (path.size() == 1);
        Property property = path.get(0);
        assert (property != null);
        SimpleNode sourceNode = this.getReferenceNode(sourceVariable);
        SimpleNode simpleNode = targetNode = targetVariable != null ? this.getReferenceNode(targetVariable) : Nodes.NULL.createSimpleNode(this);
        assert (sourceNode.isGuardVariable());
        assert (targetVariable == null || targetNode.isGuardVariable());
        assert (sourceNode.isClassNode());
        if (!property.isIsMany()) {
            SimpleEdge predicateEdge = sourceNode.getPredicateEdge(property);
            if (predicateEdge == null) {
                Edges.NAVIGATION.createSimpleEdge(this, sourceNode, property, targetNode);
            } else assert (predicateEdge.getTarget() == targetNode);
        }
        if ((oppositeProperty = property.getOpposite()) != null && !oppositeProperty.isIsMany()) {
            SimpleEdge predicateEdge = targetNode.getPredicateEdge(oppositeProperty);
            if (predicateEdge == null) {
                Edges.NAVIGATION.createSimpleEdge(this, targetNode, oppositeProperty, sourceNode);
            } else assert (predicateEdge.getTarget() == sourceNode);
        }
    }

    public void addVariableNode(@NonNull VariableDeclaration typedElement, @NonNull SimpleNode simpleNode) {
        this.variable2simpleNode.put(typedElement, simpleNode);
    }

    private void analyzePredicates(@NonNull List<@NonNull ? extends CorePattern> corePatterns) {
        for (CorePattern corePattern : corePatterns) {
            for (Variable variable : ClassUtil.nullFree((EList)corePattern.getVariable())) {
                if (corePattern instanceof GuardPattern) {
                    Nodes.GUARD.createSimpleNode(this, (VariableDeclaration)variable);
                    continue;
                }
                OCLExpression ownedInit = variable.getOwnedInit();
                if (ownedInit != null) {
                    this.analyzeVariable(variable, ownedInit);
                    continue;
                }
                Nodes.GUARD.createSimpleNode(this, (VariableDeclaration)variable);
            }
        }
        for (CorePattern corePattern : corePatterns) {
            for (Predicate predicate : ClassUtil.nullFree((EList)corePattern.getPredicate())) {
                OCLExpression referenceExpression;
                OCLExpression conditionExpression = predicate.getConditionExpression();
                if (conditionExpression == null) continue;
                OCLExpression boundExpression = this.getPredicateComparisonBoundExpression(conditionExpression);
                if (boundExpression instanceof VariableExp) {
                    referenceExpression = this.getPredicateComparisonReferenceExpression(conditionExpression);
                    assert (referenceExpression != null);
                    this.analyzeSimplePredicate(((VariableExp)boundExpression).getReferredVariable(), referenceExpression);
                    continue;
                }
                if (boundExpression instanceof NullLiteralExp) {
                    referenceExpression = this.getPredicateComparisonReferenceExpression(conditionExpression);
                    assert (referenceExpression != null);
                    this.analyzeSimplePredicate(null, referenceExpression);
                    continue;
                }
                this.complexPredicates.add(predicate);
            }
        }
    }

    private void analyzeSimplePredicate(@Nullable VariableDeclaration boundVariable, @NonNull OCLExpression referenceExpression) {
        ArrayList<Property> path = new ArrayList<Property>();
        OCLExpression expression = referenceExpression;
        while (expression instanceof NavigationCallExp) {
            NavigationCallExp navigationCallExp = (NavigationCallExp)expression;
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
            assert (referredProperty != null);
            path.add(0, referredProperty);
            expression = navigationCallExp.getOwnedSource();
            if (!(expression instanceof VariableExp)) continue;
            VariableDeclaration sourceVariable = ((VariableExp)expression).getReferredVariable();
            assert (sourceVariable != null);
            this.addPredicateNavigation(sourceVariable, path, boundVariable);
        }
    }

    private @NonNull SimpleNode analyzeVariable(@NonNull Variable variable, @NonNull OCLExpression ownedInit) {
        SimpleNode initNode = (SimpleNode)ownedInit.accept((org.eclipse.ocl.pivot.util.Visitor)this.expressionAnalyzer);
        assert (initNode != null);
        if (ownedInit instanceof OperationCallExp && initNode.isOperation()) {
            if (QVTbaseUtil.isIdentification((Operation)((OperationCallExp)ownedInit).getReferredOperation())) {
                SimpleNode stepNode = Nodes.REALIZED_VARIABLE.createSimpleNode(this, (VariableDeclaration)variable);
                Edges.RESULT.createSimpleEdge(this, initNode, null, stepNode);
                initNode = stepNode;
            } else {
                SimpleNode stepNode = Nodes.UNREALIZED_VARIABLE.createSimpleNode(this, variable);
                Edges.RESULT.createSimpleEdge(this, initNode, null, stepNode);
                initNode = stepNode;
            }
        }
        initNode.addTypedElement((TypedElement)variable);
        this.addVariableNode((VariableDeclaration)variable, initNode);
        return initNode;
    }

    @Override
    public int compareTo(SimpleMappingRegion thatRegion) {
        return Integer.compare(this.getNaturalOrder(), thatRegion.getNaturalOrder());
    }

    public @NonNull SimpleNode createExtraGuard(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        if (this.extraNodes == null) {
            this.extraNodes = new ArrayList<SimpleNode>();
        }
        SimpleNode extraGuardNode = Nodes.EXTRA_GUARD.createSimpleNode((SimpleRegion)this, "\u00abextra-" + (this.extraNodes.size() + 1) + "\u00bb", classDatumAnalysis);
        this.extraNodes.add(extraGuardNode);
        this.addHeadNode(extraGuardNode);
        return extraGuardNode;
    }

    @Override
    public @NonNull Iterable<@NonNull SimpleMappingRegion> getAllMappingRegions() {
        return Collections.singleton(this);
    }

    public @Nullable SimpleNode getExtraGuard(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        if (this.extraNodes != null) {
            for (SimpleNode extraNode : this.extraNodes) {
                if (extraNode.getClassDatumAnalysis() != classDatumAnalysis) continue;
                return extraNode;
            }
        }
        return null;
    }

    @Override
    public @NonNull String getName() {
        AbstractMapping mapping = this.mappingAction.getMapping();
        return String.valueOf(mapping.getName());
    }

    public int getNaturalOrder() {
        return this.naturalOrder;
    }

    private @Nullable OCLExpression getPredicateComparisonBoundExpression(@NonNull OCLExpression conditionExpression) {
        OperationCallExp callExp;
        OperationId operationId;
        if (conditionExpression instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationId = (callExp = (OperationCallExp)conditionExpression).getReferredOperation().getOperationId()), (OperationId)this.getSchedulerConstants().getOclAnyEqualsId())) {
            OCLExpression leftExp = callExp.getOwnedSource();
            if (leftExp instanceof VariableExp) {
                return leftExp;
            }
            OCLExpression rightExp = (OCLExpression)callExp.getOwnedArguments().get(0);
            if (rightExp instanceof VariableExp) {
                return rightExp;
            }
            IsConstantExpressionVisitor isConstantExpressionVisitor = new IsConstantExpressionVisitor(null);
            if (isConstantExpressionVisitor.isConstant((Visitable)leftExp)) {
                return leftExp;
            }
            if (isConstantExpressionVisitor.isConstant((Visitable)rightExp)) {
                return rightExp;
            }
        }
        return null;
    }

    private @Nullable OCLExpression getPredicateComparisonReferenceExpression(@NonNull OCLExpression conditionExpression) {
        OperationCallExp callExp;
        OperationId operationId;
        if (conditionExpression instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationId = (callExp = (OperationCallExp)conditionExpression).getReferredOperation().getOperationId()), (OperationId)this.getSchedulerConstants().getOclAnyEqualsId())) {
            OCLExpression leftExp = callExp.getOwnedSource();
            OCLExpression rightExp = (OCLExpression)callExp.getOwnedArguments().get(0);
            if (leftExp instanceof VariableExp) {
                return rightExp;
            }
            if (rightExp instanceof VariableExp) {
                return leftExp;
            }
            IsConstantExpressionVisitor isConstantExpressionVisitor = new IsConstantExpressionVisitor(null);
            if (isConstantExpressionVisitor.isConstant((Visitable)leftExp)) {
                return rightExp;
            }
            if (isConstantExpressionVisitor.isConstant((Visitable)rightExp)) {
                return leftExp;
            }
        }
        return null;
    }

    @Override
    public @NonNull String getColor() {
        return "green";
    }

    @Override
    public @NonNull Iterable<@NonNull MergeableRegion> getMergeableRegions() {
        return this;
    }

    public @NonNull SimpleNode getReferenceNode(@NonNull VariableDeclaration variable) {
        OCLExpression ownedInit;
        SimpleNode node = this.variable2simpleNode.get(variable);
        if (node == null && variable instanceof Variable && (ownedInit = ((Variable)variable).getOwnedInit()) != null) {
            node = this.analyzeVariable((Variable)variable, ownedInit);
        }
        assert (node != null) : "No variable2simpleNode entry for " + variable;
        return node;
    }

    public @Nullable SimpleNode getSimpleNode(@NonNull TypedElement typedElement) {
        return this.variable2simpleNode.get(typedElement);
    }

    public @NonNull List<? extends Region> getSuccessors() {
        List<SimpleMappingRegion> successors2 = this.successors;
        if (successors2 == null) {
            this.successors = successors2 = new ArrayList<SimpleMappingRegion>();
            for (AbstractDatum production : this.mappingAction.getProductions()) {
                for (AbstractAction nextAction : production.getRequiredBy()) {
                    SimpleMappingRegion nextRegion = this.getMappingRegion(nextAction);
                    assert (nextRegion != null);
                    if (successors2.contains(nextRegion)) continue;
                    successors2.add(nextRegion);
                }
            }
            Collections.sort(this.successors);
        }
        return successors2;
    }

    public @NonNull SimpleNode getUnknownNode(@NonNull TypedElement typedElement) {
        assert (!(typedElement instanceof Property));
        SimpleNode node = this.getSimpleNode(typedElement);
        if (node == null) {
            node = Nodes.UNKNOWN.createSimpleNode((SimpleRegion)this, (String)ClassUtil.nonNullState((Object)typedElement.getType().toString()), typedElement);
        }
        return node;
    }

    @Override
    public Iterator<@NonNull MergeableRegion> iterator() {
        return new SingletonIterator<MergeableRegion>(this);
    }

    public void mergeInto(@NonNull SimpleNode unwantedNode, @NonNull SimpleNode wantedNode) {
        NavigationEdge unwantedNavigationEdge;
        SimpleNavigationEdge wantedNavigationEdge;
        boolean moveIt;
        for (Edge unwantedEdge : new ArrayList<Edge>(unwantedNode.getIncomingEdges())) {
            moveIt = true;
            if (unwantedEdge instanceof NavigationEdge && (wantedNavigationEdge = wantedNode.getNavigationEdge((unwantedNavigationEdge = (NavigationEdge)unwantedEdge).getProperty())) != null && unwantedNavigationEdge.getSource() == wantedNavigationEdge.getSource()) {
                assert (!unwantedNavigationEdge.isRealized());
                moveIt = false;
            }
            if (!moveIt) continue;
            unwantedEdge.setSource(wantedNode);
        }
        for (Edge unwantedEdge : new ArrayList<Edge>(unwantedNode.getOutgoingEdges())) {
            moveIt = true;
            if (unwantedEdge instanceof NavigationEdge && (wantedNavigationEdge = wantedNode.getNavigationEdge((unwantedNavigationEdge = (NavigationEdge)unwantedEdge).getProperty())) != null && unwantedNavigationEdge.getTarget() == wantedNavigationEdge.getTarget()) {
                assert (!unwantedNavigationEdge.isRealized());
                moveIt = false;
            }
            if (!moveIt) continue;
            unwantedEdge.setTarget(wantedNode);
        }
        unwantedNode.destroy();
    }

    public void registerConsumptionsAndProductions() {
        ClassDatum classDatum;
        ClassDatumAnalysis classDatumAnalysis;
        for (Node assignedNode : this.getComputedNodes()) {
            classDatumAnalysis = assignedNode.getClassDatumAnalysis();
            classDatumAnalysis.addProduction(this, assignedNode);
            classDatum = classDatumAnalysis.getClassDatum();
            for (AbstractAction consumingAction : classDatum.getRequiredBy()) {
                SimpleMappingRegion consumingRegion = this.superRegion.getMappingRegion(consumingAction);
                assert (consumingRegion != null);
                for (Node consumingNode : consumingRegion.getMatchableNodes()) {
                    if (consumingNode.getCompleteClass() != classDatumAnalysis.getCompleteClass()) continue;
                    classDatumAnalysis.addConsumption(consumingRegion, consumingNode);
                }
            }
        }
        for (Node predicatedNode : this.getMatchableNodes()) {
            classDatumAnalysis = predicatedNode.getClassDatumAnalysis();
            classDatumAnalysis.addConsumption(this, predicatedNode);
            classDatum = classDatumAnalysis.getClassDatum();
            for (AbstractAction introducingAction : classDatum.getProducedBy()) {
                SimpleMappingRegion producingRegion = this.superRegion.getMappingRegion(introducingAction);
                assert (producingRegion != null);
                for (Node assignedNode : producingRegion.getComputedNodes()) {
                    if (assignedNode.getCompleteClass() != classDatumAnalysis.getCompleteClass()) continue;
                    classDatumAnalysis.addProduction(producingRegion, assignedNode);
                }
            }
        }
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.setColor("palegreen");
        s.setPenwidth(Role.LINE_WIDTH);
        super.toGraph(s);
    }
}

