/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.CyclicScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.OperationRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region2Depth;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootCompositionRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.BasicRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.CyclicScheduledRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.RootRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameReservation;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTs2QVTiVisitor
extends QVTimperativeHelper
implements Visitor<Element> {
    public static final @NonNull TracingOption POLLED_PROPERTIES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvti/polledProperties");
    protected final @NonNull Transformation qvtpTransformation;
    protected final @NonNull SymbolNameReservation symbolNameReservation;
    protected final @NonNull Transformation qvtiTransformation;
    protected final @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> qvtpTypedModel2qvtiTypedModel = new HashMap<TypedModel, TypedModel>();
    protected final @NonNull List<@NonNull TypedModel> checkableTypedModels = new ArrayList<TypedModel>();
    protected final @NonNull List<@NonNull TypedModel> checkableAndEnforceableTypedModels = new ArrayList<TypedModel>();
    protected final @NonNull List<@NonNull TypedModel> enforceableTypedModels = new ArrayList<TypedModel>();
    protected final @NonNull Map<@NonNull Region, @NonNull AbstractRegion2Mapping> region2region2mapping = new HashMap<Region, AbstractRegion2Mapping>();
    private @Nullable Set<@NonNull String> reservedNames = null;
    private @NonNull Map<@NonNull Operation, @NonNull Operation> qvtpOperation2qvtiOperation = new HashMap<Operation, Operation>();
    private final @NonNull Region2Depth region2depth = new Region2Depth();
    private final @NonNull Set<@NonNull Transformation> otherTransformations = new HashSet<Transformation>();
    private final @NonNull Map<@NonNull String, @NonNull Operation> name2operation = new HashMap<String, Operation>();

    public QVTs2QVTiVisitor(@NonNull EnvironmentFactory environmentFactory, @NonNull Transformation qvtpTransformation, @NonNull SymbolNameReservation symbolNameReservation) {
        super(environmentFactory);
        this.qvtpTransformation = qvtpTransformation;
        this.symbolNameReservation = symbolNameReservation;
        String transformationName = qvtpTransformation.getName();
        assert (transformationName != null);
        this.qvtiTransformation = QVTimperativeUtil.createTransformation((String)transformationName);
        this.createTypedModels();
    }

    private void accumulateOperations(@NonNull Transformation transformation) {
        if (this.otherTransformations.add(transformation)) {
            TreeIterator tit = transformation.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Operation)) continue;
                Operation operation = (Operation)eObject;
                String name = String.valueOf(operation);
                this.name2operation.put(name, operation);
            }
        }
    }

    public @Nullable Operation create(@Nullable Operation pOperation) {
        if (pOperation == null) {
            return null;
        }
        Operation iOperation = this.qvtpOperation2qvtiOperation.get(pOperation);
        if (iOperation == null) {
            Transformation containingTransformation = QVTbaseUtil.getContainingTransformation((EObject)pOperation);
            if (containingTransformation == this.qvtpTransformation) {
                iOperation = (Operation)EcoreUtil.copy((EObject)pOperation);
                assert (iOperation != null);
                this.qvtpOperation2qvtiOperation.put(pOperation, iOperation);
                this.qvtiTransformation.getOwnedOperations().add(iOperation);
            } else {
                Operation otherOperation;
                if (containingTransformation != null) {
                    this.accumulateOperations(containingTransformation);
                }
                if ((otherOperation = this.name2operation.get(pOperation.toString())) != null) {
                    iOperation = (Operation)EcoreUtil.copy((EObject)pOperation);
                    assert (iOperation != null);
                    this.qvtpOperation2qvtiOperation.put(pOperation, iOperation);
                    this.qvtiTransformation.getOwnedOperations().add(iOperation);
                } else {
                    iOperation = pOperation;
                    this.qvtpOperation2qvtiOperation.put(pOperation, iOperation);
                }
            }
        }
        return iOperation;
    }

    public void createRegion2Mapping(@NonNull Region region) {
        AbstractRegion2Mapping region2mapping = this.region2region2mapping.get(region);
        assert (region2mapping == null) : "Re-AbstractRegion2Mapping for " + region;
        region2mapping = region.isCyclicScheduledRegion() ? new CyclicScheduledRegion2Mapping(this, (CyclicScheduledRegion)region) : (region.isRootCompositionRegion() ? new RootRegion2Mapping(this, (RootCompositionRegion)region) : new BasicRegion2Mapping(this, region));
        this.region2region2mapping.put(region, region2mapping);
        this.qvtiTransformation.getRule().add((Object)region2mapping.getMapping());
        region.accept(this);
    }

    protected void createTypedModels() {
        for (TypedModel qvtpTypedModel : this.qvtpTransformation.getModelParameter()) {
            String typedModelName = qvtpTypedModel.getName();
            assert (typedModelName != null);
            TypedModel qvtiTypedModel = QVTimperativeUtil.createTypedModel((String)typedModelName);
            qvtiTypedModel.getUsedPackage().addAll((Collection)qvtpTypedModel.getUsedPackage());
            this.qvtpTypedModel2qvtiTypedModel.put(qvtpTypedModel, qvtiTypedModel);
            this.qvtiTransformation.getModelParameter().add((Object)qvtiTypedModel);
        }
        for (Rule rule : this.qvtpTransformation.getRule()) {
            for (Domain domain : rule.getDomain()) {
                TypedModel enforceableTypedModel;
                TypedModel checkableTypedModel;
                if (domain.isIsCheckable() && (checkableTypedModel = this.qvtpTypedModel2qvtiTypedModel.get(domain.getTypedModel())) != null && !this.checkableAndEnforceableTypedModels.contains(checkableTypedModel)) {
                    if (this.enforceableTypedModels.contains(checkableTypedModel)) {
                        this.checkableAndEnforceableTypedModels.add(checkableTypedModel);
                        this.enforceableTypedModels.remove(checkableTypedModel);
                    } else if (!this.checkableTypedModels.contains(checkableTypedModel)) {
                        this.checkableTypedModels.add(checkableTypedModel);
                    }
                }
                if (!domain.isIsEnforceable() || (enforceableTypedModel = this.qvtpTypedModel2qvtiTypedModel.get(domain.getTypedModel())) == null || this.checkableAndEnforceableTypedModels.contains(enforceableTypedModel)) continue;
                if (this.checkableTypedModels.contains(enforceableTypedModel)) {
                    this.checkableAndEnforceableTypedModels.add(enforceableTypedModel);
                    this.checkableTypedModels.remove(enforceableTypedModel);
                    continue;
                }
                if (this.enforceableTypedModels.contains(enforceableTypedModel)) continue;
                this.enforceableTypedModels.add(enforceableTypedModel);
            }
        }
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull Operation getEqualsOperation() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
        assert (operation1 != null);
        OperationId oclAnyEqualsId = operation1.getOperationId();
        return this.environmentFactory.getIdResolver().getOperation(oclAnyEqualsId);
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull Operation getNotEqualsOperation() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"<>");
        assert (operation1 != null);
        OperationId oclAnyEqualsId = operation1.getOperationId();
        return this.environmentFactory.getIdResolver().getOperation(oclAnyEqualsId);
    }

    public @Nullable TypedModel getQVTiTypedModel(@Nullable TypedModel qvtpTypedModel) {
        TypedModel qvtiTypedModel = this.qvtpTypedModel2qvtiTypedModel.get(qvtpTypedModel);
        return qvtiTypedModel != null ? qvtiTypedModel : qvtpTypedModel;
    }

    public @NonNull Region2Depth getRegion2Depth() {
        return this.region2depth;
    }

    public @NonNull AbstractRegion2Mapping getRegion2Mapping(@NonNull Region region) {
        AbstractRegion2Mapping region2mapping = this.region2region2mapping.get(region);
        assert (region2mapping != null) : "No AbstractRegion2Mapping for " + region;
        return region2mapping;
    }

    public @NonNull Set<@NonNull String> getReservedNames() {
        Set<@NonNull String> reservedNames2 = this.reservedNames;
        if (reservedNames2 == null) {
            this.reservedNames = reservedNames2 = new HashSet<String>();
            reservedNames2.add((String)ClassUtil.nonNull((Object)this.qvtpTransformation.getName()));
            for (TypedModel typedModel : this.qvtpTransformation.getModelParameter()) {
                reservedNames2.add((String)ClassUtil.nonNullState((Object)typedModel.getName()));
            }
            for (Operation operation : this.qvtpTransformation.getOwnedOperations()) {
                reservedNames2.add((String)ClassUtil.nonNull((Object)operation.getName()));
            }
            for (Property property : this.qvtpTransformation.getOwnedProperties()) {
                reservedNames2.add((String)ClassUtil.nonNull((Object)property.getName()));
            }
        }
        return reservedNames2;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public @NonNull Transformation getTransformation() {
        return this.qvtiTransformation;
    }

    public @NonNull String reserveSymbolName(@NonNull SymbolNameBuilder symbolNameBuilder, @NonNull Object object) {
        return this.symbolNameReservation.reserveSymbolName(symbolNameBuilder, object);
    }

    @Override
    public @Nullable Element visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    public @Nullable Element visitCyclicScheduledRegion(@NonNull CyclicScheduledRegion cyclicScheduledRegion) {
        ArrayList<@NonNull Region> callableRegions = new ArrayList<Region>();
        for (Region region : cyclicScheduledRegion.getRegions()) {
            if (region.isOperationRegion()) continue;
            callableRegions.add(region);
        }
        List<@NonNull Region> sortedRegions = AbstractRegion.EarliestRegionComparator.sort(callableRegions);
        for (Region region : sortedRegions) {
            this.createRegion2Mapping(region);
        }
        for (Region region : sortedRegions) {
            AbstractRegion2Mapping region2Mapping = this.getRegion2Mapping(region);
            region2Mapping.createStatements();
        }
        AbstractRegion2Mapping region2mapping = this.getRegion2Mapping(cyclicScheduledRegion);
        return region2mapping.getMapping();
    }

    @Override
    public @Nullable Element visitMergedMappingRegion(@NonNull MergedMappingRegion mergedMappingRegion) {
        AbstractRegion2Mapping region2mapping = this.getRegion2Mapping(mergedMappingRegion);
        Mapping mapping = region2mapping.getMapping();
        return mapping;
    }

    @Override
    public @Nullable Element visitOperationRegion(@NonNull OperationRegion operationRegion) {
        return this.visiting(operationRegion);
    }

    @Override
    public @Nullable Element visitRootCompositionRegion(@NonNull RootCompositionRegion rootCompositionRegion) {
        AbstractRegion2Mapping region2mapping = this.getRegion2Mapping(rootCompositionRegion);
        Mapping mapping = region2mapping.getMapping();
        return mapping;
    }

    @Override
    public @Nullable Element visitRootScheduledRegion(@NonNull RootScheduledRegion rootScheduledRegion) {
        ArrayList<@NonNull Region> callableRegions = new ArrayList<Region>();
        for (Region region : rootScheduledRegion.getRegions()) {
            if (region.isOperationRegion()) continue;
            callableRegions.add(region);
        }
        List<@NonNull Region> sortedRegions = AbstractRegion.EarliestRegionComparator.sort(callableRegions);
        for (Region region : sortedRegions) {
            this.createRegion2Mapping(region);
        }
        for (Region region : sortedRegions) {
            AbstractRegion2Mapping region2Mapping = this.getRegion2Mapping(region);
            region2Mapping.createStatements();
        }
        ECollections.sort((EList)this.qvtiTransformation.getRule(), (Comparator)NameUtil.NameableComparator.INSTANCE);
        return this.qvtiTransformation;
    }

    @Override
    public @Nullable Element visitSimpleMappingRegion(@NonNull SimpleMappingRegion simpleMappingRegion) {
        AbstractRegion2Mapping region2mapping = this.getRegion2Mapping(simpleMappingRegion);
        return region2mapping.getMapping();
    }
}

