/*******************************************************************************
 * Copyright (c) 2013, 2016 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.qvtd.pivot.qvtcorebase;

import org.eclipse.emf.common.util.EList;
import org.eclipse.qvtd.pivot.qvtbase.Rule;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Abstract Mapping</b></em>'.
 * <!-- end-user-doc -->
 *
 *
 * @see org.eclipse.qvtd.pivot.qvtcorebase.QVTcoreBasePackage#getAbstractMapping()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface AbstractMapping extends Rule, Area {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	AbstractMapping getContext();

	/**
	 * <!-- begin-user-doc -->
	 * The mappings that refine this mapping as part of their specification.
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated NOT
	 */
	EList<? extends AbstractMapping> getRefinement();

	/**
	 * <!-- begin-user-doc -->
	 * The mappings that are refined to contribute to the specification of  this mapping.
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated NOT
	 */
	EList<? extends AbstractMapping> getSpecification();
} // AbstractMapping
