/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.NodeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

class EdgeMerger {
    protected final @NonNull RegionMerger regionMerger;
    protected final @NonNull NodeMerger mergedSourceNodeMerger;
    protected final @NonNull NodeMerger mergedTargetNodeMerger;
    protected final @NonNull List<@NonNull Edge> oldEdges = new ArrayList<Edge>();
    private @NonNull Role edgeRole;
    private @Nullable Edge newEdge = null;

    public EdgeMerger(@NonNull RegionMerger regionMerger, @NonNull Edge oldEdge) {
        assert (!oldEdge.isSecondary());
        this.regionMerger = regionMerger;
        this.mergedSourceNodeMerger = regionMerger.getNodeMerger(oldEdge.getEdgeSource());
        this.mergedTargetNodeMerger = regionMerger.getNodeMerger(oldEdge.getEdgeTarget());
        this.oldEdges.add(oldEdge);
        this.edgeRole = RegionUtil.getEdgeRole((Edge)oldEdge);
        regionMerger.mapOldEdge(oldEdge, this);
        this.mergedSourceNodeMerger.addOutgoingEdgeMerger(this, this.mergedTargetNodeMerger);
        this.mergedTargetNodeMerger.addIncomingEdgeMerger(this, this.mergedSourceNodeMerger);
    }

    public void addOldEdge(@NonNull Edge oldEdge) {
        assert (!oldEdge.isSecondary());
        assert (!this.oldEdges.contains(oldEdge));
        this.oldEdges.add(oldEdge);
        this.edgeRole = RegionUtil.mergeToMoreKnownPhase((Role)this.edgeRole, (Role)RegionUtil.getEdgeRole((Edge)oldEdge));
        this.regionMerger.mapOldEdge(oldEdge, this);
    }

    public @Nullable Edge createNewEdge(@NonNull Node sourceNodeMerger, @NonNull Node targetNodeMerger) {
        Edge newEdge2 = this.newEdge;
        assert (newEdge2 == null);
        Iterator<Edge> iterator = this.oldEdges.iterator();
        if (iterator.hasNext()) {
            @NonNull Edge oldEdge = iterator.next();
            newEdge2 = this.newEdge = oldEdge.createEdge(this.edgeRole, sourceNodeMerger, targetNodeMerger);
        }
        if (newEdge2 == null) {
            return null;
        }
        return newEdge2;
    }

    public void destroy() {
        this.mergedSourceNodeMerger.removeOutgoingEdgeMerger(this, this.mergedTargetNodeMerger);
        this.mergedTargetNodeMerger.removeIncomingEdgeMerger(this, this.mergedSourceNodeMerger);
        for (Edge oldEdge : this.oldEdges) {
            this.regionMerger.unmapOldEdge(oldEdge, this);
        }
    }

    public @NonNull Edge getNewEdge() {
        return (Edge)ClassUtil.nonNullState((Object)this.newEdge);
    }

    public @NonNull Iterable<@NonNull Edge> getOldEdges() {
        return this.oldEdges;
    }

    public @NonNull Node getOldSource() {
        return this.oldEdges.get(0).getEdgeSource();
    }

    public @NonNull Node getOldTarget() {
        return this.oldEdges.get(0).getEdgeTarget();
    }

    public @NonNull NodeMerger getSource() {
        return this.mergedSourceNodeMerger;
    }

    public @NonNull NodeMerger getTarget() {
        return this.mergedTargetNodeMerger;
    }

    private boolean isCast() {
        return this.oldEdges.get(0).isCast();
    }

    public boolean isFoldable() {
        return this.isCast() && this.mergedTargetNodeMerger.isNew() && !this.mergedSourceNodeMerger.isNew();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Edge sameEdge(@NonNull Edge newEdge) {
        if (newEdge instanceof NavigableEdge) {
            Property newProperty = ((NavigableEdge)newEdge).getProperty();
            for (Edge oldEdge : this.oldEdges) {
                Property oldProperty;
                if (!(oldEdge instanceof NavigableEdge) || (oldProperty = ((NavigableEdge)oldEdge).getProperty()) != newProperty) continue;
                return oldEdge;
            }
        } else {
            Class<@NonNull ?> newClass = newEdge.getClass();
            for (Edge oldEdge : this.oldEdges) {
                Class<@NonNull ?> oldClass = oldEdge.getClass();
                if (oldClass != newClass) continue;
                return oldEdge;
            }
        }
        return null;
    }

    public String toString() {
        return this.newEdge != null ? this.newEdge.toString() : this.oldEdges.get(0).toString();
    }
}

