/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.utilities;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.PartitionProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionProblem;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtcore.QVTcorePackage;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CompilerUtil
extends QVTscheduleUtil {
    public static final @NonNull Map<Object, Object> defaultSavingOptions = new HashMap<Object, Object>();

    static {
        defaultSavingOptions.put("ENCODING", "UTF-8");
        defaultSavingOptions.put("LINE_DELIMITER", "\n");
        defaultSavingOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSavingOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        defaultSavingOptions.put("LINE_WIDTH", 132);
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)resource.getErrors(), (String)prefix, (String)"\n\t");
        if (message != null) assert (false) : message;
    }

    public static void assertNoResourceSetErrors(@NonNull String prefix, @NonNull Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        assert (resourceSet != null) : String.valueOf(prefix) + " no ResourceSet for " + resource;
        for (Resource aResource : resourceSet.getResources()) {
            if (aResource == null) continue;
            CompilerUtil.assertNoResourceErrors(prefix, aResource);
        }
    }

    public static void assertNoUnresolvedProxies(String message, Resource resource) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedProxies.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(unresolvedProxies.size());
            s.append(" unresolved proxies in '" + resource.getURI() + "' ");
            s.append(message);
            for (Map.Entry unresolvedProxy : unresolvedProxies.entrySet()) {
                s.append("\n");
                BasicEObjectImpl key = (BasicEObjectImpl)unresolvedProxy.getKey();
                s.append(key.eProxyURI());
                for (EStructuralFeature.Setting setting : (Collection)unresolvedProxy.getValue()) {
                    s.append("\n\t");
                    EObject eObject = setting.getEObject();
                    s.append(eObject.toString());
                }
            }
            assert (false) : s.toString();
        }
    }

    public static void assertNoValidationErrors(@NonNull String prefix, @NonNull Resource resource) {
        for (EObject eObject : resource.getContents()) {
            CompilerUtil.assertNoValidationErrors(String.valueOf(prefix) + " of '" + resource.getURI() + "'", eObject);
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, EObject eObject) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(string) + ": " + children.size() + " validation errors");
        for (Diagnostic child : children) {
            Object data;
            s.append("\n\t");
            if (child.getData().size() > 0 && (data = child.getData().get(0)) instanceof Element) {
                Element eScope = (Element)data;
                while (eScope instanceof Element) {
                    eScope = eScope.eContainer();
                }
            }
            s.append(child.getMessage());
        }
        assert (false) : s.toString();
    }

    public static @NonNull List<@NonNull String> createClasspathProjectNameList(String ... projectNames) {
        ArrayList<@NonNull String> classProjectNames = new ArrayList<String>();
        classProjectNames.add("org.eclipse.qvtd.runtime");
        classProjectNames.add("org.eclipse.ocl.pivot");
        classProjectNames.add("org.eclipse.emf.ecore");
        classProjectNames.add("org.eclipse.emf.common");
        classProjectNames.add("org.eclipse.jdt.annotation");
        classProjectNames.add("org.eclipse.osgi");
        if (projectNames != null) {
            String[] stringArray = projectNames;
            int n = projectNames.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String projectName = stringArray[n2];
                classProjectNames.add(0, projectName);
                ++n2;
            }
        }
        return classProjectNames;
    }

    public static @NonNull List<@NonNull String> createClassPathProjectList(@NonNull URIConverter uriConverter, @NonNull List<@NonNull String> projectNames) {
        ArrayList<@NonNull String> classpathProjectList = new ArrayList<String>();
        for (String projectName : projectNames) {
            File path = JavaFileUtil.getProjectBinFolder((URIConverter)uriConverter, (String)projectName);
            if (path == null) continue;
            classpathProjectList.add(String.valueOf(path));
        }
        return classpathProjectList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull String> createClassPathProjectList(@NonNull URIConverter uriConverter, @NonNull String projectName, @NonNull String classFilePath, @Nullable Iterable<@NonNull String> projectNames) {
        assert (EcorePlugin.IS_ECLIPSE_RUNNING);
        if (projectNames == null) {
            projectNames = CompilerUtil.createClasspathProjectNameList(projectName);
        }
        @NonNull ArrayList projectNames2 = Lists.newArrayList(projectNames);
        projectNames2.remove(projectName);
        @NonNull List classpathProjects = JavaFileUtil.createClassPathProjectList((URIConverter)uriConverter, (List)projectNames2);
        classpathProjects.add(0, classFilePath);
        return classpathProjects;
    }

    public static <T> @NonNull Map<T, @NonNull Set<T>> computeClosure(@NonNull Map<T, @NonNull Set<T>> from2tos) {
        Set<T> tos = from2tos.keySet();
        HashMap<T, @NonNull HashSet<E>> from2tosClosure = new HashMap();
        for (Object from : tos) {
            from2tosClosure.put(from, new HashSet(from2tos.get(from)));
        }
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (T from : from2tos.keySet()) {
                Set fromTos = (Set)from2tosClosure.get(from);
                assert (fromTos != null);
                for (Object fromTo : new ArrayList(fromTos)) {
                    Set fromToTos = (Set)from2tosClosure.get(fromTo);
                    assert (fromToTos != null);
                    if (!fromTos.addAll(fromToTos)) continue;
                    isChanged = true;
                }
            }
        }
        return from2tosClosure;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <PR extends PartialRegion<PR, TC, TP>, TC extends TraceClass<PR, TC, TP>, TP extends TraceProperty<PR, TC, TP>> @NonNull Map<@NonNull PR, @NonNull Set<@NonNull PR>> computeImmediatePredecessors(@NonNull Iterable<@NonNull PR> regionAnalyses) {
        HashMap<@NonNull PartialRegion, @NonNull HashSet<@NonNull E>> consumer2producers = new HashMap();
        for (PartialRegion regionAnalysis : regionAnalyses) {
            consumer2producers.put(regionAnalysis, new HashSet());
        }
        for (PartialRegion consumer : regionAnalyses) {
            Iterable consumedTracePropertyAnalyses;
            Iterable consumedTraceClassAnalyses;
            Iterable<@NonNull PR> explicitPredecessors = consumer.getExplicitPredecessors();
            if (explicitPredecessors != null) {
                for (PartialRegion explicitPredecessor : explicitPredecessors) {
                    Set producers = (Set)consumer2producers.get(consumer);
                    assert (producers != null);
                    producers.add(explicitPredecessor);
                }
            }
            if ((consumedTraceClassAnalyses = consumer.getConsumedTraceClassAnalyses()) != null) {
                for (TraceClass consumedTraceClassAnalysis : consumedTraceClassAnalyses) {
                    for (TraceClass subConsumedTraceClass : consumedTraceClassAnalysis.getSubTraceClassAnalyses()) {
                        for (PartialRegion producer : subConsumedTraceClass.getProducers()) {
                            @NonNull Set producers = (Set)consumer2producers.get(consumer);
                            assert (producers != null);
                            producers.add(producer);
                        }
                    }
                }
            }
            if ((consumedTracePropertyAnalyses = consumer.getConsumedTracePropertyAnalyses()) == null) continue;
            for (TraceProperty consumedTracePropertyAnalysis : consumedTracePropertyAnalyses) {
                for (PartialRegion producer : consumedTracePropertyAnalysis.getProducers()) {
                    @NonNull Set producers = (Set)consumer2producers.get(consumer);
                    assert (producers != null);
                    producers.add(producer);
                }
            }
        }
        return consumer2producers;
    }

    public static <T> @NonNull Map<T, @NonNull Set<T>> computeInverseClosure(@NonNull Map<T, @NonNull Set<T>> from2tos) {
        HashMap<T, @NonNull HashSet<E>> to2froms = new HashMap();
        Set<T> froms = from2tos.keySet();
        for (T to : froms) {
            to2froms.put(to, new HashSet());
        }
        for (T from : froms) {
            Set<T> fromTos = from2tos.get(from);
            assert (fromTos != null);
            for (T fromTo : fromTos) {
                Set fromToFroms = (Set)to2froms.get(fromTo);
                assert (fromToFroms != null);
                fromToFroms.add(from);
            }
        }
        return to2froms;
    }

    public static @NonNull List<@NonNull Concurrency> computeParallelSchedule(@NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors) {
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partition2successors = CompilerUtil.computeTransitiveSuccessors(partitionAnalysis2predecessors);
        ArrayList<@NonNull Concurrency> parallelSchedule = new ArrayList<Concurrency>();
        HashSet<@NonNull PartitionAnalysis> scheduledPartitionAnalyses = new HashSet<PartitionAnalysis>();
        HashSet<@NonNull PartitionAnalysis> scheduleCandidates = new HashSet<PartitionAnalysis>(partitionAnalysis2predecessors.keySet());
        while (!scheduleCandidates.isEmpty()) {
            Concurrency nextConcurrency = new Concurrency();
            HashSet<@NonNull PartitionAnalysis> nextScheduleCandidates = new HashSet<PartitionAnalysis>();
            for (PartitionAnalysis partitionAnalysis : scheduleCandidates) {
                Set<@NonNull PartitionAnalysis> predecessors = partitionAnalysis2predecessors.get(partitionAnalysis);
                assert (predecessors != null);
                HashSet<@NonNull PartitionAnalysis> unscheduledPredecessors = new HashSet<PartitionAnalysis>(predecessors);
                assert (unscheduledPredecessors != null);
                unscheduledPredecessors.remove(partitionAnalysis);
                unscheduledPredecessors.removeAll(scheduledPartitionAnalyses);
                if (!unscheduledPredecessors.isEmpty()) continue;
                nextConcurrency.add(partitionAnalysis);
                Set<@NonNull PartitionAnalysis> unscheduledSuccessors = partition2successors.get(partitionAnalysis);
                assert (unscheduledSuccessors != null);
                nextScheduleCandidates.addAll(unscheduledSuccessors);
            }
            assert (nextConcurrency.size() > 0);
            parallelSchedule.add(nextConcurrency);
            for (PartitionAnalysis partitionAnalysis : nextConcurrency) {
                nextScheduleCandidates.remove(partitionAnalysis);
                scheduledPartitionAnalyses.add(partitionAnalysis);
            }
            scheduleCandidates = nextScheduleCandidates;
        }
        return parallelSchedule;
    }

    public static <PR extends PartialRegion<PR, TC, TP>, TC extends TraceClass<PR, TC, TP>, TP extends TraceProperty<PR, TC, TP>> @NonNull Map<@NonNull PR, @NonNull Set<@NonNull PR>> computeTransitivePredecessors(@NonNull Iterable<@NonNull PR> regionAnalyses) {
        Map<@NonNull PR, @NonNull Set<@NonNull PR>> consumer2producers = CompilerUtil.computeImmediatePredecessors(regionAnalyses);
        if (TransformationPartitioner.PREDECESSORS.isActive()) {
            for (PartialRegion successor : regionAnalyses) {
                StringBuilder s = new StringBuilder();
                s.append(successor + ":");
                ArrayList<@NonNull E> producers = new ArrayList(consumer2producers.get(successor));
                Collections.sort(producers, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegion producer : producers) {
                    s.append(" " + producer);
                }
                TransformationPartitioner.PREDECESSORS.println(s.toString());
            }
        }
        Map<@NonNull PR, @NonNull Set<@NonNull PR>> consumer2producersClosure = CompilerUtil.computeClosure(consumer2producers);
        if (TransformationPartitioner.PREDECESSORS.isActive()) {
            for (PartialRegion successor : regionAnalyses) {
                StringBuilder s = new StringBuilder();
                s.append(successor + ":");
                ArrayList<@NonNull E> producers = new ArrayList(consumer2producersClosure.get(successor));
                Collections.sort(producers, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegion producer : producers) {
                    s.append(" " + producer);
                }
                TransformationPartitioner.PREDECESSORS.println(s.toString());
            }
        }
        return consumer2producersClosure;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <PR extends Nameable> @NonNull Map<@NonNull PR, @NonNull Set<@NonNull PR>> computeTransitiveSuccessors(@NonNull Map<@NonNull PR, @NonNull Set<@NonNull PR>> partition2predecessors) {
        HashMap<@NonNull Nameable, @NonNull HashSet<@NonNull E>> producer2consumersClosure = new HashMap();
        Set<@NonNull PR> partitions = partition2predecessors.keySet();
        for (Nameable predecessor : partitions) {
            producer2consumersClosure.put(predecessor, new HashSet());
        }
        for (Nameable successor : partitions) {
            @NonNull Iterable predecessors = partition2predecessors.get(successor);
            assert (predecessors != null);
            for (Nameable predecessor : predecessors) {
                @NonNull Set successors = (Set)producer2consumersClosure.get(predecessor);
                assert (successors != null);
                successors.add(successor);
            }
        }
        if (TransformationPartitioner.SUCCESSORS.isActive()) {
            for (Nameable predecessor : partitions) {
                StringBuilder s = new StringBuilder();
                s.append(predecessor + ":");
                ArrayList<@NonNull E> consumers = new ArrayList((Collection)producer2consumersClosure.get(predecessor));
                Collections.sort(consumers, NameUtil.NAMEABLE_COMPARATOR);
                for (Nameable consumer : consumers) {
                    s.append(" " + consumer);
                }
                TransformationPartitioner.SUCCESSORS.println(s.toString());
            }
        }
        return producer2consumersClosure;
    }

    public static @NonNull PartitionProblem createPartitionError(@NonNull Partition partition, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new PartitionProblem(CompilerProblem.Severity.ERROR, partition, boundMessage);
    }

    public static @NonNull PartitionProblem createPartitionWarning(@NonNull Partition partition, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new PartitionProblem(CompilerProblem.Severity.WARNING, partition, boundMessage);
    }

    public static @NonNull RegionProblem createRegionError(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new RegionProblem(CompilerProblem.Severity.ERROR, region, boundMessage);
    }

    public static @NonNull RegionProblem createRegionWarning(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new RegionProblem(CompilerProblem.Severity.WARNING, region, boundMessage);
    }

    public static @NonNull List<@NonNull PartitionAnalysis> gatherPartitionAnalyses(@NonNull CompositePartitionAnalysis rootPartitionAnalysis, @NonNull List<@NonNull PartitionAnalysis> allPartitionAnalyses) {
        for (PartitionAnalysis partitionAnalysis : rootPartitionAnalysis.getPartitionAnalyses()) {
            assert (!allPartitionAnalyses.contains(partitionAnalysis));
            if (partitionAnalysis instanceof CompositePartitionAnalysis) {
                CompilerUtil.gatherPartitionAnalyses((CompositePartitionAnalysis)partitionAnalysis, allPartitionAnalyses);
                continue;
            }
            allPartitionAnalyses.add(partitionAnalysis);
        }
        return allPartitionAnalyses;
    }

    public static void indent(@NonNull StringBuilder s, int depth) {
        int i = 0;
        while (i < depth) {
            s.append("    ");
            ++i;
        }
    }

    public static boolean isAbstract(@NonNull Partition partition) {
        Region originalRegion = partition.getRegion();
        if (originalRegion instanceof RuleRegion) {
            if (originalRegion instanceof DispatchRegion) {
                return false;
            }
            if (originalRegion instanceof VerdictRegion) {
                return false;
            }
            return ((RuleRegion)originalRegion).getReferredRule().isIsAbstract();
        }
        if (originalRegion instanceof DispatchRegion) {
            return false;
        }
        return false;
    }

    public static void normalizeNameables(@NonNull List<@NonNull ? extends Nameable> nameables) {
        if (nameables instanceof EList) {
            ECollections.sort((EList)((EList)nameables), (Comparator)NameUtil.NAMEABLE_COMPARATOR);
        } else {
            Collections.sort(nameables, NameUtil.NAMEABLE_COMPARATOR);
        }
    }

    public static @Nullable String recoverVariableName(@NonNull NamedElement namedElement) {
        OCLExpression source;
        OperationCallExp operationCallExp;
        EObject eContainer = namedElement.eContainer();
        EReference eContainmentFeature = namedElement.eContainmentFeature();
        if (eContainmentFeature == PivotPackage.Literals.VARIABLE__OWNED_INIT && eContainer instanceof Variable) {
            return ((Variable)eContainer).getName();
        }
        if (eContainmentFeature == QVTcorePackage.Literals.ASSIGNMENT__VALUE && eContainer instanceof VariableAssignment) {
            return ((VariableAssignment)eContainer).getTargetVariable().getName();
        }
        if (eContainmentFeature == PivotPackage.Literals.CALL_EXP__OWNED_SOURCE && eContainer instanceof OperationCallExp) {
            OCLExpression argument;
            OperationCallExp operationCallExp2 = (OperationCallExp)eContainer;
            if (PivotUtil.isSameOperation((OperationId)operationCallExp2.getReferredOperation().getOperationId(), (OperationId)OperationId.OCLANY_EQUALS) && (argument = PivotUtil.getOwnedArgument((OperationCallExp)operationCallExp2, (int)0)) instanceof VariableExp) {
                return PivotUtil.getReferredVariable((VariableExp)((VariableExp)argument)).getName();
            }
        } else if (eContainmentFeature == PivotPackage.Literals.OPERATION_CALL_EXP__OWNED_ARGUMENTS && eContainer instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationCallExp = (OperationCallExp)eContainer).getReferredOperation().getOperationId(), (OperationId)OperationId.OCLANY_EQUALS) && (source = PivotUtil.getOwnedSource((CallExp)operationCallExp)) instanceof VariableExp) {
            return PivotUtil.getReferredVariable((VariableExp)((VariableExp)source)).getName();
        }
        return null;
    }

    public static <T> void removeAll(@NonNull Collection<T> removeFrom, @NonNull Iterable<T> elementsToTemove) {
        for (T element : elementsToTemove) {
            removeFrom.remove(element);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void throwExceptionWithProblems(@NonNull CodeGenerator codeGenerator, @NonNull Exception e) throws Exception {
        @NonNull List problems = codeGenerator.getProblems();
        if (problems != null) {
            StringBuilder s = new StringBuilder();
            for (Exception ex : problems) {
                s.append(String.valueOf(ex.toString()) + "\n");
            }
            s.append(e.toString());
            throw new CompilerChainException(e, s.toString(), new Object[0]);
        }
        throw e;
    }

    public static interface PartialRegion<PR, TC, TP>
    extends Nameable {
        public @Nullable Iterable<@NonNull TC> getConsumedTraceClassAnalyses();

        public @Nullable Iterable<@NonNull TP> getConsumedTracePropertyAnalyses();

        public @Nullable Iterable<@NonNull PR> getExplicitPredecessors();
    }

    public static interface TraceClass<PR, TC, TP>
    extends Nameable {
        public @NonNull Iterable<@NonNull PR> getProducers();

        public @NonNull Iterable<@NonNull TC> getSubTraceClassAnalyses();
    }

    public static interface TraceProperty<PR, TC, TP>
    extends Nameable {
        public @NonNull Iterable<@NonNull PR> getProducers();
    }
}

