/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.text.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.text.StringNode;
import org.eclipse.qvtd.text.TextModelFactory;

public class TextModelResourceImpl
extends ResourceImpl {
    public TextModelResourceImpl(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        this.doLoad(reader, options);
    }

    public void doLoad(Reader reader, Map<?, ?> options) throws IOException {
        String line;
        BufferedReader lineReader = new BufferedReader(reader);
        Stack<@NonNull StringNode> treeNodes = new Stack<StringNode>();
        Stack<@NonNull String> indentations = new Stack<String>();
        StringNode rootNode = TextModelFactory.eINSTANCE.createStringNode();
        rootNode.setSeparator("\n");
        rootNode.setSuffix("\n");
        this.getContents().add((Object)rootNode);
        treeNodes.push(rootNode);
        indentations.push(rootNode.getIndent());
        while ((line = lineReader.readLine()) != null) {
            int outerLineStart;
            String indentation = (String)indentations.peek();
            while (!line.startsWith(indentation)) {
                treeNodes.pop();
                indentations.pop();
                indentation = (String)indentations.peek();
            }
            int innerLineStart = outerLineStart = indentation.length();
            while (innerLineStart < line.length()) {
                char c = line.charAt(innerLineStart);
                if (!Character.isWhitespace(c)) break;
                ++innerLineStart;
            }
            StringNode node = TextModelFactory.eINSTANCE.createStringNode();
            node.setText(line.substring(innerLineStart));
            if (outerLineStart == innerLineStart && treeNodes.size() > 1) {
                StringNode sibling = (StringNode)treeNodes.pop();
                node.setIndent(sibling.getIndent());
            } else {
                String extraIndentation = line.substring(outerLineStart, innerLineStart);
                node.setIndent(extraIndentation);
                indentations.push(String.valueOf(indentation) + extraIndentation);
            }
            StringNode parent = (StringNode)treeNodes.peek();
            if (parent != rootNode) {
                parent.setSeparator("\n");
                parent.setPrefix("\n");
            }
            parent.getChildren().add((Object)node);
            treeNodes.push(node);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        this.doSave(writer, options);
    }

    protected void doSave(Writer writer, Map<?, ?> options) throws IOException {
        TextModelSave saveHelper = new TextModelSave();
        saveHelper.traverse((List<? extends EObject>)this.getContents());
        writer.append(saveHelper.toString());
        writer.flush();
        writer.close();
    }

    public static class TextModelLoadImpl
    extends XMILoadImpl {
        public TextModelLoadImpl(XMLHelper helper) {
            super(helper);
        }
    }

    public static class TextModelSave {
        protected final @NonNull StringBuilder s = new StringBuilder();
        protected final @NonNull Stack<@NonNull String> indentStack = new Stack();
        private boolean indentPending = true;

        public TextModelSave() {
            this.indentStack.push("");
        }

        protected void append(@NonNull String text) {
            int iSize = text.length();
            int i = 0;
            while (i < iSize) {
                char c = text.charAt(i);
                if (!this.indentPending) {
                    this.s.append(c);
                    if (c == '\n') {
                        this.indentPending = true;
                    }
                } else if (c != '\n') {
                    this.s.append(this.indentStack.peek());
                    this.indentPending = false;
                    this.s.append(c);
                } else {
                    this.s.append(c);
                    this.indentPending = true;
                }
                ++i;
            }
        }

        public @NonNull String toString() {
            return this.s.toString();
        }

        public void traverse(List<? extends EObject> contents) {
            for (EObject eObject : contents) {
                if (!(eObject instanceof StringNode)) continue;
                this.traverseNode((StringNode)eObject);
            }
        }

        protected void traverseNode(@NonNull StringNode node) {
            String childIndent = String.valueOf(this.indentStack.peek()) + node.getIndent();
            this.indentStack.push(childIndent);
            this.append(node.getText());
            EList<StringNode> children = node.getChildren();
            if (children.size() > 0) {
                this.append(node.getPrefix());
                String separator = null;
                for (StringNode child : children) {
                    if (separator != null) {
                        this.append(separator);
                    } else {
                        separator = node.getSeparator();
                    }
                    this.traverseNode(child);
                }
                this.append(node.getSuffix());
            }
            this.append(node.getEndText());
            this.indentStack.pop();
        }
    }
}

