/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;

public class Concurrency
implements Iterable<PartitionAnalysis> {
    protected final @NonNull Set<@NonNull PartitionAnalysis> partitionAnalyses = new HashSet<PartitionAnalysis>();
    private boolean isCycleStart = false;
    private boolean isCycleEnd = false;
    private @Nullable Integer passNumber = null;

    public boolean add(@NonNull PartitionAnalysis partitionAnalysis) {
        return this.partitionAnalyses.add(partitionAnalysis);
    }

    public void addPass(int cyclePass) {
        for (PartitionAnalysis partitionAnalysis : this.partitionAnalyses) {
            partitionAnalysis.getPartition().addPass(cyclePass);
        }
    }

    public @NonNull Iterable<@NonNull PartitionAnalysis> getPartitionAnalyses() {
        return this.partitionAnalyses;
    }

    public boolean isCycleEnd() {
        return this.isCycleEnd;
    }

    public boolean isCycleStart() {
        return this.isCycleStart;
    }

    @Override
    public @NonNull Iterator<@NonNull PartitionAnalysis> iterator() {
        return this.partitionAnalyses.iterator();
    }

    void setPass(int passNumber) {
        assert (this.passNumber == null);
        this.passNumber = passNumber;
        for (PartitionAnalysis partitionAnalysis : this.partitionAnalyses) {
            partitionAnalysis.getPartition().setPass(passNumber);
        }
    }

    public int size() {
        return this.partitionAnalyses.size();
    }

    public void setCycleStart() {
        this.isCycleStart = true;
    }

    public void setCycleEnd() {
        this.isCycleEnd = true;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(this.passNumber);
        if (this.isCycleStart) {
            s.append(", \u00abstart\u00bb");
        }
        if (this.isCycleEnd) {
            s.append(", \u00abend\u00bb");
        }
        for (PartitionAnalysis partitionAnalysis : this.partitionAnalyses) {
            s.append(", ");
            s.append(partitionAnalysis);
        }
        s.append("]");
        return s.toString();
    }
}

