/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.tests;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.InheritanceAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDependencyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDependencyPaths;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDependencyStep;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.analysis.QVTcoreDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.junit.Test;

public class AnalysisTests
extends XtextTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        OCLstdlib.install();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testContainmentAnalysis_ContainerClass_Ecore() throws ParserException {
        OCLInternal ocl = OCLInternal.newInstance();
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
        StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        CompleteClass oclAnyClass = completeModel.getCompleteClass((Type)standardLibrary.getOclAnyType());
        String ecoreNsUri = (String)ClassUtil.nonNullState((Object)"http://www.eclipse.org/emf/2002/Ecore");
        ClassUtil.nonNullState((Object)metamodelManager.loadResource(URI.createURI((String)ecoreNsUri), "", environmentFactory.getResourceSet()));
        CompletePackage ecorePackage = (CompletePackage)ClassUtil.nonNullState((Object)completeModel.getCompletePackageByURI(ecoreNsUri));
        CompleteClass eAnnotationClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EANNOTATION.getName()));
        CompleteClass eAttributeClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EATTRIBUTE.getName()));
        CompleteClass eClassClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ECLASS.getName()));
        CompleteClass eClassifierClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ECLASSIFIER.getName()));
        CompleteClass eDataTypeClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EDATA_TYPE.getName()));
        CompleteClass eEnumClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EENUM.getName()));
        CompleteClass eEnumLiteralClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EENUM_LITERAL.getName()));
        CompleteClass eFactoryClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EFACTORY.getName()));
        CompleteClass eGenericTypeClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EGENERIC_TYPE.getName()));
        CompleteClass eModelElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EMODEL_ELEMENT.getName()));
        CompleteClass eNamedElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ENAMED_ELEMENT.getName()));
        CompleteClass eOperationClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EOPERATION.getName()));
        CompleteClass ePackageClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EPACKAGE.getName()));
        CompleteClass eParameterClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EPARAMETER.getName()));
        CompleteClass eReferenceClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EREFERENCE.getName()));
        CompleteClass eStructuralFeatureClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName()));
        CompleteClass eTypeParameterClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ETYPE_PARAMETER.getName()));
        CompleteClass eTypedElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ETYPED_ELEMENT.getName()));
        ContainmentAnalysis containmentAnalysis = new ContainmentAnalysis((EnvironmentFactory)environmentFactory);
        @NonNull HashSet oclAnyContainerClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(oclAnyClass));
        AnalysisTests.assertEquals((int)0, (int)oclAnyContainerClasses.size());
        @NonNull HashSet eAnnotationContainerClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eAnnotationClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{eAnnotationClass, eAttributeClass, eClassClass, eClassifierClass, eDataTypeClass, eEnumClass, eEnumLiteralClass, eFactoryClass, eModelElementClass, eNamedElementClass, eOperationClass, ePackageClass, eParameterClass, eReferenceClass, eStructuralFeatureClass, eTypeParameterClass, eTypedElementClass}), (Object)eAnnotationContainerClasses);
        @NonNull HashSet eStructuralFeatureContainerClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eStructuralFeatureClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{eClassClass}), (Object)eStructuralFeatureContainerClasses);
        @NonNull HashSet eReferenceSubClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eReferenceClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{eClassClass}), (Object)eReferenceSubClasses);
        @NonNull HashSet eClassifierSubClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eClassifierClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{ePackageClass}), (Object)eClassifierSubClasses);
        @NonNull HashSet eTypedElementContainerClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eTypedElementClass));
        AnalysisTests.assertEquals((int)0, (int)eTypedElementContainerClasses.size());
        @NonNull HashSet eModelElementContainerClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eModelElementClass));
        AnalysisTests.assertEquals((int)0, (int)eModelElementContainerClasses.size());
        @NonNull HashSet eGenericTypeContainerClasses = Sets.newHashSet((Iterable)containmentAnalysis.getContainerClasses(eGenericTypeClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{eAttributeClass, eClassClass, eGenericTypeClass, eOperationClass, eParameterClass, eReferenceClass, eStructuralFeatureClass, eTypeParameterClass, eTypedElementClass}), (Object)eGenericTypeContainerClasses);
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testContainmentAnalysis_ContainmentProperty_Ecore() throws ParserException {
        OCLInternal ocl = OCLInternal.newInstance();
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
        StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        CompleteClass oclAnyClass = completeModel.getCompleteClass((Type)standardLibrary.getOclAnyType());
        String ecoreNsUri = (String)ClassUtil.nonNullState((Object)"http://www.eclipse.org/emf/2002/Ecore");
        ClassUtil.nonNullState((Object)metamodelManager.loadResource(URI.createURI((String)ecoreNsUri), "", environmentFactory.getResourceSet()));
        CompletePackage ecorePackage = (CompletePackage)ClassUtil.nonNullState((Object)completeModel.getCompletePackageByURI(ecoreNsUri));
        CompleteClass eAnnotationClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EANNOTATION.getName()));
        CompleteClass eClassClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ECLASS.getName()));
        CompleteClass eClassifierClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ECLASSIFIER.getName()));
        CompleteClass eGenericTypeClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EGENERIC_TYPE.getName()));
        CompleteClass eModelElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EMODEL_ELEMENT.getName()));
        CompleteClass eOperationClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EOPERATION.getName()));
        CompleteClass ePackageClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EPACKAGE.getName()));
        CompleteClass eReferenceClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EREFERENCE.getName()));
        CompleteClass eStructuralFeatureClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName()));
        CompleteClass eTypeParameterClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ETYPE_PARAMETER.getName()));
        CompleteClass eTypedElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ETYPED_ELEMENT.getName()));
        Property eClass__eGenericSuperType = (Property)ClassUtil.nonNullState((Object)eClassClass.getProperty(EcorePackage.Literals.ECLASS__EGENERIC_SUPER_TYPES.getName()));
        Property eClass__eStructuralFeatures = (Property)ClassUtil.nonNullState((Object)eClassClass.getProperty(EcorePackage.Literals.ECLASS__ESTRUCTURAL_FEATURES.getName()));
        Property eGenericType__eLowerBound = (Property)ClassUtil.nonNullState((Object)eGenericTypeClass.getProperty(EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND.getName()));
        Property eGenericType__eTypeArguments = (Property)ClassUtil.nonNullState((Object)eGenericTypeClass.getProperty(EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS.getName()));
        Property eGenericType__eUpperBound = (Property)ClassUtil.nonNullState((Object)eGenericTypeClass.getProperty(EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND.getName()));
        Property eModelElement__eAnnotations = (Property)ClassUtil.nonNullState((Object)eModelElementClass.getProperty(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS.getName()));
        Property eOperation__eGenericExceptions = (Property)ClassUtil.nonNullState((Object)eOperationClass.getProperty(EcorePackage.Literals.EOPERATION__EGENERIC_EXCEPTIONS.getName()));
        Property ePackage__eClassifiers = (Property)ClassUtil.nonNullState((Object)ePackageClass.getProperty(EcorePackage.Literals.EPACKAGE__ECLASSIFIERS.getName()));
        Property eTypedElement__eGenericType = (Property)ClassUtil.nonNullState((Object)eTypedElementClass.getProperty(EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE.getName()));
        Property eTypeParameter__eBounds = (Property)ClassUtil.nonNullState((Object)eTypeParameterClass.getProperty(EcorePackage.Literals.ETYPE_PARAMETER__EBOUNDS.getName()));
        ContainmentAnalysis containmentAnalysis = new ContainmentAnalysis((EnvironmentFactory)environmentFactory);
        @NonNull HashSet oclAnyContainerProperties = Sets.newHashSet((Iterable)containmentAnalysis.getContainmentProperties(oclAnyClass));
        AnalysisTests.assertEquals((int)0, (int)oclAnyContainerProperties.size());
        @NonNull HashSet eAnnotationContainerProperties = Sets.newHashSet((Iterable)containmentAnalysis.getContainmentProperties(eAnnotationClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new Property[]{eModelElement__eAnnotations}), (Object)eAnnotationContainerProperties);
        @NonNull HashSet eStructuralFeatureContainerProperties = Sets.newHashSet((Iterable)containmentAnalysis.getContainmentProperties(eStructuralFeatureClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new Property[]{eClass__eStructuralFeatures}), (Object)eStructuralFeatureContainerProperties);
        @NonNull HashSet eReferenceSubProperties = Sets.newHashSet((Iterable)containmentAnalysis.getContainmentProperties(eReferenceClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new Property[]{eClass__eStructuralFeatures}), (Object)eReferenceSubProperties);
        @NonNull HashSet eClassifierSubProperties = Sets.newHashSet((Iterable)containmentAnalysis.getContainmentProperties(eClassifierClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new Property[]{ePackage__eClassifiers}), (Object)eClassifierSubProperties);
        @NonNull HashSet eGenericTypeSubProperties = Sets.newHashSet((Iterable)containmentAnalysis.getContainmentProperties(eGenericTypeClass));
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new Property[]{eClass__eGenericSuperType, eGenericType__eLowerBound, eGenericType__eTypeArguments, eGenericType__eUpperBound, eOperation__eGenericExceptions, eTypeParameter__eBounds, eTypedElement__eGenericType}), (Object)eGenericTypeSubProperties);
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInheritanceAnalysis_SuperClass_Ecore() throws ParserException {
        OCLInternal ocl = OCLInternal.newInstance();
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
        StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        CompleteClass oclAnyClass = completeModel.getCompleteClass((Type)standardLibrary.getOclAnyType());
        CompleteClass oclElementClass = completeModel.getCompleteClass((Type)standardLibrary.getOclElementType());
        String ecoreNsUri = (String)ClassUtil.nonNullState((Object)"http://www.eclipse.org/emf/2002/Ecore");
        ClassUtil.nonNullState((Object)metamodelManager.loadResource(URI.createURI((String)ecoreNsUri), "", environmentFactory.getResourceSet()));
        CompletePackage ecorePackage = (CompletePackage)ClassUtil.nonNullState((Object)completeModel.getCompletePackageByURI(ecoreNsUri));
        CompleteClass eAnnotationClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EANNOTATION.getName()));
        CompleteClass eAttributeClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EATTRIBUTE.getName()));
        CompleteClass eModelElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EMODEL_ELEMENT.getName()));
        CompleteClass eNamedElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ENAMED_ELEMENT.getName()));
        CompleteClass eReferenceClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EREFERENCE.getName()));
        CompleteClass eStructuralFeatureClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName()));
        CompleteClass eTypedElementClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ETYPED_ELEMENT.getName()));
        InheritanceAnalysis inheritanceAnalysis = new InheritanceAnalysis((EnvironmentFactory)environmentFactory);
        @NonNull Set eAnnotationSuperClasses = inheritanceAnalysis.getAllSuperAndSelfAndSubClasses(eAnnotationClass);
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{oclAnyClass, oclElementClass, eModelElementClass, eAnnotationClass}), (Object)eAnnotationSuperClasses);
        @NonNull Set eStructuralFeatureSuperClasses = inheritanceAnalysis.getAllSuperAndSelfAndSubClasses(eStructuralFeatureClass);
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{oclAnyClass, oclElementClass, eAttributeClass, eModelElementClass, eNamedElementClass, eReferenceClass, eStructuralFeatureClass, eTypedElementClass}), (Object)eStructuralFeatureSuperClasses);
        @NonNull Set eReferenceSuperClasses = inheritanceAnalysis.getAllSuperAndSelfAndSubClasses(eReferenceClass);
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{oclAnyClass, oclElementClass, eModelElementClass, eNamedElementClass, eReferenceClass, eStructuralFeatureClass, eTypedElementClass}), (Object)eReferenceSuperClasses);
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInheritanceAnalysis_SubClass_Ecore() throws ParserException {
        OCLInternal ocl = OCLInternal.newInstance();
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        String ecoreNsUri = (String)ClassUtil.nonNullState((Object)"http://www.eclipse.org/emf/2002/Ecore");
        ClassUtil.nonNullState((Object)metamodelManager.loadResource(URI.createURI((String)ecoreNsUri), "", environmentFactory.getResourceSet()));
        CompletePackage ecorePackage = (CompletePackage)ClassUtil.nonNullState((Object)completeModel.getCompletePackageByURI(ecoreNsUri));
        CompleteClass eAttributeClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EATTRIBUTE.getName()));
        CompleteClass eReferenceClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.EREFERENCE.getName()));
        CompleteClass eStructuralFeatureClass = (CompleteClass)ClassUtil.nonNullState((Object)ecorePackage.getOwnedCompleteClass(EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName()));
        InheritanceAnalysis inheritanceAnalysis = new InheritanceAnalysis((EnvironmentFactory)environmentFactory);
        @NonNull Set eReferenceSubClasses = inheritanceAnalysis.getAllSelfAndSubClasses(eReferenceClass);
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{eReferenceClass}), (Object)eReferenceSubClasses);
        @NonNull Set eStructuralFeatureSubClasses = inheritanceAnalysis.getAllSelfAndSubClasses(eStructuralFeatureClass);
        AnalysisTests.assertEquals((Object)Sets.newHashSet((Object[])new CompleteClass[]{eAttributeClass, eReferenceClass, eStructuralFeatureClass}), (Object)eStructuralFeatureSubClasses);
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testOperationDependencyAnalysis_Companies() throws ParserException {
        TestUtil.doCompleteOCLSetup();
        XtextCompilerUtil.doQVTcoreSetup();
        OCLInternal ocl = OCLInternal.newInstance();
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        URI qvtcURI = URI.createPlatformResourceURI((String)(String.valueOf(((Object)((Object)this)).getClass().getPackage().getName()) + "/src/" + this.getProjectName() + "/companies/CompaniesCS2AS.qvtc"), (boolean)true);
        BaseCSResource csResource = (BaseCSResource)environmentFactory.getResourceSet().getResource(qvtcURI, true);
        ASResource asResource = csResource.getASResource();
        Model asModel = (Model)asResource.getContents().get(0);
        Transformation asTransformation = (Transformation)QVTcoreUtil.getAllTransformations((Model)asModel).get(0);
        ContainmentAnalysis containmentAnalysis = new ContainmentAnalysis((EnvironmentFactory)environmentFactory);
        QVTcoreDomainUsageAnalysis domainAnalysis = new QVTcoreDomainUsageAnalysis((EnvironmentFactory)environmentFactory);
        domainAnalysis.analyzeTransformation(asTransformation, null);
        Mapping asMapping = (Mapping)NameUtil.getNameable((Iterable)asTransformation.getRule(), (String)"uemployee_2_Employee_mentor");
        Assignment asAssignment = (Assignment)asMapping.getBottomPattern().getAssignment().get(0);
        OCLExpression asExpression = asAssignment.getValue();
        OperationDependencyAnalysis operationDependencyAnalysis = new OperationDependencyAnalysis(containmentAnalysis, (RootDomainUsageAnalysis)domainAnalysis);
        OperationDependencyPaths analyze = operationDependencyAnalysis.analyze((OperationCallExp)asExpression);
        StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
        CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
        CompletePackage companyPackage = completeModel.getCompletePackageByURI("http://org.eclipse.qvtd.compiler.tests.companies/Company");
        CompleteClass employeeClass = companyPackage.getOwnedCompleteClass("Employee");
        CompleteClass companyClass = companyPackage.getOwnedCompleteClass("Company");
        Operation companyUnqualifiedEnvEmployee = (Operation)companyClass.getOperations(null, "_unqualified_env_Employee").iterator().next();
        Property companyDepts = companyClass.getProperty("depts");
        CompleteClass departmentClass = companyPackage.getOwnedCompleteClass("Department");
        Operation departmentGetEmployees = (Operation)departmentClass.getOperations(null, "getEmployees").iterator().next();
        Property departmentEmployees = departmentClass.getProperty("employees");
        Property departmentManager = departmentClass.getProperty("manager");
        Property departmentSubdepts = departmentClass.getProperty("subdepts");
        Set<@NonNull List<@NonNull Element>> actualReturns = this.toElements(analyze.getReturnPaths());
        HashSet<@NonNull @NonNull ArrayList> expectedReturns = new HashSet<ArrayList>();
        expectedReturns.add(Lists.newArrayList((Object[])new Element[]{employeeClass.getPrimaryClass()}));
        AnalysisTests.assertEquals(expectedReturns, actualReturns);
        Set<@NonNull List<@NonNull Element>> actualHiddens = this.toElements(analyze.getHiddenPaths());
        AnalysisTests.assertEquals((int)16, (int)actualHiddens.size());
        OCLExpression exp1 = ((ExpressionInOCL)departmentGetEmployees.getBodyExpression()).getOwnedBody();
        OCLExpression exp2 = ((OperationCallExp)exp1).getOwnedSource();
        OCLExpression exp3 = ((OperationCallExp)exp2).getOwnedSource();
        OCLExpression exp4 = ((OperationCallExp)exp3).getOwnedSource();
        OCLExpression exp5 = ((LoopExp)exp4).getOwnedBody();
        analyze = operationDependencyAnalysis.analyze((OperationCallExp)exp5);
        expectedReturns = new HashSet();
        expectedReturns.add(Lists.newArrayList((Object[])new Element[]{employeeClass.getPrimaryClass()}));
        AnalysisTests.assertEquals(expectedReturns, actualReturns);
        actualHiddens = this.toElements(analyze.getHiddenPaths());
        HashSet<@NonNull @NonNull ArrayList> expectedHiddens = new HashSet<ArrayList>();
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{standardLibrary.getOclElementType()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{employeeClass.getPrimaryClass()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass(), departmentEmployees}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass(), departmentManager}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass(), departmentSubdepts}));
        AnalysisTests.assertEquals(expectedHiddens, actualHiddens);
        exp1 = ((ExpressionInOCL)companyUnqualifiedEnvEmployee.getBodyExpression()).getOwnedBody();
        exp2 = (OCLExpression)((OperationCallExp)exp1).getOwnedArguments().get(0);
        analyze = operationDependencyAnalysis.analyze((OperationCallExp)exp2);
        actualReturns = this.toElements(analyze.getReturnPaths());
        expectedReturns = new HashSet();
        expectedReturns.add(Lists.newArrayList((Object[])new Element[]{employeeClass.getPrimaryClass()}));
        AnalysisTests.assertEquals(expectedReturns, actualReturns);
        actualHiddens = this.toElements(analyze.getHiddenPaths());
        expectedHiddens = new HashSet();
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{standardLibrary.getOclElementType()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{employeeClass.getPrimaryClass()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{companyClass.getPrimaryClass()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{companyClass.getPrimaryClass(), companyDepts}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass()}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass(), departmentEmployees}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass(), departmentManager}));
        expectedHiddens.add(Lists.newArrayList((Object[])new Element[]{departmentClass.getPrimaryClass(), departmentSubdepts}));
        AnalysisTests.assertEquals(expectedHiddens, actualHiddens);
        ocl.dispose();
    }

    private Set<@NonNull List<@NonNull Element>> toElements(@NonNull Iterable<@NonNull List<@NonNull OperationDependencyStep>> paths) {
        HashSet<@NonNull List<@NonNull Element>> newPaths = new HashSet<List<Element>>();
        for (List<OperationDependencyStep> path : paths) {
            ArrayList<@NonNull Element> newPath = new ArrayList<Element>();
            for (OperationDependencyStep step : path) {
                newPath.add(step.getPathElement());
            }
            newPaths.add(newPath);
        }
        return newPaths;
    }
}

