/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.qvtd.runtime.evaluation.AbstractInvocationManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.DefaultInterval;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;

public abstract class AbstractInvocationManagerInternal
extends AbstractInvocationManager {
    private final @NonNull List<@NonNull Interval> intervals = new ArrayList<Interval>();
    private final @NonNull List<@NonNull InvocationConstructor> invokers = new ArrayList<InvocationConstructor>();
    private volatile int nextIndex = Integer.MAX_VALUE;
    protected final @NonNull Executor executor;

    protected AbstractInvocationManagerInternal(@NonNull Executor executor) {
        this.executor = executor;
    }

    @Override
    public void addInvoker(@NonNull InvocationConstructor constructor) {
        assert (!this.invokers.contains(constructor));
        this.invokers.add(constructor);
    }

    @Override
    public @Nullable Interval basicGetInterval(int intervalIndex) {
        if (intervalIndex >= 0 && intervalIndex < this.intervals.size()) {
            return this.intervals.get(intervalIndex);
        }
        return null;
    }

    @Override
    public @NonNull Interval createInterval() {
        DefaultInterval interval = new DefaultInterval(this, this.intervals.size());
        return interval;
    }

    public @NonNull Iterable<@NonNull Invocation> debugGetAllInvocations() {
        ArrayList<@NonNull Invocation> allInvocations = new ArrayList<Invocation>();
        for (InvocationConstructor invoker : this.invokers) {
            Iterables.addAll(allInvocations, invoker.debugGetInvocations());
        }
        return allInvocations;
    }

    @Override
    public void diagnoseWorkLists(@NonNull StringBuilder s) {
        for (Interval interval : this.intervals) {
            interval.diagnoseWorkLists(s);
        }
    }

    @Override
    public boolean flush() {
        int index = this.nextIndex;
        while (index < this.intervals.size()) {
            this.nextIndex = index + 1;
            Interval nextInterval = this.intervals.get(index);
            AbstractTransformer.INVOCATIONS.println("--------" + index + "--------");
            nextInterval.flush();
            index = this.nextIndex;
        }
        for (Interval interval : this.intervals) {
            if (interval.isFlushed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Executor getExecutor() {
        return this.executor;
    }

    @Override
    public @NonNull Iterable<@NonNull Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public int getIntervalsSize() {
        return this.intervals.size();
    }

    @Override
    public @NonNull Iterable<@NonNull InvocationConstructor> getInvokers() {
        return this.invokers;
    }

    @Override
    public @NonNull Interval getRootInterval() {
        if (this.intervals.size() <= 0) {
            this.createInterval();
        }
        return this.intervals.get(0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public @NonNull Interval lazyCreateInterval(int intervalIndex) {
        if (intervalIndex >= 0) ** GOTO lbl4
        return this.createInterval();
lbl-1000:
        // 1 sources

        {
            new DefaultInterval(this, this.intervals.size());
lbl4:
            // 2 sources

            ** while (this.intervals.size() <= intervalIndex)
        }
lbl5:
        // 1 sources

        return this.intervals.get(intervalIndex);
    }

    @Override
    public void setInterval(@NonNull Interval interval) {
        int intervalIndex = interval.getIndex();
        assert (intervalIndex <= this.intervals.size());
        if (intervalIndex == this.intervals.size()) {
            this.intervals.add(interval);
        }
        assert (interval == this.intervals.get(intervalIndex));
    }

    @Override
    public void setWorkToDoAt(int intervalIndex) {
        if (intervalIndex < this.nextIndex) {
            this.nextIndex = intervalIndex;
        }
    }
}

